<?php

// +----------------------------------------------------------------------
// | 用户模型验证器
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

namespace app\ucenter\validate;

use think\Validate;

class UserAuth extends Validate
{
    
    /* 用户模型自动验证 */
    protected $rule = [
        'idcard_frant_id' => [
            'require',
        ],
        'idcard_hand_id' => [
            'require',
        ],
        'other_id' => [
            'number',
        ], 
    ];

    // edit 验证场景定义
    public function sceneInstall()
    {
         return $this->only(['account','password','email'])
        ->remove('account', 'unique');
    }
    // edit 验证场景定义
    public function sceneOauth()
    {
         return $this->only(['nickname']);
    }
    public function sceneChangepassword()
    {
        return $this->only(['password']);
    }
    public function sceneLogin()
    {
        return $this->only(['account','password','verify'])
        ->remove('account', 'unique')
        ->remove('password', 'confirm');
    }
    public function sceneRegister()
    {
        return $this->only(['mobile','password','nickname','email','verify']);
    }
    protected $message = [
        'account.require' => '登陆账号必填',
    ];
    /**
     * 验证码检查
     * @param unknown $value
     * @param unknown $rule
     * @param unknown $data
     */
    protected function checkCaptcha($value, $rule, $data)
    {
        if(captcha_check($value))
        {
            return true;
        }else {
            return '验证码错误';
        }
    }
    /**
     * 检测用户名是不是被禁止注册.
     *
     * @param string $account 用户名
     *
     * @return bool ture - 未禁用，false - 禁止注册
     */
    protected function checkDenyUser($value, $rule, $data)
    {
        return true; //TODO: 暂不限制，下一个版本完善
    }

    /**
     * 检测邮箱是不是被禁止注册.
     *
     * @param string $email 邮箱
     *
     * @return bool ture - 未禁用，false - 禁止注册
     */
    protected function checkDenyEmail($value, $rule, $data)
    {
        return true; //TODO: 暂不限制，下一个版本完善
    }

    /**
     * 检测手机是不是被禁止注册.
     *
     * @param string $mobile 手机
     *
     * @return bool ture - 未禁用，false - 禁止注册
     */
    protected function checkDenyMobile($value, $rule, $data)
    {
        return true; //TODO: 暂不限制，下一个版本完善
    }
}
