<?php

// +----------------------------------------------------------------------
// | 图片上传配置文件
// +----------------------------------------------------------------------
// | Copyright (c) 2015-2019 http://www.yicmf.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: 微尘 <yicmf@qq.com>
// +----------------------------------------------------------------------

use think\facade\Env;

return [

    // 储存驱动
    'driver' => 'local',
    // 回收站天数
    'recycle_day' => '30',
    // 是否开启图片压缩
    'has_compress' => 0,
    // 允许上传的文件MiMe类型
    'mimes' => 'image/jpeg,image/png,image/gif,image/jpeg',
    // 上传的文件大小限制 (0-不做限制)，单位M
    'max_size' => 3,
    // 允许上传的文件后缀
    'exts' => 'jpg,gif,png,jpeg',
     // 默认保存路径
    'save_path' => Env::get('root_path') . DIRECTORY_SEPARATOR . 'uploads' . DIRECTORY_SEPARATOR . 'picture'.DIRECTORY_SEPARATOR,
    // 编辑器保存路径
    'save_editor_path' => Env::get('root_path') . DIRECTORY_SEPARATOR . 'uploads' . DIRECTORY_SEPARATOR . 'editor' . DIRECTORY_SEPARATOR . 'picture'.DIRECTORY_SEPARATOR,
    // 上传文件命名规则，默认为date，date-根据日期和微秒数生成，md5-对文件使用md5_file散列生成，sha1-对文件使用sha1_file散列生成
    'save_name' => 'date',
    // 是否开启添加水印
    'has_water' => '{$has_water}',
    // 原图保留
    'has_original' => '1',
    // 水印位置
    'loaction_id' => '1',
    // 水印类型none image text
    'water_type' => 'none',
    //加水印图片宽度
    'water_mini_width' => '300',
    // +----------------------------------------------------------------------
    // | 图片水印相关配置
    // +----------------------------------------------------------------------
    // 水印图片
    'water_image' => '',
    // 图片透明度
    'water_transparency' => 50,
    // 横轴边距,单位:像素(px)，默认值为10
    'water_dx' => 10,
    // 纵轴边距,单位:像素(px)，默认值为10
    'water_dy' => 10,
    // +----------------------------------------------------------------------
    // | 文字水印相关配置
    // +----------------------------------------------------------------------
    // 文字内容
    'text_content' => 'YiCmf',
    // 文字字号
    'text_size' => '30',
    // 字体颜色
    'text_color' => '#1c485c',
    // 文字相对当前位置的偏移量
    'text_offset' => 0,
    // 文字倾斜角度
    'text_angle' => 0,
    // 字体文件
    'font_file' => 'simfang.ttf',
    // 文字字体文件路径
    'watar_text_dir' => realpath(Env::get('root_path') . DIRECTORY_SEPARATOR . 'data'.DIRECTORY_SEPARATOR.'ttf' .DIRECTORY_SEPARATOR),
    
    // +----------------------------------------------------------------------
    // | 七牛上传相关配置
    // +----------------------------------------------------------------------
    // 七牛secrectKey
    'qiniu_secrect_key' => '',
    // 七牛accessKey
    'qiniu_access_key' => '',
    // 七牛domain
    'qiniu_domain' => 'http://yiget.cdn.yicmf.com',
    // 七牛bucket
    'qiniu_bucket' => '',
    // 超时时间
    'qiniu_timeout' => 3600,
];
