define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {
    var Controller = {
        index:function () {
            Table.api.init({
                extend: {
                    index_url: 'fission/url/index',
                    add_url: 'fission/url/add',
                    edit_url: 'fission/url/edit',
                    del_url: 'fission/url/del'
                }
            });
            var table = $("#table");
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                sortName: 'id',
                escape: false,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title:'ID', sortable: true,operate:false},
                        {field:'url',title:'地址',formatter:Table.api.formatter.url},
                        {field:'create_time',title:'创建时间',operate:false},
                        {field:'update_time',title:'更新时间',operate:false},
                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]

            });
            Table.api.bindevent(table);
        },
        add:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        del:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        edit:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        }

    };

    return Controller;
});