define(['jquery', 'bootstrap', 'backend', 'table', 'form'], function ($, undefined, Backend, Table, Form) {
    var Controller = {
        index:function () {
            Table.api.init({
                extend: {
                    index_url: 'short/url/index',
                    del_url: 'short/url/del',
                    edit_url:'short/url/edit'
                }
            });
            var table = $("#table");
            table.bootstrapTable({
                url: $.fn.bootstrapTable.defaults.extend.index_url,
                sortName: 'id',
                escape: false,
                columns: [
                    [
                        {checkbox: true},
                        {field: 'id', title:'ID', sortable: true,operate:false},
                        {field:'host',title:'域名'},
                        {field:'count',title:'使用次数',operate:false,sortable:true,width:'100px'},
                        {field:'duan',title:'腾讯短链',formatter:Table.api.formatter.url},
                        {field:'short',title:'短链'},
                        {field:'title',title:'标题'},
                        {field:'pass',title:'密码'},
                        {field:'url',title:'链接地址'},
                        {field:'status',title:'状态',formatter:function (value) {
                                var data={
                                    '0':'<span class="text-danger"><i class="fa fa-circle"></i> 待审</span>',
                                    '1':'<span class="text-success"><i class="fa fa-circle"></i> 通过</span>'
                                };
                                return data[value]
                            }},
                        {field:'create_time',title:'创建时间',operate:false},

                        {field: 'operate', title: __('Operate'), table: table, events: Table.api.events.operate, formatter: Table.api.formatter.operate}
                    ]
                ]

            });
            Table.api.bindevent(table);
            $(document).on("click", ".btn-selected", function () {
                var data = table.bootstrapTable('getSelections');
                var ids=[];
                for(var i=0;i<data.length;i++){
                    ids[i]=data[i]['id'];
                }
                Fast.api.ajax({
                    'url':'short/url/check',
                    'data':{ids:JSON.stringify(ids)}
                },function (data, res) {
                    $('.btn-refresh').trigger('click');
                });
            });
        },
        add:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        del:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        },
        edit:function () {
            Form.api.bindevent($("form[role=form]"), function (data) {});
        }

    };

    return Controller;
});