<?php

if (!defined('IN_HANFOX')) exit('Access Denied');



$pagename = '地区分类';

$pageurl = '?mod=zonedir';

$tempfile = 'zonedir.html';

$table = $DB->table('zonesites');



$pagesize = 15;

$curpage = intval($_GET['page']);

if ($curpage > 1) {

	$start = ($curpage - 1) * $pagesize;

} else {

	$start = 0;

	$curpage = 1;

}

		

$zone_id = intval($_GET['zid']);

$cache_id = $zone_id.'-'.$curpage;



$pageurl .= '&zid='.$zone_id;



if (!$smarty->isCached($tempfile, $cache_id)) {

	$smarty->assign('site_title', $pagename.' - '.$options['site_name']);

	$smarty->assign('site_keywords', $options['site_keywords']);

	$smarty->assign('site_description', $options['site_description']);

	$smarty->assign('site_path', get_zonepath('zonedir'));

	$smarty->assign('site_rss', get_rssfeed('zonedir'));

	

	$where = "w.web_status=3";

	if ($zone_id > 0) {

		$zone = get_one_zonegory($zone_id);

		if (!$zone) {

			unset($zone);

			redirect('?mod=zonegory');

		}

		

		$smarty->assign('site_title', $zone['zone_name'].' - '.$pagename.' - '.$options['site_name']);

		$smarty->assign('site_keywords', !empty($zone['zone_keywords']) ? $zone['zone_keywords'] : $options['site_keywords']);

		$smarty->assign('site_description', !empty($zone['zone_description']) ? $zone['zone_description'] : $options['site_description']);

		$smarty->assign('site_path', get_zonepath($zone['zone_mod'], $zone['zone_id']));

		$smarty->assign('site_rss', get_rssfeed($zone['zone_mod'], $zone['zone_id']));

		

		if ($zone['zone_childcount'] > 0) {

			$where .= " AND w.zone_id IN (".$zone['zone_arrchildid'].")";

			$zones = get_zones($zone['zone_id']);

		} else {

			$where .= " AND w.zone_id=$zone_id";

			$zones = get_zones($zone['root_id']);

		}

	} else {

		$zones = get_zones();

	}

			

	$zonesites = get_zonesite_list($where, 'web_ctime', 'DESC', $start, $pagesize);

	$total = $DB->get_count($table.' w', $where);

	$showpage = showpage($pageurl, $total, $curpage, $pagesize);

	

	$smarty->assign('pagename', $pagename);

	$smarty->assign('zone_id', $zone['zone_id']);

	$smarty->assign('zone_name', isset($zone['zone_name']) ? '“'.$zone['zone_name'].'”地区分类' : $pagename);

	$smarty->assign('zones', $zones);

	$smarty->assign('total', $total);

	$smarty->assign('zonesites', $zonesites);

	$smarty->assign('showpage', $showpage);

	unset($child_zonegory, $zonesites);

}



smarty_output($tempfile, $cache_id);

?>