<?php
/** 获取META信息 */
function get_sitemeta($url) {
	$url = format_url($url);
	$data = get_url_content($url);
		
	$meta = array();
	if (!empty($data)) {
		#Title
		preg_match('/<TITLE>([\w\W]*?)<\/TITLE>/si', $data, $matches);
		if (!empty($matches[1])) {
			$meta['title'] = $matches[1];
		}
		
		#Keywords
		preg_match('/<META\s+name="keywords"\s+content="([\w\W]*?)"/si', $data, $matches);		
		if (empty($matches[1])) {
			preg_match("/<META\s+name='keywords'\s+content='([\w\W]*?)'/si", $data, $matches);			
		}
		if (empty($matches[1])) {
			preg_match('/<META\s+content="([\w\W]*?)"\s+name="keywords"/si', $data, $matches);			
		}
		if (empty($matches[1])) {
			preg_match('/<META\s+http-equiv="keywords"\s+content="([\w\W]*?)"/si', $data, $matches);			
		}
		if (!empty($matches[1])) {
			$meta['keywords'] = $matches[1];
		}
		
		#Description
		preg_match('/<META\s+name="description"\s+content="([\w\W]*?)"/si', $data, $matches);		
		if (empty($matches[1])) {
			preg_match("/<META\s+name='description'\s+content='([\w\W]*?)'/si", $data, $matches);			
		}
		if (empty($matches[1])) {
			preg_match('/<META\s+content="([\w\W]*?)"\s+name="description"/si', $data, $matches);					
		}
		if (empty($matches[1])) {
			preg_match('/<META\s+http-equiv="description"\s+content="([\w\W]*?)"/si', $data, $matches);			
		}
		if (!empty($matches[1])) {
			$meta['description'] = $matches[1];
		}
	}

	return $meta; 
}

/** Server IP */
function get_serverip($url) {
	$domain = get_domain($url);
	if ($domain) {
		$ip = gethostbyname($domain);
	} else {
		$ip = 0;
	}
	
	return $ip;
}
/* aip */
function get_aip($url) {
	
	$data = get_url_content("http://seo.chinaz.com/$url");
	if (preg_match('/<div class="brn ipmW">(.*?)<\/a>/i', $data, $matches)) {
		$aip =strip_tags($matches[1]);
	}
	
	
	return $aip;
}
/* domtime */
function get_domtime($url) {
	
	$data = get_url_content("http://seo.chinaz.com/$url");
	if (preg_match('/<div class="w97-0 brn ml5 col-hint02">(.*?)<\/a>/i', $data, $matches)) {
		$domtime =strip_tags($matches[1]);
	}
	
	
	return $domtime;
}
/* history */
function get_lishi($url) {
	
	$data = get_url_content("http://tool.chinaz.com/history/?h=$url");
	if (preg_match('/<!--收录反链历史-开始-->([\w\W]*?)<!--收录反链历史-结束-->/i', $data, $matches)) {
		$lishi = $matches[1];
	}
	
	
	return $lishi;
}
/** Google Pagerank */
function get_pagerank($url) {
    $data = get_url_content("http://pr.links.cn/getpr.asp?queryurl=$url&show=1");
    if (preg_match('/<a(.*?)>(\d+)<\/a>/i', $data, $matches)) {
        $rank = intval($matches[2]);
    } else {
        $rank = 0;
    }
    return $rank;
}

/** Baidu Pagerank */
function get_baidurank($url) {
	$data = get_url_content("http://www.aizhan.com/getbr.php?url=$url&style=1");
	if (preg_match('/<a(.*?)>(\d+)<\/a>/i', $data, $matches)) {
		$rank = intval($matches[2]);
	} else {
		$rank = 0;
	}
	return $rank;
}

/** Sogou Pagerank */
function get_sogourank($url) {
	$data = get_url_content("http://rank.ie.sogou.com/sogourank.php?ur=$url");
	if (preg_match('/sogourank=(\d+)/i', $data, $matches)) {
		$rank = intval($matches[1]);
	} else {
		$rank = 0;
	}
	return $rank;
}

/** Alexa Rank */
function get_alexarank($url) {
	$data = get_url_content("http://xml.alexa.com/data?cli=10&dat=nsa&ver=quirk-searchstatus&url=$url");
	if (preg_match('/<POPULARITY[^>]*URL[^>]*TEXT[^>]*\"([0-9]+)\"/i', $data, $matches)) {
		$rank = strip_tags($matches[1]);
	} else {
		$rank = 0;
	}
	return $rank;
}
/* icp */
function get_icpinfo($url) {
	
	$data = get_url_content("http://icp.chinaz.com/?s=$url");
	if (preg_match('/许可证号<\/span><p>(.*?)<a/i', $data, $matches)) {
		$icp =strip_tags($matches[1]);
	}
	
	
	return $icp;
}
/* xicp */
function get_xicpinfo($url) {
	
	$data = get_url_content("http://icp.chinaz.com/?s=$url");
	if (preg_match('/fwnone">(.*?)<\/strong>/i', $data, $matches)) {
		$xicp =strip_tags($matches[1]);
	}
	
	return $xicp;
}

/* micp */
function get_micpinfo($url) {
	
	$data = get_url_content("http://icp.chinaz.com/?s=$url");
	if (preg_match('/主办单位名称<\/span><p>(.*?)<a/i', $data, $matches)) {
		$micp =strip_tags($matches[1]);
	}
	
	return $micp;
}

/* icp 时间*/
function get_ticpinfo($url) {
	
	$data = get_url_content("http://icp.chinaz.com/?s=$url");
	if (preg_match('/审核时间<\/span><p>(.*?)<\/p>/i', $data, $matches)) {
		$ticp =strip_tags($matches[1]);
	}
	
	return $ticp;
}


/* header */
function get_header($url) {
	$url = format_url($url);
	if (function_exists('curl_init')) {
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_HEADER, 1);
		curl_setopt($curl, CURLOPT_NOBODY, 1);
		curl_setopt($curl, CURLOPT_ENCODING, "gzip, deflate");
		$data = curl_exec($curl);
		
		$headers = explode("\r\n", $data);
		curl_close($curl);
	} else {
		$headers = get_headers($url, 1); //不是curl获取的参数是看不到 gzip 的
		if (is_array($headers['Vary'])) {
			$headers['Vary'] = implode(',', $headers['Vary']);
		}
	}
	
	return $headers;
}

?>