<?php
require('common.php');
require(APP_PATH.'module/category.php');
require(APP_PATH.'module/city.php');
require(APP_PATH.'module/weixin.php');


$fileurl = 'weixin.php';
$tempfile = 'weixin.html';
$table = $DB->table('wx');

if (!isset($action)) $action = 'list';

/** list */
if ($action == 'list') {
	$pagetitle = '微信列表';
	
	$status = intval(trim($_GET['status']));
	$cate_id = intval(trim($_GET['cate_id']));
	$sort = intval(trim($_GET['sort']));
	$order = strtoupper(trim($_GET['order']));
	$keywords = addslashes(trim($_POST['keywords'] ? $_POST['keywords'] : $_GET['keywords']));
	if (empty($order)) $order = 'DESC';
	
	$pageurl = $fileurl.'?status='.$status.'&cate_id='.$cate_id.'&sort='.$sort.'&order='.$order;
	$keyurl = !empty($keywords) ? '&keywords='.urlencode($keywords) : '';
	$pageurl .= $keyurl;
	
	$category_option = get_category_option('weixin', 0, $cate_id, 0);
	
	$smarty->assign('status', $status);
	$smarty->assign('cate_id', $cate_id);
	$smarty->assign('sort', $sort);
	$smarty->assign('order', $order);
	$smarty->assign('keywords', $keywords);
	$smarty->assign('keyurl', $keyurl);
	$smarty->assign('category_option', $category_option);
	
	$where = '';
	$sql = "SELECT a.wx_id, a.user_id, a.cate_id, a.area_id, a.wx_lei, a.wx_name, a.wx_hao, a.wx_yuan, a.wx_ma, a.wx_tags, a.wx_intro, a.wx_content, a.wx_wang, a.wx_weibo, a.wx_ispay, a.wx_isbest, a.wx_istop, a.wx_status, a.wx_ctime, a.wx_views FROM $table a  WHERE";
	switch ($status) {
		case 1 :
			$where .= " a.wx_status=1";
			break;
		case 2 :
			$where .= " a.wx_status=2";
			break;
		case 3 :
			$where .= " a.wx_status=3";
			break;
		default :
			$where .= " a.wx_status>-1";
			break;
	}
	
	if ($cate_id > 0) {
		$cate = get_one_category($cate_id);
		$where .= " AND a.cate_id IN (".$cate['cate_arrchildid'].")";
	}
	
	if ($keywords) $where .= " AND a.wx_name like '%$keywords%'";
	
	switch ($sort) {
		case 1 :
			$field = "a.wx_ctime";
			break;
		
		case 8 :
			$field = "b.wx_views";
			break;
		
		default :
			$field = "a.wx_ctime";
			break;
	}
	
	$sql .= $where." ORDER BY a.wx_istop DESC, $field $order LIMIT $start, $pagesize";
	$query = $DB->query($sql);
	
	$wx = array();
	while ($web = $DB->fetch_array($query)) {
		switch ($web['wx_status']) {
			case 1 :
				$wx_status = '<font color="#333333">黑名单</font>';
				break;
			case 2 :
				$wx_status = '<font color="#ff3300">待审核</font>';
				break;
			case 3 :
				$wx_status = '<font color="#008800">已审核</font>';
				break;
		}
		switch ($web['wx_lei']) {
			case 1 :
				$wx_lei = '<font color="#333333">服务号</font>';
				break;
			case 2 :
				$wx_lei = '<font color="#ff3300">订阅号</font>';
				break;
			case 3 :
				$wx_lei = '<font color="#008800">企业号</font>';
				break;
		}
		$wx_ispay = $web['wx_ispay'] > 0 ? '<font color="#ff0000">付费</font>' : '<font color="#cccccc">付费</font>';
		$wx_istop = $web['wx_istop'] > 0 ? '<font color="#ff0000">置顶</font>' : '<font color="#cccccc">置顶</font>';
		$wx_isbest = $web['wx_isbest'] > 0 ? '<font color="#ff0000">推荐</font>' : '<font color="#cccccc">推荐</font>';
		$wx_islink = $web['wx_islink'] > 0 ? '<font color="#ff0000">未链接</font>' : '<font color="#cccccc">链接中</font>';
		$web['wx_attr'] = $wx_ispay.' - '.$wx_istop.' - '.$wx_isbest.' - '.$wx_status;
		
		$web['wx_cate'] = '<a href="'.$fileurl.'?cate_id='.$web['cate_id'].'">'.get_category_name($web['cate_id']).'</a>';
		$web['wx_name'] = '<a href="'.format_url($web['wx_url']).'" target="_blank">'.$web['wx_name'].'</a> '.($web['wx_errors'] > 0 ? '<sup style="color: #f00;">error!</sup>' : '');
		
		
		$web['wx_ctime'] = date('Y-m-d', $web['wx_ctime']);
		$web['wx_operate'] = '<a href="'.$fileurl.'?act=edit&wx_id='.$web['wx_id'].'">编辑</a>&nbsp;|&nbsp;<a href="'.$fileurl.'?act=del&wx_id='.$web['wx_id'].'" onClick="return confirm(\'确认删除此内容吗？\');">删除</a>';
		$wx[] = $web;
	}
	unset($web);
	$DB->free_result($query);
	
	$total = $DB->get_count($table.' a', $where);
	$showpage = showpage($pageurl, $total, $curpage, $pagesize);
	
	$smarty->assign('wx', $wx);
	$smarty->assign('showpage', $showpage);
	unset($wx);
}

/** add */
if ($action == 'add') {
	$pagetitle = '添加微信';

	$cate_id = intval($_GET['cate_id']);
	$area_id = intval($_GET['area_id']);
	$category_option = get_category_option('weixin', 0, $cate_id, 0);
	$city_option = get_city_option('area', 0, $area_id, 0);
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('city_option', $city_option);
	$smarty->assign('status', 3);
	$smarty->assign('h_action', 'saveadd');
}

/** edit */
if ($action == 'edit') {
	$pagetitle = '编辑微信';
	
	$wx_id = intval($_GET['wx_id']);
	
	$where = "w.wx_id=$wx_id";
	$row = get_one_weixin($where);
	if (!$row) {
		msgbox('指定的内容不存在！');
	}
	$category_option = get_category_option('weixin', 0, $row['cate_id'], 0);
	$city_option = get_city_option('area', 0, $row['area_id'], 0);
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('city_option', $city_option);
	$smarty->assign('ispay', $row['wx_ispay']);
	$smarty->assign('istop', $row['wx_istop']);
	$smarty->assign('isbest', $row['wx_isbest']);
	$smarty->assign('status', $row['wx_status']);
	$smarty->assign('row', $row);
	$smarty->assign('h_action', 'saveedit');
}

/** move */
if ($action == 'move') {
	$pagetitle = '移动微信';
			
	$wx_ids = (array) ($_POST['wx_id'] ? $_POST['wx_id'] : $_GET['wx_id']);
	if (empty($wx_ids)) {
		msgbox('请选择要移动的微信！');
	} else {
		$wids = dimplode($wx_ids);
	}
	
	$category_option = get_category_option('weixin', 0, 0, 0);
	$wx = $DB->fetch_all("SELECT wx_id, wx_name FROM $table WHERE wx_id IN ($wids)");
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('wx', $wx);
	$smarty->assign('h_action', 'savemove');
}
/** moarea */
if ($action == 'moarea') {
	$pagetitle = '更改地区';
			
	$wx_ids = (array) ($_POST['wx_id'] ? $_POST['wx_id'] : $_GET['wx_id']);
	if (empty($wx_ids)) {
		msgbox('请选择要更改的微信！');
	} else {
		$wids = dimplode($wx_ids);
	}
	
	$city_option = get_city_option('area', 0, 0, 0);
	$wx = $DB->fetch_all("SELECT wx_id, wx_name FROM $table WHERE wx_id IN ($wids)");
	
	$smarty->assign('city_option', $city_option);
	$smarty->assign('wx', $wx);
	$smarty->assign('h_action', 'savemoarea');
}
/** attr */
if ($action == 'attr') {
	$pagetitle = '属性设置';
	
	$wx_ids = (array) ($_POST['wx_id'] ? $_POST['wx_id'] : $_GET['wx_id']);
	if (empty($wx_ids)) {
		msgbox('请选择要设置的微信！');
	} else {
		$wids = dimplode($wx_ids);
	}
	
	$category_option = get_category_option('weixin', 0, 0, 0);
	$wx = $DB->fetch_all("SELECT wx_id, wx_name FROM $table WHERE wx_id IN ($wids)");
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('wx', $wx);
	$smarty->assign('h_action', 'saveattr');
}


/** save data */
if (in_array($action, array('saveadd', 'saveedit'))) {
	$cate_id = intval($_POST['cate_id']);
	$area_id = intval($_POST['area_id']);
	$wx_name = trim($_POST['wx_name']);
	$wx_lei = intval($_POST['wx_lei']);
	$wx_tags = strtolower(addslashes(trim($_POST['wx_tags'])));
	$wx_ma = trim($_POST['wx_ma']);
	$wx_intro = addslashes(trim($_POST['wx_intro']));
	$wx_content = $_POST['wx_content'];
	$wx_hao = trim($_POST['wx_hao']);
	$wx_yuan = trim($_POST['wx_yuan']);
	$wx_wang = trim($_POST['wx_wang']);
	$wx_weibo = trim($_POST['wx_weibo']);
	
	$wx_views = intval($_POST['wx_views']);
	
	$wx_ispay = intval($_POST['wx_ispay']);
	$wx_istop = intval($_POST['wx_istop']);
	$wx_isbest = intval($_POST['wx_isbest']);
	$wx_status = intval($_POST['wx_status']);
	$wx_time = time();
	
	if ($cate_id <= 0) {
		msgbox('请选择微信所属分类！');
	} else {
		$row = get_one_category($cate_id);
		if ($row['cate_mod'] == 'weixin' && $row['cate_childcount'] > 0) {
			msgbox('指定的分类下有子分类，请选择子分类进行操作！');
		}
	}
	if ($area_id <= 0) {
		msgbox('请选择微信所属地区！');
	} else {
		$row = get_one_city($area_id);
		if ($row['area_mod'] == 'area' && $row['area_childcount'] > 0) {
			msgbox('指定的分类下有子地区类，请选择子地区进行操作！');
		}
	}
	
	
	if (empty($wx_name)) {
		msgbox('请输入微信名称！');
	}
	if (empty($wx_hao)) {
		msgbox('请输入微信号！');
	}
	
	
	
	if (empty($wx_intro)) {
		msgbox('请输入微信简介！');
	}
	if (empty($wx_content)) {
		msgbox('请输入微信详细介绍！');
	}
	
	// $wx_url = str_replace('http://', '', $wx_url);
	$wx_tags = str_replace('，', ',', $wx_tags);
	$wx_tags = str_replace(',,', ',', $wx_tags);
	if (substr($wx_tags, -1) == ',') {
		$wx_tags = substr($wx_tags, 0, strlen($wx_tags) - 1);
	}
	
	$wx_ip = sprintf("%u", ip2long($wx_ip));
	
	$wx_data = array(
		'cate_id' => $cate_id,
		'area_id' => $area_id,
		'wx_name' => $wx_name,
		'wx_lei' => $wx_lei,
		'wx_tags' => $wx_tags,
		'wx_ma' => $wx_ma,
		'wx_intro' => $wx_intro,
		'wx_content' => $wx_content,
		'wx_hao' => $wx_hao,
		'wx_yuan' => $wx_yuan,
		'wx_wang' => $wx_wang,
		'wx_weibo' => $wx_weibo,
		'wx_ispay' => $wx_ispay,
		'wx_istop' => $wx_istop,
		'wx_isbest' => $wx_isbest,
		'wx_status' => $wx_status,
		'wx_ctime' => $wx_time,
	);
	
	
	
	if ($action == 'saveadd') {
    	$query = $DB->query("SELECT wx_id FROM $table WHERE wx_hao='$wx_hao'");
    	if ($DB->num_rows($query)) {
        	msgbox('您所添加的微信已存在！');
    	}
		
		$wx_data['user_id'] = $myself['user_id'];
		
		
		
		
		$DB->insert($table, $wx_data);
		$DB->query("UPDATE ".$DB->table('categories')." SET cate_postcount=cate_postcount+1 WHERE cate_id=$cate_id");
		$DB->query("UPDATE ".$DB->table('areas')." SET area_postcount=area_postcount+1 WHERE area_id=$area_id");
		update_cache('archives');
		
		msgbox('微信添加成功！', $fileurl.'?act=add&cate_id='.$cate_id);	
	} elseif ($action == 'saveedit') {
		$wx_id = intval($_POST['wx_id']);
		$where = array('wx_id' => $wx_id);
		unset($wx_data['wx_ctime']);
		
		$DB->update($table, $wx_data, $where);
		
		
		$DB->query("UPDATE ".$DB->table('categories')." SET cate_postcount=cate_postcount+1 WHERE cate_id=$cate_id");
		$DB->query("UPDATE ".$DB->table('areas')." SET area_postcount=area_postcount+1 WHERE area_id=$area_id");
		
		
		msgbox('微信修改成功！', $fileurl);
	}
}

/** del */
if ($action == 'del') {
	$wx_ids = (array) ($_POST['wx_id'] ? $_POST['wx_id'] : $_GET['wx_id']);
	
	$DB->delete($table, 'wx_id IN ('.dimplode($wx_ids).')');
	
	
	unset($wx_ids);
	
	msgbox('微信删除成功！', $fileurl);
}

/** move */
if ($action == 'savemove') {
	$wx_ids = (array) $_POST['wx_id'];
	$cate_id = intval($_POST['cate_id']);
	if (empty($wx_ids)) {
		msgbox('请选择要移动的内容！');
	}
	if ($cate_id <= 0) {
		msgbox('请选择分类！');
	} else {
		$cate = get_one_category($cate_id);
		if ($cate['cate_childcount'] > 0) {
			msgbox('指定的分类下有子分类，请选择子分类进行操作！');
		}
	}
	
	$DB->update($table, array('cate_id' => $cate_id), 'wx_id IN ('.dimplode($wx_ids).')');
	
	
	msgbox('微信移动成功！', $fileurl);
}
/** moarea */
if ($action == 'savemoarea') {
	$wx_ids = (array) $_POST['wx_id'];
	$area_id = intval($_POST['area_id']);
	if (empty($wx_ids)) {
		msgbox('请选择要更改的内容！');
	}
	if ($area_id <= 0) {
		msgbox('请选择地区！');
	} else {
		$cate = get_one_city($area_id);
		if ($cate['area_childcount'] > 0) {
			msgbox('指定的地区下有子分类，请选择二级地区类进行操作！');
		}
	}
	
	$DB->update($table, array('area_id' => $area_id), 'wx_id IN ('.dimplode($wx_ids).')');
	
	
	msgbox('微信移动成功！', $fileurl);
}

/** attr */
if ($action == 'saveattr') {
	$wx_ids = (array) $_POST['wx_id'];
	$wx_ispay = intval($_POST['wx_ispay']);
	$wx_istop = intval($_POST['wx_istop']);
	$wx_isbest = intval($_POST['wx_isbest']);
	$wx_status = intval($_POST['wx_status']);
	if (empty($wx_ids)) {
		msgbox('请选择要设置的内容！');
	}
	
	require(APP_PATH.'include/sendmail.php');
	require(APP_PATH.'module/prelink.php');
	
	$wx = $DB->fetch_all("SELECT w.wx_id, w.wx_name, u.user_email FROM $table w LEFT JOIN ".$DB->table("users")." u ON w.user_id=u.user_id WHERE w.wx_id IN (".dimplode($wx_ids).")");
	foreach ($wx as $row) {
		/*if ($wx_status == 3) {
			$site_link = get_weixin_url($row['wx_id'], true);
			//发送邮件
			if (!empty($options['smtp_host']) && !empty($options['smtp_port']) && !empty($options['smtp_auth']) && !empty($options['smtp_user'])  && !empty($options['smtp_pass'])) {	
				$smarty->assign('site_name', $options['site_name']);
				$smarty->assign('site_url', $options['site_url']);
				$smarty->assign('wx_name', $row['wx_name']);
				$smarty->assign('site_link', $site_link);
				$mailbody = $smarty->fetch('audit_mail.html');
				sendmail($row['user_email'], '['.$options['site_name'].'] 微信已通过审核！', $mailbody);
			}
		}*/
		$DB->update($table, array('wx_ispay' => $wx_ispay, 'wx_istop' => $wx_istop, 'wx_isbest' => $wx_isbest, 'wx_status' => $wx_status), array('wx_id' => $row['wx_id']));
	}
	
	//$DB->update($table, array('wx_istop' => $wx_istop, 'wx_isbest' => $wx_isbest, 'wx_status' => $wx_status), 'wx_id IN ('.dimplode($wx_ids).')');
	
	msgbox('微信属性设置成功！', $fileurl);
}



smarty_output($tempfile);
?>