<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSystemInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('system_infos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('web_title'); //网站标题
            $table->string('web_desc');  //网站介绍
            $table->string('web_url'); //网站域名
            $table->string('web_logo'); //logo图片路径
            $table->text('tongji');  //统计代码
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('system_infos');
    }
}
