// JavaScript Document
var WindowList = new Array();
var CurrentWindow = '';
Array.prototype.indexOf = function(val) {
	for (var i = 0; i < this.length; i++) {
		if (this[i][0] == val) return i;
	}
	return -1;
};
Array.prototype.remove = function(val) {
	var index = this.indexOf(val);
	if (index > -1) {
		this.splice(index, 1);
	}
};
$(function(){
	//获取浏览器可见区域宽、高
	var ScWidth = document.body.clientWidth;
	var ScHeight = document.body.clientHeight;
	
	/*------------------------------
	 * 顶部工具栏初始化
	------------------------------*/
  
	//定义顶部工具栏内容
	var ToolBar = [
		['分类管理','list_sorts.png','list_sorts.php'],
		['添加分类','add_sort.png','add_sort.php'],
		['网址管理','list_sites.png','list_sites.php'],
		['添加网址','add_site.png','add_site.php'],
		['首页网址','list_index.png','list_sites.php?parent_id=0'],
		['意见反馈','list_feedback.png','list_feedback.php'],
		['收录申请','list_linkin.png','list_linkin.php'],
		['关于本站','opt_about.png','opt_about.php'],
		['新闻管理','list_news.png','list_sites.php?parent_id=-1'],
		['添加新闻','add_news.png','add_site.php?parent_id=-1'],
		['友情链接','list_link.png','list_sites.php?parent_id=-2'],
		['添加链接','add_link.png','add_site.php?parent_id=-2'],
		['修改密码','opt_password.png','opt_password.php'],
		['网站设置','opt_basic.png','opt_basic.php'],
		['购买商业版','list_sites.png','http://www.kewei8.com/buy'],
		['功能定制','list_sorts.png','http://www.kewei8.com/serve']
	];
	
	//设置顶部工具栏大小、透明度
	$('#bar_bg').css('width',ScWidth-180-120);
	$('#bar_bg').animate({opacity:0.7},0);
	$('#bar_con').css('width',ScWidth-180-120);
	
	//获取顶部工具栏最多容纳按钮个数

	var BarBtnCount = Math.floor((ScWidth-180-120)/79)-1;
	
	//将工具栏内容填充到相应容器中，多出的添加到更多盒子中
	$.each( ToolBar,function(i){
		if(i<BarBtnCount)
		{
			//添加到工具栏
			$('#bar_con').html($('#bar_con').html()+'<div class="bar_btn"><img width="32" height="32" src="images/bar_btns/'+ToolBar[i][1]+'" /><span>'+ToolBar[i][0]+'</span></div>');
		}
		else
		{
			//添加到更多盒子中
			$('#bar_more_box').html($('#bar_more_box').html()+'<div class="bar_more_btn"><img width="32" height="32" src="images/bar_btns/'+ToolBar[i][1]+'" /><span>'+ToolBar[i][0]+'</span></div>');
		}
	});
	
	//初始化更多按钮并显示更多盒子中按钮个数
	$('#bar_con').html($('#bar_con').html()+'<div class="bar_more"><span id="bar_more_num">'+(ToolBar.length-BarBtnCount)+'</span></div>');

	//工具栏按钮背景切换、点击处理
	$.each( $('.bar_btn'),function(i){
		$(this).bind('mouseover',function(){$(this).css('background-image','url(images/bar_btn.png)');});
		$(this).bind('mouseout',function(){$(this).css('background-image','none');});
		$(this).bind('click',function(){CreateWindow(ToolBar[i][0],ToolBar[i][1],ToolBar[i][2])});
	});
	
	//更多按钮切换
	$.each( $('.bar_more_btn'),function(i){
		$(this).bind('mouseover',function(){$(this).css('background-image','url(images/bar_btn.png)');});
		$(this).bind('mouseout',function(){$(this).css('background-image','none');});
		$(this).bind('click',function(){CreateWindow(ToolBar[i+BarBtnCount][0],ToolBar[i+BarBtnCount][1],ToolBar[i+BarBtnCount][2])});
	});
	
	//工具栏更多按钮背景切换、点击事件处理
	$('.bar_more').bind('mouseover',function(){$(this).css('background-image','url(images/bar_more_over.png)');});
	$('.bar_more').bind('mouseout',function(){$(this).css('background-image','url(images/bar_more.png)');});
	$('.bar_more').bind('click',function(event){
		event.stopPropagation();
		$('#bar_more_bg').toggle(200);
		$('#bar_more_box').toggle(200);
	/*	if($('#bar_more_bg').css('display')=='none')
		{
			$('#bar_more_bg').fadeIn(100);
			$('#bar_more_box').fadeIn(100);
		}
		else
		{
			$('#bar_more_bg').fadeOut(100);
			$('#bar_more_box').fadeOut(100);
		}*/
	});
	
	//工具栏更多盒子背景样式设置
	$('#bar_more_bg').animate({opacity:0.7},0);
	
	/*------------------------------
	 * 打开窗口事件处理
	------------------------------*/
	
	//标题栏按钮
	//内容大小
/*	$.each( $('.window_con'),function(){
		ResizeWindow($(this));
	});*/
	
	/*------------------------------
	 * 底部工具栏初始化
	------------------------------*/
	
	//设置底部任务栏大小、透明度
	$('#task_bar').css('top',ScHeight-30);
	$('#task_bar_bg').css('top',ScHeight-30);
	$('#task_bar_desc').css('top',ScHeight-60);
	$('#task_bar_bg').animate({opacity:0.5},0);
	$('#task_bar_left').css('width',(ScWidth-330)/2);
	$('#task_bar_right').css('width',(ScWidth-330)/2);

	//右侧按钮
	$.each( $('.task_bar_right_btn'),function(i){
		$(this).bind('mouseover',function(){$(this).css('background','url(images/task_bar_right_btn.png)');ShowDescRight($(this).children('img:eq(0)').attr('alt'),i)});
		$(this).bind('mouseout',function(){$(this).css('background','none');HideDescRight()});
	});
	
	/*------------------------------
	 * 其他事件处理
	------------------------------*/
	//BODY点击事件处理
	$('body').bind('click',function(){
		if($('#bar_more_bg').css('display')!='none')
		{
			$('#bar_more_bg').fadeOut(100);
			$('#bar_more_box').fadeOut(100);
		}
	});
	//关闭遮罩
	$('#mask').fadeOut(500);
	//禁止选择
	$(document).bind("selectstart",function(){return false;});
});
function ResizeWindow(obj)
{
	var width = obj.parent().css('width');
	var height = obj.parent().css('height');
	width = width.substring(0,width.length-2);
	height = height.substring(0,height.length-2);
	obj.css('width',width-12);
	obj.css('height',height-42);
	return;
}
function CreateWindow(title,icon,src)
{
	var handle = (new Date()).valueOf()%100000000;
	$('#window_area').html($('#window_area').html()+'<div id="window_'+handle+'" class="window"><div class="window_title"><div class="title_con"><img width="20" height="20" src="images/bar_btns/'+icon+'" /><span>'+title+'</span></div><div class="title_btn"><div class="window_btn_refresh"></div><div class="window_btn_left"></div><div class="window_btn_middle"></div><div class="window_btn_right"></div></div></div><div class="window_con"><iframe id="iframe_'+handle+'" frameborder="0" width="100%" height="100%" marginwidth="0" marginheight="0" scrolling="yes" src="'+src+'"></iframe></div></div>');
	WindowList[WindowList.length] = new Array();
	WindowList[WindowList.length-1] = [handle,title,icon];
	CurrentWindow = handle;
	UpdateWindow(handle);
	ActiveWindow(handle);
}
function UpdateWindow(handle)
{
	var ScWidth = document.body.clientWidth;
	var ScHeight = document.body.clientHeight;
	$.each( $('.window'),function(i){
	  $(this).css('width',ScWidth-12);
	  $(this).css('height',ScHeight-112);
	  ResizeWindow($(this).children('div:eq(1)'));

	  $(this).children('.window_title').bind('mousedown',function(){
		  var handle = $(this).parent().attr('id');
		  handle = handle.substring(7,handle.length);
		  ActiveWindow(handle);
	  });
	  $(this).children('.window_title').bind('dblclick',function(){
		  $(this).children('.title_btn').children('.window_btn_middle').click();
	  });

	  $(this).children('.window_title').children('.title_btn').children('.window_btn_refresh').bind('mouseover',function(){$(this).css('background-position','-63px 21px');});
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_refresh').bind('mouseout',function(){$(this).css('background-position','-63px 0px');});
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_refresh').bind('click',function(){
		  window.frames[$(this).parent().parent().parent().children('.window_con').children('iframe:eq(0)').attr('id')].location.reload();
	  });
	  
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_left').bind('mouseover',function(){$(this).css('background-position','0px 21px');});
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_left').bind('mouseout',function(){$(this).css('background-position','0px 0px');});
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_left').bind('click',function(){
		  var handle = $(this).parent().parent().parent().attr('id');
		  handle = handle.substring(7,handle.length);
		  MaximizeWindow(handle);
	  });
	  
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_middle').bind('mouseover',function(){$(this).css('background-position','-21px 21px');});
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_middle').bind('mouseout',function(){$(this).css('background-position','-21px 0px');});
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_middle').bind('click',function(){
		  if($(this).parent().parent().parent().css('left')=='0px')
		  {
			  $(this).parent().parent().parent().css('left','5px');
			  $(this).parent().parent().parent().css('top','75px');
			  $(this).parent().parent().parent().css('width',ScWidth-12);
			  $(this).parent().parent().parent().css('height',ScHeight-112);
			  $(this).css('background-image','url(images/window_btn.png)');
		  }
		  else
		  {
			  $(this).parent().parent().parent().css('left','0px');
			  $(this).parent().parent().parent().css('top','0px');
			  $(this).parent().parent().parent().css('width',ScWidth-2);
			  $(this).parent().parent().parent().css('height',ScHeight-30);
			  $(this).css('background-image','url(images/window_btn_max.png)');
		  }
		  ResizeWindow($(this).parent().parent().parent().children('div:eq(1)'));
	  });
	  
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_right').bind('mouseover',function(){$(this).css('background-position','-42px 21px');});
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_right').bind('mouseout',function(){$(this).css('background-position','-42px 0px');});
	  $(this).children('.window_title').children('.title_btn').children('.window_btn_right').bind('click',function(){
		  var handle = $(this).parent().parent().parent().attr('id');
		  handle = handle.substring(7,handle.length);
		  CloseWindow(handle);
	  });
	  $(this).draggable({opacity:0.7,scroll:false});
	});
	UpdateWindowList();
	return;
}
function UpdateWindowList()
{
	var html = '';
	$.each( WindowList,function(i){
		html += '<li onclick="AppearWindow(\''+WindowList[i][0]+'\')" id="wlist_'+WindowList[i][0]+'"><a href="#" target="_self">'+WindowList[i][1]+'&nbsp;&nbsp;('+WindowList[i][0]+')<img src="images/close.png" onclick="CloseWindow(\''+WindowList[i][0]+'\')" alt="关闭" /></a></li>';
	});
	$('#window_list').html(html);
	UpdateTaskBar();
}
function CloseWindow(handle)
{
	WindowList.remove(handle);
	$('#window_'+handle).remove();
	UpdateWindowList();
	CurrentWindow = GetTopWindow(handle);
	UpdateTaskBar();
}
function AppearWindow(handle)
{
	if($('#window_'+handle).css('display')=='none')
		MaximizeWindow(handle);
	ActiveWindow(handle);
}
function ActiveWindow(handle)
{
	CurrentWindow = handle;
	UpdateTaskBar();
	$.each( WindowList,function(i){
		$('#window_'+WindowList[i][0]).css('z-index','600');
	});
	$('#window_'+handle).css('z-index','601');
}
function MaximizeWindow(handle)
{
	var ScWidth = document.body.clientWidth;
	var ScHeight = document.body.clientHeight;
	ActiveWindow(handle);
	if($('#window_'+handle).css('display')=='none')
	{
		$('#window_'+handle).show(1);
		$('#window_'+handle).animate({left:5,top:75,width:ScWidth-12,height:ScHeight-112},200);
	//	ResizeWindow($('#window_'+handle).children('div:eq(1)'));
		CurrentWindow = handle;
		UpdateTaskBar();
	}
	else
	{
		$('#window_'+handle).animate({left:0,top:ScWidth-30,width:100,height:100},200);
		$('#window_'+handle).hide(1);
		CurrentWindow = GetTopWindow(handle);
		UpdateTaskBar();
	}
}
function UpdateTaskBar()
{
	var html = '';
	$.each( WindowList,function(i){
		if(WindowList[i][0]==CurrentWindow)
		{
			html += '<div onmouseover="ShowDescLeft(\''+WindowList[i][1]+'\',\''+i+'\')" onmouseout="HideDescLeft()" onclick="MaximizeWindow(\''+WindowList[i][0]+'\')" class="task_bar_left_btn active_window"><img width="16" height="16" src="images/bar_btns/'+WindowList[i][2]+'" /></div>';
		}
		else
		{
			html += '<div onmouseover="ShowDescLeft(\''+WindowList[i][1]+'\',\''+i+'\')" onmouseout="HideDescLeft()" onclick="MaximizeWindow(\''+WindowList[i][0]+'\')" class="task_bar_left_btn"><img width="20" height="20" src="images/bar_btns/'+WindowList[i][2]+'" /></div>';
		}
	});
	$('#task_bar_left').html(html);
}
function ShowDescLeft(title,i)
{
	$('#task_bar_desc_con').html(title);
	$('#task_bar_desc_con').css('margin-left',i*30);
	$('#task_bar_desc_con').css('display','inline');
}
function HideDescLeft()
{
	$('#task_bar_desc_con').hide();
}
function ShowDescRight(title,i)
{
	$('#task_bar_desc_con_right').html(title);
	$('#task_bar_desc_con_right').css('margin-right',i*36);
	$('#task_bar_desc_con_right').css('display','inline');
}
function HideDescRight()
{
	$('#task_bar_desc_con_right').hide();
}
function GetTopWindow(hide_handle)
{
	handle = 0;
	$.each( WindowList,function(i){
		if($('#window_'+WindowList[i][0]).css('display')=='block'&&WindowList[i][0]!=hide_handle)
		{
			handle = WindowList[i][0];
		}
	});
	return handle;
}
//显示窗口管理器
function ShowWindowMgr()
{
	$('#windowmgr').toggle(200);
}
//刷新页面
function RefreshPage()
{
	window.location.reload();
}
//显示桌面
function ShowDesktop()
{
	var ScWidth = document.body.clientWidth;
	var ScHeight = document.body.clientHeight;
	
	$.each( WindowList,function(i){
		if($('#window_'+WindowList[i][0]).css('display')=='block')
		{
			$('#window_'+WindowList[i][0]).animate({left:0,top:ScWidth-30,width:100,height:100},200);
			$('#window_'+WindowList[i][0]).hide(1);
		}
	});
	UpdateTaskBar();
}