<?php

namespace App\Http\Controllers\Admin;

use App\Models\Dictionary;
use App\Models\ProductArticleFromType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

class ProductArticleFromTypeController extends Controller
{
    public function index(){

        $labels=ProductArticleFromType::select()->orderBy('sort','desc')->get();
        $model=Dictionary::where(['slug'=>'product_from_type'])->first();
        return view('admin.dictionary.formtype',compact('labels','model'));
    }

    public function store(Request $request){

        $news=$request->input('new');
        $old=$request->input('old');
        $arr=[];
        if($news){
            $arr_new=array_pluck($news,'name');
            $arr=array_merge($arr,$arr_new);
        }
        if($old){
            $arr_old=array_pluck($old,'name');
            $arr=array_merge($arr,$arr_old);
        }
        $arr_unique=array_unique($arr);
        if(count($arr_unique)!=count($arr)){
            return response()->json(['code'=>1,'msg'=>'存在重复的标签名称,请仔细检查']);
        }
        $model=Dictionary::where(['slug'=>'product_from_type'])->first();
        if(count($arr)>$model->max_num){
            return response()->json(['code'=>1,'msg'=>"最多添加".$model->max_num."条标签"]);
        }
        $old_ids=$request->input('ids',[]);
        DB::beginTransaction();
        try{
            ProductArticleFromType::whereNotIn('id',$old_ids)->delete();
            if($old){
                foreach ($old as $item){
                    $id=$item['id'];
                    unset($item['id']);
                    ProductArticleFromType::where(['id'=>$id])->update($item);
                }
            }
            if($news){
                foreach ($news as $value){
                    ProductArticleFromType::create($value);
                }
            }
            $query=ProductArticleFromType::select()->orderBy('sort','desc');
            $labels=$query->get();
            $names=[];
            if($labels){
                foreach ($labels as $key=>$label){
                    $names[]='<span style="color: '.$label->color.'">'.$label->name.'</span>';
                }
            }
            Dictionary::where(['slug'=>'product_from_type'])->update([
                'content'=>implode('、',$names),
                'model_ids'=>$query->pluck('id')->toJson()
            ]);
            DB::commit();
            return response()->json(['code'=>0,'msg'=>'保存成功']);
        }catch (\Exception $exception){
            DB::rollBack();
            return response()->json(['code'=>1,'msg'=>'保存失败'.$exception->getMessage()]);
        }
    }
}
