<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/10/30
 * Time: 15:57
 */

/**
 * Excel导出
 * @param $title
 * @param $array
 */
function excel_export($title,$array){

    $title=date('YmdHis').'-'.$title;

    \Maatwebsite\Excel\Facades\Excel::create($title, function ($excel) use($array){

        $excel->sheet('表格1', function ($sheet) use($array) {
            $sheet->rows($array);
        });

    })->export('xls');
}


function getUidFromUserModelSnapshot($userModel_ids){
    $snapIds=[];
    if($userModel_ids){
        foreach ($userModel_ids as $userModel_id){
            $userModelSnapshot=\App\Models\UserModelSnapshot::select()->where('user_model_id',$userModel_id)->orderBy('id','desc')->first();
            if($userModelSnapshot){
                $snapIds[]=$userModelSnapshot->id;
            }
        }
    }
    $uids=[];
    if($snapIds){
        $uids=\App\Models\UserModelSnapshot::select()->whereIn('id',$snapIds)->pluck('client_user_ids')->collapse()->unique()->values()->all();
    }
    return $uids;
}


/**
 * 图片显示绝对地址
 * @param $path
 */
function iAsset($path){

    return env('IMG_URL').$path;
}


/**
 * 获取下一个渠道码
 * @param string $platform
 * @return string
 */
function nextChannel()
{
    $maxId = \App\Models\Channel::max('channel_code');
    if (empty($maxId) || !is_numeric($maxId)) {
        $next = 100001;
    } else {
        $next = $maxId + 1;
    }
    return $next;
}

/**
 * 生成时间段内的日期
 * @param $start
 * @param $end
 * @throws Exception
 */
function createPeriodDate($start,$end){
    $begin = new DateTime( $start );
    $end = new DateTime( $end );
    $end = $end->modify( '+1 day' );

    $interval = new DateInterval('P1D');
    $daterange = new DatePeriod($begin, $interval ,$end);

    $dates=[];
    foreach($daterange as $date){
        $dates[]=$date->format('Y-m-d');
    }
    return $dates;
}

/**
 * 模板生成
 * @param $distribute_id
 * @param $channel_code
 * @param $template
 * @return string
 */
function create_templat_html($distribute_id,$channel_code,$template)
{
    if(!file_exists(public_path('pages/html/'.$channel_code))) mkdir(public_path('pages/html/'.$channel_code));
    $url ='t='.$distribute_id;
    $encodeName = base64_encode($url);
    $filedata =file_get_contents(public_path('pages/template/'.$template));
    file_put_contents(public_path('pages/html/'.$channel_code.'/'.$encodeName.'.html'), $filedata);
    return $path=$channel_code.'/'.$encodeName.'.html';
}

/**
 * @param $type | type :sms 验证码
 * @param $key | 键值
 * @param $value |
 * @return int
 */
function set_local_key($type,$key,$value){
    if($type == 'sms') {
        $data = ['data' =>['sms'=> [$key => $value, 'time' => time()]]];
        file_put_contents(public_path('local.log'), json_encode($data));
        return 1;
    }else{
        return 0;
    }
}

/**
 * @param $type | sms:验证码
 * @param $key
 * @param null $time
 * @return int
 */
function get_local_key($type,$key,$time=null){

    if($type == 'sms') {
        $string = file_get_contents(public_path('local.log'));
        $data = json_decode($string, true);
        if($data){
            if (array_key_exists($key, $data['data']['sms'])) {
                $now = time();
                if ($now > $data['data']['sms']['time'] + $time) { //
                    unset($data['data']['sms'][$key]);
                    unset($data['data']['sms']['time']);
                    file_put_contents(public_path('local.log'), json_encode($data));
                    $res = 0;
                } else {
                    $res = $data['data']['sms'][$key];
                }
            } else {
                $res = 0;
            }
        }else{
            $res = 0;
        }
        return $res;
    }else{
        return 0;
    }
}

/**
 * @param $type   | sms:验证码
 * @param $key
 * @return int
 * 删除key
 */
function del_local_key($type,$key){
    if($type == 'sms') {
        $string = file_get_contents(public_path('local.log'));
        $data = json_decode($string, true);
        if (array_key_exists($key, $data['data']['sms'])) {
            unset($data['data']['sms'][$key]);
            unset($data['data']['sms']['time']);
            file_put_contents(public_path('local.log'), json_encode($data));
            $res = 1;
        }else{
            $res = 2;
        }
    }else{
        $res = 0;
    }
    return $res;
}

/**
 * @param $url
 * @return string
 */
function set_img_url($url){
    $preg = "/^http?:\\/\\/.+/";
    if(!preg_match($preg,$url))
    {
        return env('PC_URL').$url;
    }else
    {
        return $url;
    }
}

