function $_(id) {
    return document.getElementById(id);
}

function $create(str) {
    return document.createElement(str);
}


//柱子的颜色数组			
let colorArr = ["red", "green", "yellow", "blue", "pink", "orange", "gray", "purple"];


function getMaxMoney(jsonArr) {
    let max = jsonArr[0].money;
    for (let i = 1; i < jsonArr.length; i++) {
        if (jsonArr[i].money > max) {
            max = jsonArr[i].money;
        }
    }
    return max;
}

function showVipHistogram(jsonArr) {
    if(!$_("vip-histogram")){
        return;
    }
    $_("vip-histogram").innerHTML = "";
    //最大金额
    let maxMoney = getMaxMoney(jsonArr);
    //大容器的高度-50；
    let maxHeight = $_('vip-histogram').offsetHeight;
    //比例（金额像素比）
    let rate = maxHeight / maxMoney;

    //留白的宽度
    let spaceWidth = $_('vip-histogram').offsetWidth / (jsonArr.length * 2 + 1);
    if (spaceWidth > 40) {
        spaceWidth = 40;
    }
    //柱子的宽度
    let zhuWidth = $_('vip-histogram').offsetWidth / (jsonArr.length * 2 + 1);
    if (zhuWidth > 40) {
        zhuWidth = 40;
    }
    for (let i = 0; i < jsonArr.length; i++) {
        //放置金钱，颜色柱子，年份的容器
        let contentDom = $create("div")
        let left = (i + 1) * spaceWidth + i * zhuWidth; //
        contentDom.style.cssText = "position: absolute;	bottom: -20px;left:" + left + "px;";
        $_("vip-histogram").appendChild(contentDom);
        //放置金额的span元素
        let moneySpanDom = $create("span");
        moneySpanDom.innerHTML = jsonArr[i].money;
        moneySpanDom.style.cssText = "display: block;height: 20px;width: 40px;text-align: center;";
        contentDom.appendChild(moneySpanDom);
        //颜色柱子
        let colorPillDom = $create("div")
        let height = jsonArr[i].money * rate;
        colorPillDom.style.cssText = "width: " + zhuWidth + "px;height: " + height + "px;background-color:" + colorArr[i % colorArr.length] + ";";
        contentDom.appendChild(colorPillDom);
        //放置vip的span元素
        let vipImgDom = $create("span");
        vipImgDom.innerHTML = "<img src='/images/VIPlogo/V"+jsonArr[i].name +".png' style='width:15px;' alt='' >";
        vipImgDom.style.cssText = "display: block;height: 20px;width: 40px;text-align: center;";
        contentDom.appendChild(vipImgDom);
    }
}

