

$(function () {
    // 软文切换
    $('#article-tab li').each(function () {
        $(this).on('click', function (e) {
            $('#article-tab li').removeClass('cur');
            $(this).addClass('cur');
            $('#articleResList .tabCon').hide();
            $('.article-view-item-'+$(this).attr('ind')).show();
            
        })
    })
    // 朋友圈切换
    $('#friend-tab li').each(function () {
        $(this).on('click', function (e) {
            $('#friend-tab li').removeClass('cur');
            $(this).addClass('cur');
            $('#friendResList .tabCon').hide();
            $('.friend-view-item-'+$(this).attr('ind')).show();
            setRadar('friend_'+$(this).attr('ind')+'_1')
            setRadar('friend_'+$(this).attr('ind')+'_2')
        })
    })
    // 朋友圈切换
    $('#live-tab li').each(function () {
        $(this).on('click', function (e) {
            $('#live-tab li').removeClass('cur');
            $(this).addClass('cur');
            $('#liveResList .tabCon').hide();
            $('.live-view-item-'+$(this).attr('ind')).show();
            setRadar('live_'+$(this).attr('ind')+'_1')
            setRadar('live_'+$(this).attr('ind')+'_2')
        })
    })

    setRadar('friend_1_1')
    setRadar('friend_1_2')
    setRadar('live_1_1')
    setRadar('live_1_2')
})

function setRadar(id) {
    var option = {
        tooltip: {},
        radar: {
            name: {
                textStyle: {
                    color: '#999',
                    backgroundColor: '#999',
                    borderRadius: 3,
                    padding: [3, 5]
                }
            },
            indicator: [{
                name: '人气值',
                max: 6500
            },
            {
                name: '覆盖率',
                max: 16000
            },
            {
                name: '传播率',
                max: 30000
            },
            {
                name: '传播力',
                max: 38000
            },
            {
                name: '知名度',
                max: 52000
            },
            {
                name: '性价比',
                max: 25000
            }
            ]
        },
        series: [{
            name: '朋友圈',
            type: 'radar',
            symbol: 'circle', // 拐点的样式，还可以取值'rect','angle'等
            symbolSize: 8, // 拐点的大小
            data: [{
                value: [4300, 10000, 28000, 35000, 50000, 19000],
                name: 'k',
                itemStyle: {
                    normal: {
                        color: 'rgba(78,182,255,0.6)',
                        lineStyle: {
                            color: 'rgba(255,225,0,.3)',
                        },
                    },
                },
                areaStyle: {
                    normal: {
                        opacity: 0.6,
                        color: new echarts.graphic.RadialGradient(0.5, 0.5, 1, [
                            {
                                color: '#63baf7',
                                offset: 0
                            },
                            {
                                color: '#4eb6ff',
                                offset: 1
                            }
                        ])
                    }
                }
            }
            ]
        }]
    };
    //初始化echarts实例
    var myChart = echarts.init(document.getElementById(id));
    //使用制定的配置项和数据显示图表
    myChart.setOption(option);
}