// 用户数据模块
var UserModule = function  () {
	this.url  = '';		// 异步接口url
	this.data = {};		// 请求参数
}

UserModule.prototype = {
	constructor: UserModule,
	// 异步请求数据api
	_getData: function (callback) {
		$.ajax({
		   	type: "POST",
		   	url: this.url,
		   	dataType: 'json',
		   	data: this.data,
		   	success: function(data){
		   		callback(data);
		   	}
		});
	},

	// 校验手机号是否存在
	// userType(广告主/媒介主),mobile(手机号码)
	checkUserHasMobile: function (data, callback) {
		this.url  = '/userHasMobileDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 获取(get)用户信息api
	getUserInfo: function (callback) {
		this.url = '/companyHome/userInfoDt.json';
		this._getData(callback);
	},

	// 保存(set)用户信息api
	setUserInfo: function (data, callback) {
		this.url  = '/companyHome/userInfoEditDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 修改登录您密码
	setUserPwdEdit: function (data, callback) {
		this.url  = '/companyHome/userPwdEditDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 保存(set)用户新密码api
	// userType(广告主或媒介主),mobile(手机号),newPwd(密码1),newPwd2(密码2),token(返回的token)
	setUserPwd: function (data, callback) {
		this.url  = '/userPwdResetDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 保存(set)新支付密码api
	// newPwd(密码1),newPwd2(密码2),mobile(手机号),token(返回的token)
	setUserPayPwd: function (data, callback) {
		this.url  = '/companyHome/userPayPwdEditDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 校验短信验证码api
	// mobile(手机号),smsCode(短信验证码)
	checkSms: function (data, callback) {
		this.url  = '/smsCodeCheckDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 判断手机是否已绑定api
	isExitMobile: function (data, callback) {
		this.url  = '/userHasMobileDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 发送手机验证码--在未登录的状态下
	// userType(广告主或媒介主),mobile(手机号),type(reg注册/reset找回密码),code(图形验证码)
	sendSmsMobile: function (data, callback) {
		this.url  = '/smsCodeSendDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 发送手机验证码--在已登录的状态下
	// userType(广告主或媒介主),mobile(手机号),type(reg注册/reset找回密码)
	sendSmsMobileLogined: function (data, callback) {
		this.url  = '/companyHome/smsCodeSendDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 保存(set)新手机api
	setUserNewMobile: function (data, callback) {
		this.url  = '/companyHome/userNewMobileEditDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 获取邮箱验证码api /companyHome/mailCodeSendDt
	sendMailCode: function (data, callback) {
		this.url  = '/companyHome/mailCodeSendDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 保存(set)新邮箱api
	setUserNewEmail: function (data, callback) {
		this.url  = '/companyHome/userNewEmailEditDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 判断邮箱是否已存在api
	isExitEmail: function (data, callback) {
		this.url  = '/userHasEmailDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 获取(get)用户账单api
	getBillList: function (data, callback) {
		this.url  = '/companyHome/billListDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 获取userNeedPlate
	getUserNeedPlate: function (callback) {
		this.url  = '/companyHome/userNeedPlateListDt.json';
		this._getData(callback);
	},

	// 保存userNeedPlate
	setUserNeedPlate: function (data, callback) {
		this.url  = '/companyHome/userNeedPlateAddDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 判断用户是否登录
	userIsLogin: function (callback) {
		this.url  = '/userIsLoginDt.json';
		this._getData(callback);
	},

	// 用户登录
	userLogin: function (data, callback) {
		this.url  = '/userLoginDt.json';
		this.data = data;
		this._getData(callback);
	},

	// 用户退出
	userExit: function (callback) {
		this.url  = '/userExitDt.json';
		this._getData(callback);
	},

	// 提交充值
	userPaySubmit: function (data, callback) {
		this.url  = '/userFront/paySubmit.html';
		this.data = data;
		this._getData(callback);
	},

	// 导出账单api
	billExport: function (data, callback) {
		this.url  = '/companyHome/billing/export.json';
		this.data = data;
		this._getData(callback);
	}
}
