@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header">提现申请</div>
        <div class="layui-card-body" style="padding: 15px;">
            <form class="layui-form" method="post">
                {{ csrf_field() }}
                <input type="hidden" name="id" value="{{ isset($info)?$info->id:'' }}">
                <input type="hidden" name="mid" value="{{ isset($info)?$info->mid:'' }}">
                <div class="layui-form-item">
                    <label class="layui-form-label"><strong class="item-required">*</strong>用户手机号</label>
                    <div class="layui-input-block">
                        <input type="text" name="phone" lay-verify="phone" autocomplete="on" placeholder="请输入手机号" class="layui-input" value="{{ $info ? $info->member['phone'] : ''}}" maxlength="15" onblur="checkPhone(this)" id="phone">
                    </div>
                </div>
                <div class="layui-form-item" >
                    <label class="layui-form-label"><strong class="item-required"></strong>支付宝名称</label>
                    <div class="layui-input-block">
                        <input type="text" id="account"  lay-verify="" autocomplete="off" placeholder="打款账号" class="layui-input" value="{{ $account ? $account->alipay_name :'' }}" maxlength="15" readonly>
                    </div>
                </div>
                <div class="layui-form-item" >
                    <label class="layui-form-label"><strong class="item-required"></strong>支付宝账号</label>
                    <div class="layui-input-block">
                        <input type="text" id="account"  lay-verify="" autocomplete="off" placeholder="打款账号" class="layui-input" value="{{ $account ? $account->alipay_account :'' }}" maxlength="15" readonly>
                    </div>
                </div>
                <div class="layui-form-item" >
                    <label class="layui-form-label"><strong class="item-required"></strong>账户余额（元）</label>
                    <div class="layui-input-block">
                        <input type="text" id="money"  lay-verify="" autocomplete="off" placeholder="账户余额" class="layui-input" value="{{ $money ? $money->total_money :0 }}" maxlength="15" readonly>
                    </div>
                </div>
                <div class="layui-form-item" >
                    <label class="layui-form-label"><strong class="item-required"></strong>申请金额（元）</label>
                    <div class="layui-input-block">
                        <input type="text" id="total_money" name="money" lay-verify="" autocomplete="off" placeholder="充值金额" class="layui-input" value="{{ $info ? $info->money : ''}}" maxlength="15" readonly>
                    </div>
                </div>
                <div class="layui-form-item layui-input-inline">
                    <label class="layui-form-label"><strong class="item-required"></strong>结算金额（元）</label>
                    <div class="layui-input-block" >
                        <input style="display: inline-block;width: 60%;margin-right: 10px;" type="text" name="received" lay-verify="received" autocomplete="off" placeholder="充值金额" class="layui-input" value="{{ $info->rate_money ??'' }}" maxlength="15"  readonly id="received">
                        @if($info->status != 3 )<a class="layui-btn" onclick="checkMoney(this)">系统结算</a>@endif
                    </div>
                </div>

                <div class="layui-form-item">
                    <label class="layui-form-label"><strong class="item-required">*</strong>操作意见</label>
                    <div class="layui-input-block">
                        <span style="display: @if($info->status >1) none @else  block @endif ">
                            <input type="radio" name="status"  lay-filter="status" value="2" title="同意" @if(!isset($info) || $info->status == 2 ) checked  @endif >
                            <div class="layui-unselect layui-form-radio layui-form-radioed"><i class="layui-anim layui-icon"></i>
                                <div>同意</div>
                            </div>
                        </span>
                        <span style="display: @if($info->status >1) block @else  none @endif " >
                            <input type="radio" name="status" lay-filter="status" value="3" title="完成" @if(isset($info) && $info->status == 3 ) checked @endif>
                            <div class="layui-unselect layui-form-radio"><i class="layui-anim layui-icon"></i>
                                <div>完成</div>
                            </div>
                        </span>
                        <span style="display: @if($info->status ==3) none @else  block @endif ">
                            <input type="radio" name="status" lay-filter="status" value="0" title="拒绝" @if(isset($info) && $info->status == 0 ) checked @endif>
                            <div class="layui-unselect layui-form-radio"><i class="layui-anim layui-icon"></i>
                                <div>拒绝</div>
                            </div>
                        </span>
                    </div>
                </div>
                <div class="layui-form-item images"  style="display:@if($info->image || $info->status == 3) block @else none @endif ;">
                    <label for="" class="layui-form-label"><strong class="item-required"></strong>打款凭证</label>
                    <div class="layui-input-inline">
                        <button type="button" class="layui-btn" id="logo">上传图片</button>
                        <button type="button" class="layui-btn layui-btn-danger layui-btn-sm" style="display: none" id="logoRemove">移除</button>
                        <div class="layui-upload-list">
                            <img class="layui-upload-img" id="logoImg" style="width: 100px;height: 100px" src="{{ $info->image ? env('IMG_URL').$info->image : '' }}">
                            <input type="hidden" name="logo" value="" lay-verify="logo">
                            <p id="logoText"></p>
                        </div>
                        <span>建议尺寸 : 98*98</span>
                    </div>
                </div>
                <div class="layui-form-item layui-form-text mark-content" style="display:@if($info->mark) block @else none @endif;" >
                    <label class="layui-form-label"><strong class="item-required"></strong>处理意见</label>
                    <div class="layui-input-block">
                        <textarea name="mark" placeholder="请输入处理意见" class="layui-textarea" lay-verify="mark" maxlength="50"  id="" >{{ $info->mark??'' }}</textarea>
                    </div>
                </div>
                <div class="layui-form-item layui-layout-admin">
                    <div class="layui-input-block">
                        <div class="layui-footer" style="left: 0;">
                            <button class="layui-btn" lay-submit lay-filter="*">立即提交</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('script')
    <script>
        layui.use(['upload','form'],function () {
            var form = layui.form;
            var upload=layui.upload;

            //logo上传
            var uploadInst = upload.render({
                elem: '#logo'
                ,url: '/uploadImage'
                ,size:1024
                ,data:{"_token":"{{ csrf_token() }}"}
                ,before: function(obj){
                    //预读本地文件示例，不支持ie8
                    obj.preview(function(index, file, result){
                        $('#logoImg').attr('src', result); //图片链接（base64）
                        $('#logoRemove').show();
                    });
                    $('#logoRemove').on('click',function () {
                        $('#logoImg').attr('src',null);
                        $('#logoRemove').hide();
                        $('input[name="logo"]').val('');
                    });
                }
                ,done: function(res){
                    if(res.code === 0){
                        $('input[name="logo"]').val(res.url);
                    }else {
                        return layer.msg('上传失败');
                    }
                }
                ,error: function(){
                    //演示失败状态，并实现重传
                    var demoText = $('#logoText');
                    demoText.html('<span style="color: #FF5722;">上传失败</span> <a class="layui-btn layui-btn-xs demo-reload">重试</a>');
                    demoText.find('.demo-reload').on('click', function(){
                        uploadInst.upload();
                    });
                }
            });

            form.verify({
                phone:function(value, item){ //value：表单的值、item：表单的DOM对象
                    if(!value){
                        return '电话号码不能为空'
                    }
                }
                ,money:function(value, item){ //value：表单的值、item：表单的DOM对象
                    if(!value){
                        return '金额不能为空';
                    }
                    if((+value) > (+$("#total_money").val())){
                        return '提现金额不能大于账户余额'
                    }
                }
                ,received:function(value, item){ //value：表单的值、item：表单的DOM对象
                    if(!value){
                        return '金额不能为空';
                    }
                    if((+value) > (+$("#total_money").val())){
                        return '结算金额不能大于申请金额'
                    }
                }
            });
            form.on('radio(status)', function(data){
                if(data.value == 3){
                    $(".images").show()
                    $(".mark-content").hide()
                }
                if(data.value == 0){
                    $(".images").hide()
                    $(".mark-content").show()
                }
                if(data.value == 2){
                    $(".images").hide()
                    $(".mark-content").hide()
                }
            });
        })

        /**
         * 用户检查
         * @param obj
         */
        function checkPhone(obj){
            var params = {phone:$(obj).val()}
            $.ajax({
                url:'{{ route('admin.account.check') }}',
                type: "post",
                data: params,
                dataType: "json",
                success:function(res){
                    if(res.code == 1){
                        layer.msg(res.info,{icon:2});
                        $("#phone").val('');
                    }
                    if(res.code == 0){
                        if(res.data.money){
                            $("#total_money").val(res.data.money);
                        }else{
                            $("#total_money").val(0);
                        }
                    }
                }
            })
        }
        /**
         *
         * @param obj
         */
        function checkMoney(obj){
            var params = {phone:$("#phone").val(),money:$("#total_money").val()}
            $.ajax({
                url:'{{ route('admin.account.cash') }}',
                type: "post",
                data: params,
                dataType: "json",
                success:function(res){
                    if(res.code == 1){//异常
                        layer.msg(res.info,{icon:2});
                        $("#money").val('');
                    }else{
                        $("#received").val(res.data.money);
                        $(obj).removeAttr('onclick');
                    }
                }
            })
        }
    </script>


@endsection