@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header">后台充值(只能为广告主充值)</div>
        <div class="layui-card-body" style="padding: 15px;">
            <form class="layui-form" method="post">
                {{ csrf_field() }}
                <div class="layui-form-item">
                    <label class="layui-form-label"><strong class="item-required">*</strong>用户手机号</label>
                    <div class="layui-input-block">
                        <input type="text" name="phone" lay-verify="phone" autocomplete="on" placeholder="请输入手机号" class="layui-input" value="{{ $info->name??'' }}" maxlength="15" onblur="checkPhone(this)" id="phone">
                    </div>
                </div>

                <div class="layui-form-item">
                    <label class="layui-form-label"><strong class="item-required">*</strong>充值金额</label>
                    <div class="layui-input-block">
                        <input type="text" name="money" lay-verify="money" autocomplete="off" placeholder="充值金额" class="layui-input" value="" maxlength="15">
                    </div>
                </div>
                <div class="layui-form-item layui-layout-admin">
                    <div class="layui-input-block">
                        <div class="layui-footer" style="left: 0;">
                            <button class="layui-btn" lay-submit lay-filter="*">立即提交</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('script')
    <script>
        layui.use('form',function () {
            var form = layui.form;
            form.verify({
                phone:function(value, item){ //value：表单的值、item：表单的DOM对象
                    if(!value){
                        return '电话号码不能为空'
                    }
                }
                ,money:function(value, item){ //value：表单的值、item：表单的DOM对象
                    if(!value){
                        return '金额不能为空';
                    }
                }
            });
        })

        /**
         * 用户检查
         * @param obj
         */
        function checkPhone(obj){
            var params = {phone:$(obj).val()}
            $.ajax({
                url:'{{ route('admin.account.check') }}',
                type: "post",
                data: params,
                dataType: "json",
                success:function(res){
                    if(res.code == 1){
                        layer.msg(res.info,{icon:2});
                        $("#phone").val('');
                    }
                }
            })
        }

    </script>


    @endsection