@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto">
            <h2>详情</h2>
        </div>
        <div class="layui-card-body">
            <form class="layui-form" action="" method="post">
                {{csrf_field()}}

                <div class="layui-form-item">
                    <label for="" class="layui-form-label">
                        <strong class="item-required"></strong>类型：</label>
                    <div class="layui-input-block">
                        <input type="text" name="url" maxlength="255" value="{{ $info->type == 1 ? '订单下单':'用户充值' }}" lay-verify="url" placeholder="请输入链接" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item" style="display: @if($info->type == 1) block  @else none  @endif ;">
                    <label for="" class="layui-form-label">
                        <strong class="item-required"></strong>订单编号：</label>
                    <div class="layui-input-block">
                        <input type="text" name="url" maxlength="255" value="{{ isset($order) ? $order->order_no : ''  }}" lay-verify="url" placeholder="请输入链接" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item" style="display: @if($info->type == 1) block  @else none  @endif ;">
                    <label for="" class="layui-form-label">
                        <strong class="item-required"></strong>下单资源：</label>
                    <div class="layui-input-block">
                        <input type="text" name="url" maxlength="255" value="{{ isset($order) ? $order->product['name'] :''  }}" lay-verify="url" placeholder="请输入链接" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item" style="display: @if($info->type == 1) block  @else none  @endif ;">
                    <label for="" class="layui-form-label">
                        <strong class="item-required"></strong>下单时间：</label>
                    <div class="layui-input-block">
                        <input type="text" name="url" maxlength="255" value="{{ isset($order) ? $order->created_at :''  }}" lay-verify="url" placeholder="请输入链接" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item" >
                    <label for="" class="layui-form-label">
                        <strong class="item-required"></strong>交易金额：</label>
                    <div class="layui-input-block">
                        <input type="text" name="url" maxlength="255" value="{{ isset($info) ? $info->money :''  }}" lay-verify="url" placeholder="请输入链接" class="layui-input" >
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required"></strong>备注</label>
                    <div class="layui-input-block">
                        <textarea name="mark" maxlength="1000" placeholder="请输入完成备注" lay-verify="my_answer" class="layui-textarea">{{ isset($payLogs)?$payLogs->result:$info->mark }}</textarea>
                    </div>
                </div>
                <div class="layui-form-item">
                    <div class="layui-input-block">
                        <a  class="layui-btn" href="javascript:history.go(-1)" >返 回</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('script')
        <script>


        layui.use(['form'],function () {
            var form = layui.form;

            form.verify({
                my_text: function(value, item){ //value：表单的值、item：表单的DOM对象
                    if(value == ''){
                        return '连接不能为空！';
                    }
                },
                my_answer: function (value, item) {

                    if(value == ''){
                        return '回答不能为空';
                    }
                    if(value.trim().replace(/\s/g,"").length >1000){
                        return '回答最多1000个字';
                    }

                },

            });
        });





    </script>

@endsection