@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header">用户退款</div>
        <div class="layui-card-body" style="padding: 15px;">
            <form class="layui-form" method="post">
                {{ csrf_field() }}
                @if(isset($info))
                <input type="hidden" name="id" value="{{ $info ? $info->id : '' }}">
                @endif
                <div class="layui-form-item">
                    <label class="layui-form-label"><strong class="item-required">*</strong>用户手机号</label>
                    <div class="layui-input-block">
                        <input type="text" name="phone" lay-verify="phone" autocomplete="on" placeholder="请输入手机号" class="layui-input" value="{{ isset($info) ? $info->member['phone'] : ''}}" maxlength="15" onblur="checkPhone(this)" id="phone">
                    </div>
                </div>
                <div class="layui-form-item" >
                    <label class="layui-form-label"><strong class="item-required"></strong>账户余额（元）</label>
                    <div class="layui-input-block">
                        <input type="text" id="total_money" lay-verify="" autocomplete="off" placeholder="充值金额" class="layui-input" value="{{ $total_money ?? '' }}" maxlength="15" readonly>
                    </div>
                </div>
                <div class="layui-form-item" >
                    <label class="layui-form-label"><strong class="item-required"></strong>支付宝名称</label>
                    <div class="layui-input-block">
                        <input type="text" id="account_name"  name="account_name" lay-verify="" autocomplete="off" placeholder="打款账号" class="layui-input" value="{{ isset($account)?$account->alipay_name:'' }}" maxlength="15" readonly>
                    </div>
                </div>
                <div class="layui-form-item" >
                    <label class="layui-form-label"><strong class="item-required"></strong>支付宝账号</label>
                    <div class="layui-input-block">
                        <input type="text" id="account_no"  lay-verify="" name="account_no" autocomplete="off" placeholder="打款账号" class="layui-input" value="{{ isset($account)?$account->alipay_account:'' }}" maxlength="15" readonly>
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label"><strong class="item-required">*</strong>退款金额（元）</label>
                    <div class="layui-input-block">
                        <input type="text" name="money" lay-verify="money" autocomplete="off" placeholder="充值金额" class="layui-input" value="{{ isset($info) ? $info->apply_money :'' }}" maxlength="15" onblur="checkMoney(this)" id="money" @if(isset($info)) readonly @endif>
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label"><strong class="item-required"></strong>到账金额（元）</label>
                    <div class="layui-input-block">
                        <input type="text" name="received" lay-verify="received" autocomplete="off" placeholder="充值金额" class="layui-input" value="{{ $info->check_money ??'' }}" maxlength="15"  readonly id="received">
                    </div>
                </div>
                @if(isset($info))
                    <div class="layui-form-item">
                        <label class="layui-form-label"><strong class="item-required"></strong>操作人</label>
                        <div class="layui-input-block">
                            <input type="text" name="" lay-verify="" autocomplete="off" placeholder="操作人" class="layui-input" value="{{ $info->user ?$info->user->name:'' }}" maxlength="15"  readonly id="">
                        </div>
                    </div>
                @endif
                <div class="layui-form-item images">
                    <label for="" class="layui-form-label"><strong class="item-required"></strong>打款凭证</label>
                    <div class="layui-input-inline">
                        <button type="button" class="layui-btn" id="logo">上传图片</button>
                        <button type="button" class="layui-btn layui-btn-danger layui-btn-sm" style="display: none" id="logoRemove">移除</button>
                        <div class="layui-upload-list">
                            <img class="layui-upload-img" id="logoImg" style="width: 100px;height: 100px" src="{{ isset($info) ? env('IMG_URL').$info->image : '' }}">
                            <input type="hidden" name="logo" value="" lay-verify="logo">
                            <p id="logoText"></p>
                        </div>
                        <span>建议尺寸 : 98*98</span>
                    </div>
                </div>
                <div class="layui-form-item layui-layout-admin">
                    <div class="layui-input-block">
                        <div class="layui-footer" style="left: 0;">
                            @if(isset($info))
                                <a class="layui-btn" href="{{ route('admin.refund') }}">返回</a>
                                @else
                                <button class="layui-btn" lay-submit lay-filter="*">立即提交</button>
                            @endif
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('script')
    <script>
        layui.use(['form','upload'],function () {
            var form = layui.form;
            var upload=layui.upload;

            //logo上传
            var uploadInst = upload.render({
                elem: '#logo'
                ,url: '/uploadImage'
                ,size:1024
                ,data:{"_token":"{{ csrf_token() }}"}
                ,before: function(obj){
                    //预读本地文件示例，不支持ie8
                    obj.preview(function(index, file, result){
                        $('#logoImg').attr('src', result); //图片链接（base64）
                        $('#logoRemove').show();
                    });
                    $('#logoRemove').on('click',function () {
                        $('#logoImg').attr('src',null);
                        $('#logoRemove').hide();
                        $('input[name="logo"]').val('');
                    });
                }
                ,done: function(res){
                    if(res.code === 0){
                        $('input[name="logo"]').val(res.url);
                    }else {
                        return layer.msg('上传失败');
                    }
                }
                ,error: function(){
                    //演示失败状态，并实现重传
                    var demoText = $('#logoText');
                    demoText.html('<span style="color: #FF5722;">上传失败</span> <a class="layui-btn layui-btn-xs demo-reload">重试</a>');
                    demoText.find('.demo-reload').on('click', function(){
                        uploadInst.upload();
                    });
                }
            });

            form.verify({
                phone:function(value, item){ //value：表单的值、item：表单的DOM对象
                    if(!value){
                        return '电话号码不能为空'
                    }
                }
                ,money:function(value, item){ //value：表单的值、item：表单的DOM对象
                    if(!value){
                        return '金额不能为空';
                    }
                    if((+value) > (+$("#total_money").val())){
                        return '退款金额不能大于账户余额'
                    }
                }
                ,received:function(value, item){ //value：表单的值、item：表单的DOM对象
                    if(!value){
                        return '金额不能为空';
                    }
                    if((+value) > (+$("#total_money").val())){
                        return '结算金额不能大于申请金额'
                    }
                }
            });
        })

        /**
         * 用户检查
         * @param obj
         */
        function checkPhone(obj){
            var params = {phone:$(obj).val()}
            $.ajax({
                url:'{{ route('admin.account.check') }}',
                type: "post",
                data: params,
                dataType: "json",
                success:function(res){
                    if(res.code == 1){
                        layer.msg(res.info,{icon:2});
                        $("#phone").val('');
                    }
                    if(res.code == 0){
                        if(res.data.money){
                            $("#total_money").val(res.data.money);
                            $("#account_name").val(res.data.account.alipay_name);
                            $("#account_no").val(res.data.account.alipay_account);
                        }else{
                            $("#total_money").val(0);
                        }
                    }
                }
            })
        }
        /**
         *
         * @param obj
         */
        function checkMoney(obj){
            var params = {phone:$("#phone").val(),money:$(obj).val()}
            $.ajax({
                url:'{{ route('admin.account.refund') }}',
                type: "post",
                data: params,
                dataType: "json",
                success:function(res){
                    if(res.code == 1){//异常
                        layer.msg(res.info,{icon:2});
                        $("#money").val('');
                    }else{
                        $("#received").val(res.data.money);
                    }
                }
            })
        }
    </script>


@endsection