@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto layui-form">
            <form class="layui-form-item" id="search-form">
                <input type="hidden" name="from" value="platform">
                <div class="layui-inline">
                    <label class="layui-form-label">时间区间</label>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" placeholder="开始时间" name="start_time" id="start_time" autocomplete="off">
                    </div>
                    <div class="layui-form-mid">至</div>
                    <div class="layui-input-inline">
                        <input type="text" class="layui-input" placeholder="结束时间" name="end_time" id="end_time" autocomplete="off">
                    </div>
                </div>
                {{--@include('admin.component.department-channel')--}}
                {{--<div class="layui-inline" >
                    <label class="layui-form-label">产品类型</label>
                    <div class="layui-input-inline">
                        <select name="type"  id="type">
                            <option value="">所有产品类型</option>
                            <option value="product">资源产品</option>
                            <option value="credit">资源</option>

                        </select>
                    </div>
                </div>--}}
                <div class="layui-inline">
                    <label class="layui-form-label">申请平台</label>
                    <div class="layui-input-inline">
                        <select name="platform"  id="platform">
                            <option value="">所有申请平台</option>
                            <option value="android">android</option>
                            <option value="ios">ios</option>
                            <option value="pc">pc</option>
                            <option value="wap">wap</option>

                        </select>
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">订单状态</label>
                    <div class="layui-input-inline">
                        <select name="status"  id="status">
                            <option value="">所有订单</option>
                            <option value="1">待支付</option>
                            <option value="2">已支付/待接单</option>
                            <option value="3">取消/过期</option>
                            <option value="4">执行中</option>
                            <option value="5">已完成</option>
                            <option value="6">退单退款</option>

                        </select>
                    </div>
                </div>
               {{-- <div class="layui-inline">
                    <label class="layui-form-label">负责人</label>
                    <div class="layui-input-inline">
                        <input type="text" name="manager" id="manager"  placeholder="请输入渠道负责人" class="layui-input">
                    </div>
                </div>--}}
                <div class="layui-inline">
                    <label class="layui-form-label">用户电话</label>
                    <div class="layui-input-inline">
                        <input type="text" name="phone" id="phone"  placeholder="请输入用户电话" class="layui-input">
                    </div>
                </div>
                <div class="layui-inline">
                    <button class="layui-btn layuiadmin-btn-useradmin" lay-submit="" lay-filter="searchBtn">
                        <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
                    </button>
                </div>


            </form>

        </div>
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            {{--<script type="text/html" id="options">--}}
                {{--<div class="layui-btn-group">--}}
                    {{--@{{# if(d.status != 5){}}--}}
                        {{--<a class="layui-btn layui-btn-sm" lay-event="edit">处理</a>--}}
                    {{--@{{# }}}--}}
                    {{--<a class="layui-btn layui-btn-sm" lay-event="cancel">取消</a>--}}
                {{--</div>--}}
            {{--</script>--}}
            <script type="text/html" id="thumb">
                <a href="@{{d.thumb}}" target="_blank" title="点击查看"><img src="@{{d.thumb}}" alt="" width="28" height="28"></a>
            </script>

        </div>
    </div>
@endsection

@section('script')


        <script>
            layui.use(['layer','table','form','laydate','laypage'],function () {
                var layer = layui.layer;
                var form = layui.form;
                var table = layui.table;
                var laydate = layui.laydate;
                var laypage = layui.laypage;
                //用户表格初始化
                var dataTable = table.render({
                    elem: '#dataTable'
                    // ,height: 500
                    ,url: "{{ route('cloud.order.data') }}" //数据接口
                    ,page: true //开启分页
                    ,cols: [[ //表头
                        {checkbox: true,fixed: true}
                        // ,{field: 'id', title: 'ID', sort: true,width:80}
                        ,{field: 'order_no', title: '订单号'}
                        ,{field: 'order_status', title: '订单状态',templet: function(d){
                            alert(d.order_status);
                            if(d.order_status == 1){
                                return '未支付'
                            }else if(d.status == 2){
                                return '已支付/待执行'
                            }else if(d.status == 4){
                                return '执行中'
                            }else if(d.status == 5){
                                return '已完成'
                            }else if(d.status == 6){
                                return '已退单'
                            }else if(d.status == 7){
                                return '媒体主完成'
                            }else{
                                return '取消/过期'
                            }
                        }}
                        ,{field: 'phone', title: '用户电话',templet: function(d){
                                if(d.member != null){
                                    return d.member.phone
                                }else{
                                    return ''
                                }
                            }}
                        ,{field: 'model_id', title: '资源名称',templet: function(d){
                                if(d.product){
                                    return d.product.name
                                }else{
                                    return ''
                                }
                            }}
                        ,{field: 'productType', title: '资源类型',templet: function(d){
                            if(d.productType){
                                switch(d.productType){
                                    case 'article':
                                        return '软文';
                                        break;
                                    case 'weixin':
                                        return '公众号';
                                        break;
                                    case 'video':
                                        return '短视频';
                                        break;
                                    case 'weibo':
                                        return '微博';
                                        break;
                                    case 'redbook':
                                        return '小红书';
                                        break;
                                    default :
                                        return '';
                                        break;
                                }
                            }else{
                                return ''
                            }
                        }}
                        ,{field: 'product', title: '资源归属',templet: function(d){

                            if(d.product){
                                if(d.product.create_from == 'media'){
                                    return '媒体主资源'
                                }
                                if(d.product.create_from == 'cloud'){
                                    return '云资源'
                                }
                                return '平台资源'
                            }else{
                                return ''
                            }
                        }}
                        ,{field: 'money', title: '支付金额'}
                        ,{field: 'created_at', title: '下单时间'}
                        ,{field: '', title: '执行时间',templet: function(d){
                                if(d.start_time != null){
                                    return d.start_time
                                }else{
                                    return ''
                                }

                            }}
                        ,{field: '', title: '完成时间',templet: function(d){
                                if(d.complete_time){
                                    return d.complete_time
                                }else{
                                    return ''
                                }
                            }}
                        ,{field: 'result', title: '完成地址',templet: function(d){
                         if(d.result_url){
                                return d.result_url;
                            }else{
                                return '';
                            }
                         }}
                        ,{fixed: 'right', title:'操作',width: 100, align:'center', toolbar: '#options'}
                    ]]
                });



            });

        </script>

@endsection

