@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto">
            <h2>添加产品</h2>
        </div>
            <form class="layui-form" id="myForm" action="{{route('admin.product.store')}}" method="post">
                {{csrf_field()}}

                <link href="/static/admin/limit_district/css/style.css" type="text/css" rel="stylesheet">
                <script type="text/javascript" src="/static/admin/limit_district/js/jquery.min.js"></script>
                <script type="text/javascript" src="/static/admin/limit_district/js/City_data.js"></script>
                <script type="text/javascript" src="/static/admin/limit_district/js/areadata.js"></script>
                <script type="text/javascript" src="/static/admin/limit_district/js/auto_area.js"></script>

                <div class="layui-form-item">
                    <label for="" class="layui-form-label">产品分类</label>
                    <div class="layui-input-block">
                        @if($type->count())
                            @foreach($type as $k=>$column)
                                <input type="radio" name="type[]" lay-filter="resource_type" class="product_type" title="{{$column->name}}" lay-skin="primary" value="{{$column->id}}" {{in_array($column->id,$product->type->pluck('id')->all())?'checked':''}}>
                            @endforeach
                        @endif
                    </div>
                </div>
                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>产品logo</label>
                    <div class="layui-input-inline">
                        <button type="button" class="layui-btn" id="logo">上传图片</button>
                        <button type="button" class="layui-btn layui-btn-danger layui-btn-sm" style="display: none" id="logoRemove">移除</button>
                        <div class="layui-upload-list">
                            <img class="layui-upload-img" id="logoImg" style="width: 100px;height: 100px" @if($product->logo) src="{{iAsset($product->logo)}}" @endif>
                            <input type="hidden" name="logo" value="{{$product->logo}}" lay-verify="logo">
                            <p id="logoText"></p>
                        </div>
                        <span>建议尺寸 : 98*98</span>
                    </div>
                </div>


                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>产品名称</label>
                    <div class="layui-input-inline">
                        <input type="text" name="name" maxlength="50" value="{{$product->name??old('name')}}" lay-verify="required" class="layui-input" placeholder="请填写产品名称">
                    </div>
                </div>

                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>元素</label>
                    <div class="layui-input-block">
                        <input type="checkbox" name="market_element[]" title="火" lay-skin="primary" value="fire" {{in_array('fire',$product->market_element)?'checked':''}}>
                        <input type="checkbox" name="market_element[]" title="红包" lay-skin="primary" value="money" {{in_array('money',$product->market_element)?'checked':''}}>
                    </div>
                </div>

                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>图标</label>
                    <div class="layui-input-inline">
                        <select name="corner_id" id="">
                            <option value="0">不使用</option>
                            @if($corners->count())
                                @foreach($corners as $corner)
                                    <option value="{{$corner->id}}" {{$corner->id==$product->corner_id?'selected':''}}>{{$corner->name}}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                </div>

                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>产品标签</label>
                    <div class="layui-input-block">
                        @if($labels->count())
                            @foreach($labels as $label)
                                <input type="checkbox" name="label[]" lay-filter="label" class="product_label" title="{{$label->name}}" lay-skin="primary" value="{{$label->id}}" {{in_array($label->id,$product->label->pluck('id')->all())?'checked':''}}>
                            @endforeach
                        @endif
                    </div>
                </div>

                <div class="layui-form-item">
                    {{--<label for="" class="layui-form-label">所属类目（wap首页展示）</label>--}}
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>所属类目</label>
                    <div class="layui-input-block">
                        @if($categories->count())
                            @foreach($categories as $category)
                                <input type="checkbox" name="category[]" lay-filter="category" class="product_category" title="{{$category->name}}" lay-skin="primary" value="{{$category->id}}" {{in_array($category->id,$product->category->pluck('id')->all())?'checked':''}} >
                            @endforeach
                        @endif
                    </div>
                </div>

                <div class="layui-form-item">
                    {{--<label for="" class="layui-form-label">所属栏目wap首页展示</label>--}}
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>所属栏目</label>
                    <div class="layui-input-block">
                        @if($columns->count())
                            @foreach($columns as $column)
                                <input type="checkbox" name="column[]" lay-filter="column" class="product_column" title="{{$column->name}}" lay-skin="primary" value="{{$column->id}}" {{in_array($column->id,$product->column->pluck('id')->all())?'checked':''}} >
                            @endforeach
                        @endif
                    </div>
                </div>
                {{--软文类型开始---}}
                <div class="layui-form-item article" style="display: @if(isset($type_id) && $type_id == 1) block @else none  @endif;">
                    {{--<label for="" class="layui-form-label">网站类型（软文）</label>--}}
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>网站类型</label>
                    <div class="layui-input-block">
                        @if($website->count())
                            @foreach($website as $column)
                                <input type="checkbox" name="website[]" lay-filter="" class="" title="{{$column->name}}" lay-skin="primary" value="{{$column->id}}" {{in_array($column->id,$product->website->pluck('id')->all())?'checked':''}} >
                            @endforeach
                        @endif
                    </div>
                </div>
                <div class="layui-form-item article" style="display: @if(isset($type_id) && $type_id == 1) block @else none  @endif;">
                    {{--<label for="" class="layui-form-label">频道分类（软文）</label>--}}
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>频道分类</label>
                    <div class="layui-input-block">
                        @if($channel->count())
                            @foreach($channel as $column)
                                <input type="checkbox" name="channel[]" lay-filter="" class="" title="{{$column->name}}" lay-skin="primary" value="{{$column->id}}" {{in_array($column->id,$product->channel->pluck('id')->all())?'checked':''}}>
                            @endforeach
                        @endif
                    </div>
                </div>

                <div class="layui-form-item article" style="display: @if(isset($type_id) && $type_id == 1) block @else none  @endif;">
                    {{--<label for="" class="layui-form-label">收录参考（软文）</label>--}}
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>收录参考</label>
                    <div class="layui-input-block">
                        @if($collect->count())
                            @foreach($collect as $column)
                                <input type="checkbox" name="collect[]" lay-filter="" class="" title="{{$column->name}}" lay-skin="primary" value="{{$column->id}}" {{in_array($column->id,$product->collect->pluck('id')->all())?'checked':''}}>
                            @endforeach
                        @endif
                    </div>
                </div>
                {{--软文类型结束---}}
                {{--微博/微信开始---}}
                <div class="layui-form-item  wechat-sina-video" style="display: @if(isset($type_id) &&  in_array($type_id,[2,3,4,5,6])) block @else none  @endif;">
                    {{--<label for="" class="layui-form-label">粉丝数量（微博/微信/视频）</label>--}}
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>粉丝数量</label>
                    <div class="layui-input-inline">
                        <input type="number" name="fans" maxlength="10" value="{{$product->fans->fans??old('fans')}}" lay-verify="" class="layui-input" placeholder="">
                    </div>
                    <div class="layui-form-mid layui-word-aux">万</div>
                </div>
                <div class="layui-form-item  wechat-sina-video" style="display: @if(isset($type_id) &&  in_array($type_id,[2,3,4,5,6])) block @else none  @endif;">
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>浏览/观看数</label>
                    {{--<label for="" class="layui-form-label">浏览/观看数（微博/微信视频）</label>--}}
                    <div class="layui-input-inline">
                        <input type="number" name="views" maxlength="10" value="{{$product->views->views??old('views')}}" lay-verify="" class="layui-input" placeholder="">
                    </div>
                    <div class="layui-form-mid layui-word-aux">万</div>
                </div>
                <div class="layui-form-item wechat-sina " style="display: @if(isset($type_id) &&  in_array($type_id,[2,3,5,6])) block @else none  @endif;">
                    {{--<label for="" class="layui-form-label">资源类别（微博/微信）</label>--}}
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>资源类别</label>
                    <div class="layui-input-block">
                        @if($resource->count())
                            @foreach($resource as $column)
                                <input type="checkbox" name="resource[]" lay-filter="" class="" title="{{$column->name}}" lay-skin="primary" value="{{$column->id}}" {{in_array($column->id,$product->resource->pluck('id')->all())?'checked':''}}>
                            @endforeach
                        @endif
                    </div>
                </div>
                {{--微博/微信结束---}}

                {{--视频开始---}}
                <div class="layui-form-item video " style="display: @if(isset($type_id) && $type_id == 4) block @else none  @endif;">
                    {{--<label for="" class="layui-form-label">视频平台（视频）</label>--}}
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>视频平台</label>
                    <div class="layui-input-block">
                        @if($video->count())
                            @foreach($video as $column)
                                <input type="radio" name="video[]" lay-filter="" class="" title="{{$column->name}}" lay-skin="primary" value="{{$column->id}}" {{in_array($column->id,$product->video->pluck('id')->all())?'checked':''}}>
                            @endforeach
                        @endif
                    </div>
                </div>
                <div class="layui-form-item video " style="display: @if(isset($type_id) && $type_id == 4) block @else none  @endif;">
                    {{--<label for="" class="layui-form-label">视频行业（视频）</label>--}}
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>视频行业</label>
                    <div class="layui-input-block">
                        @if($trade->count())
                            @foreach($trade as $column)
                                <input type="checkbox" name="trade[]" lay-filter="" class="" title="{{$column->name}}" lay-skin="primary" value="{{$column->id}}" {{in_array($column->id,$product->trade->pluck('id')->all())?'checked':''}}>
                            @endforeach
                        @endif
                    </div>
                </div>
                {{--自媒体平台--}}
                <div class="layui-form-item zimeiti" style="display: @if(isset($type_id) && $type_id == 6) block @else none  @endif;">
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong>自媒体平台</label>
                    <div class="layui-input-block">
                        @if($zichannel->count())
                            @foreach($zichannel as $column)
                                <input type="checkbox" name="zimeiti[]" lay-filter="" class="" title="{{$column->name}}" lay-skin="primary" value="{{$column->id}}" {{in_array($column->id,$product->trade->pluck('id')->all())?'checked':''}}>
                            @endforeach
                        @endif
                    </div>
                </div>

                <div class="layui-form-item">
                    <label for="" class="layui-form-label"><strong class="item-required">*</strong><span id="one_price">价格</span></label>
                    <div class="layui-inline">
                        <div class="layui-input-inline" style="width: 100px;">
                            <input type="number" name="quota_min" oninput="if(value.length>6)value=value.slice(0,6)" value="{{$product->quota_min}}"  placeholder="价格" autocomplete="off" class="layui-input" lay-verify="required|quota_min">
                        </div>
                    </div>
                </div>
            <div class="layui-form-item  other_cate" style="display: none;" >
                <label for="" class="layui-form-label"><strong class="item-required">*</strong><span id="two_price">软广价格</span></label>
                <div class="layui-inline">
                    <div class="layui-input-inline" style="width: 100px;">
                        <input type="number" name="quota_max" oninput="if(value.length>6)value=value.slice(0,6)" value="{{$product->quota_max}}" placeholder="价格" autocomplete="off" class="layui-input" >
                    </div>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label"><strong class="item-required">*</strong>资源摘要</label>
                <div class="layui-input-block" style="width: 40%">
                    <input type="text" name="slogan" maxlength="255" value="{{$product->slogan??old('slogan')}}"  class="layui-input" placeholder="请填写产品摘要">
                </div>
            </div>

            <div class="layui-form-item atricle_zimeiti" style="display: none;">
                <label for="" class="layui-form-label"><strong class="item-required">*</strong>出稿时间</label>
                <div class="layui-input-inline">
                    <input type="number" name="fast_lend_value"  oninput="if(value.length>3)value=value.slice(0,3)" value="{{$product->fast_lend_value??old('fast_lend_value')}}"  class="layui-input" placeholder="请填写最快出稿时间">
                </div>
                <div class="layui-input-inline atricle_zimeiti" style="display: none;">
                    <select name="fast_lend_unit" id="" >
                        <option value="">请选择出稿时间单位</option>
                        <option value="hour" {{$product->fast_lend_unit=='hour'?'selected':''}}>小时</option>
                        <option value="day" {{$product->fast_lend_unit=='day'?'selected':''}}>天</option>
                    </select>
                </div>
            </div>

            <div class="layui-form-item atricle_zimeiti" style="display: none;">
                <label for="" class="layui-form-label"><strong class="item-required">*</strong>平均时间</label>
                <div class="layui-input-inline">
                    <input type="number" name="success_rate" oninput="if(value.length>3)value=value.slice(0,3)" value="{{$product->success_rate??old('success_rate')}}"  class="layui-input" placeholder="请填写成功率">
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label"><strong class="item-required">*</strong>官方地址</label>
                <div class="layui-input-block" style="width: 40%">
                    <input type="text" name="redirect_url" maxlength="100" value="{{$product->redirect_url??old('redirect_url')}}" lay-verify="required|url" class="layui-input" placeholder="">
                </div>
            </div>

            <div class="layui-form-item" style="display: none;">
                <label for="" class="layui-form-label"><strong class="item-required">*</strong>上线平台</label>
                <div class="layui-input-block" id="platform">
                    <input type="checkbox" name="platform[]" title="android" lay-skin="primary" value="android" checked>
                    <input type="checkbox" name="platform[]" title="ios" lay-skin="primary" value="ios" checked >
                    <input type="checkbox" name="platform[]" title="wap" lay-skin="primary" value="wap" checked >
                    <input type="checkbox" name="platform[]" title="pc" lay-skin="primary" value="pc" checked >
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label"><strong class="item-required">*</strong>产品说明</label>
                <div class="layui-input-block">
                    <textarea name="apply_condition" maxlength="999" style="width: 43%" rows="10" onkeyup="words_deal();" required lay-verify="required" placeholder="请输入申请条件" class="layui-textarea">{{$product->apply_condition}}</textarea>
                    <p class="text-count"><span id="textCount">{{mb_strlen($product->apply_condition)?mb_strlen($product->apply_condition):0}}</span>/999（最多999个字）</p>
                </div>
            </div>

        <div class="layui-form-item">
            <label for="" class="layui-form-label"><strong class="item-required">*</strong>资质证明</label>
            <div class="layui-input-block">
                @if($materials->count())
                    @foreach($materials as $material)
                        <input type="radio" name="material[]" title="{{$material->name}}" lay-skin="primary" value="{{$material->id}}" {{in_array($material->id,$product->material->pluck('id')->all())?'checked':''}}>
                    @endforeach
                @endif
            </div>
        </div>
        <div class="layui-form-item article_attribute" style="display: none">
            <label for="" class="layui-form-label"><strong class="item-required">*</strong>接稿日期</label>
            <div class="layui-input-block">
                <input type="radio" name="accept_type" title="周一至周五" lay-skin="primary" value="1" >
                <input type="radio" name="accept_type" title="周一至周天" lay-skin="primary" value="2" >
            </div>
        </div>
        <div class="layui-form-item article_attribute" style="display: none">
            <label for="" class="layui-form-label"><strong class="item-required">*</strong>链接类型</label>
            <div class="layui-input-block">
                <input type="radio" name="link_type" title="带链接" lay-skin="primary" value="1" >
                <input type="radio" name="link_type" title="不带链接" lay-skin="primary" value="2" >
            </div>
        </div>
        <div class="layui-form-item article_attribute" style="display: none">
            <label for="" class="layui-form-label">图片数量</label>
            <div class="layui-input-block" style="width: 40%">
                <input type="text" name="image_count" value=""  class="layui-input" placeholder="">
            </div>
        </div>
        <div class="layui-form-item article_attribute" style="display: none">
            <label for="" class="layui-form-label"><strong class="item-required">*</strong>入口形式</label>
            <div class="layui-input-inline">
                <select name="from_type" id="">
                    @foreach($type_name as $item)
                         <option value="{{$item->id}}">{{$item->name}}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="layui-form-item">
            <label for="" class="layui-form-label">产品限制地区</label>
            <div class="layui-input-block">
                <input type="text" name="district_limit" readonly value="{{$product->district_limit?$product->district_limit:''}}"  class="layui-input area-duoxuan" data-value="{{$product->district_code}}" placeholder="">
                <input type="hidden" name="district_code" value="{{$product->district_code}}">
            </div>
        </div>

        <div class="layui-form-item" style="display: none">
            <label for="" class="layui-form-label"><strong class="item-required">*</strong>自动申请下架数</label>
            <div class="layui-input-block" style="width: 25%">
                <input type="number" name="auto_down_sale_num" oninput="if(value.length>5)value=value.slice(0,5)" value="{{$product->auto_down_sale_num??old('auto_down_sale_num',0)}}" lay-verify="required|number|auto_down_sale_num" class="layui-input" placeholder="请填写自动申请下架数,范围0~99999,0为不设置自动下架">
            </div>
        </div>

        <div class="layui-form-item">
            <label for="" class="layui-form-label"><strong class="item-required">*</strong>上下架状态</label>
            <div class="layui-input-inline">
                {{--        <input type="checkbox" name="status"   lay-skin="switch" lay-text="上架|下架"  value="1"  {{ $product->status == '1' ? 'checked' : '' }}>--}}
                <input type="checkbox" name="status"   lay-skin="switch" lay-text="上架|下架"  value="1"  {{ $product->status == '1' ? 'checked' : $product->status===null?'checked':'' }}>
            </div>
        </div>
        <div class="layui-form-item">
            <label for="" class="layui-form-label"><strong class="item-required">*</strong>排序值</label>
            <div class="layui-input-inline">
                <input type="number" name="sort" oninput="if(value.length>4)value=value.slice(0,4)" value="{{$product->sort??old('sort',0)}}" lay-verify="required|number|sort" class="layui-input" placeholder="请填写排序值">
            </div>
        </div>

        <div class="layui-form-item">
            <label for="" class="layui-form-label"><strong class="item-required">*</strong>系统推荐</label>
            <div class="layui-input-block">
                <input type="checkbox" name="guess_like[]" title="资源详情页-猜你喜欢" lay-skin="primary" value="product" checked >
                <input type="checkbox" name="guess_like[]" title="发现详情-猜你喜欢" lay-skin="primary" value="article" checked >
            </div>
        </div>
        <div class="layui-form-item">
            <div class="layui-input-block">
                <button type="submit" class="layui-btn" lay-submit="" lay-filter="save">保存</button>
                <a href="{{route('admin.product')}}" class="layui-btn"  >返 回</a>
            </div>
        </div>
        </form>
        </div>

@endsection

@section('script')
    @include('admin.product._js')
@endsection