@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto layui-form">

            <form class="layui-form-item" id="search-form">
                <input type="hidden" name="from" value="media">
                <div class="layui-inline">
                    <label class="layui-form-label">产品名称</label>
                    <div class="layui-input-block">
                        <input type="text" name="name" placeholder="请输入产品名称" autocomplete="off" class="layui-input">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">产品类型</label>
                    <div class="layui-input-block">
                        <select name="type" id="">
                            <option value="">不限</option>、
                            @foreach($types as $item)
                                <option value="{{$item->id}}">{{$item->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">上线平台</label>
                    <div class="layui-input-block">
                        <select name="platform" id="">
                            <option value="">不限</option>
                            <option value="android">android</option>
                            <option value="ios">ios</option>
                            <option value="wap">wap</option>
                            <option value="pc">pc</option>
                        </select>
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">状态</label>
                    <div class="layui-input-block">
                        <select name="status" id="">
                            <option value="">不限</option>
                            <option value="1">上架</option>
                            <option value="0">下架</option>
                        </select>
                    </div>
                </div>

                <div class="layui-inline">
                    <button class="layui-btn layuiadmin-btn-useradmin" lay-submit="" lay-filter="product-search">
                        <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
                    </button>
                </div>
            </form>

        </div>
        <div class="layui-card-body">

            <div class="layui-btn-group layui-inline" style="padding-bottom: 10px">
                {{--@can('product.create')
                    <a class="layui-btn layui-btn-sm" href="{{ route('admin.product.create') }}">添 加</a>
                @endcan
                @can('product.destroy')
                    <a class="layui-btn layui-btn-danger layui-btn-sm" id="listDelete">删 除</a>
                @endcan
                @can('product.excel')
                    <a class="layui-btn layui-btn-normal layui-btn-sm" id="excel">导 出</a>
                @endcan--}}
            </div>

            <table id="dataTable" lay-filter="dataTable"></table>

            <script id="platformTpl" type="text/html">
                @{{#  layui.each(d.platform, function(index, item){ }}
                 <span>@{{ item.platform }}</span>&nbsp;&nbsp;&nbsp;
                @{{#  }); }}
            </script>

            <script id="statusTpl" type="text/html">
                <input type="checkbox" name="status" lay-filter="status"  lay-skin="switch" lay-text="上架|下架"  value="@{{ d.id }}" @{{#  if(d.status === 1){ }} checked @{{#  } }}  >
            </script>

            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    @can('product.edit')
                        <a class="layui-btn layui-btn-sm" lay-event="edit">审核</a>
                    @endcan
                    @can('product.destroy')
                        <a class="layui-btn layui-btn-danger layui-btn-sm" lay-event="del">删除</a>
                    @endcan

                </div>
            </script>
        </div>
    </div>
@endsection

@section('script')
    <script>
        layui.use(['layer','table','form'],function () {
            var layer = layui.layer;
            var form = layui.form;
            var table = layui.table;
            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                ,url: "{{ route('admin.product.data') }}?from=media" //数据接口
                ,page: true //开启分页
                ,autoSort: false
                ,limits: [50,100,200]
                ,limit: 50 //每页默认显示的数量
                ,cols: [[ //表头
                    {checkbox: true,fixed: true}
                    ,{field: 'id', title: 'ID'}
                    ,{field: 'name', title: '资源名称'}
                    ,{field: 'type', title: '资源类型',templet: function(d){
                        if(d.type){
                            return d.type[0]['name']
                        }else{
                            return ''
                        }
                    }}
                    ,{field: 'member', title: '姓名',templet: function(d){
                        if(typeof(d.member)==='object'){
                            return d.member.nick
                        }else{
                            return '1'
                        }
                    }}
                    ,{field: 'member', title: '电话',templet: function(d){
                        if(d.member){
                            return d.member.phone
                        }else{
                            return '0'
                        }
                    }}
                    ,{field: 'quota_min', title: '价格',sort:true}
                    ,{field: 'apply', title: '申请数',templet: function(d){
                        if(d.apply){
                            return d.apply.length
                        }else{
                            return 0
                        }
                    }}
                    ,{title: 'platform',templet:'#platformTpl'}
                    ,{field: 'status', title: '上架状态',templet:'#statusTpl',sort:true}
                    ,{title:'操作',width: 150, toolbar: '#options'}
                ]]
            });


            //监听搜索
            form.on('submit(product-search)', function(data){
                var field = data.field;

                //执行重载
                table.reload('dataTable', {
                    where: field
                    ,page:{
                        curr:1
                    }
                });
                return false;
            });

            localStorage.setItem('field','sort');
            localStorage.setItem('order','desc');

            //监听排序事件
            table.on('sort(dataTable)', function(obj){
                table.reload('dataTable', {
                    initSort: obj
                    ,where: {
                        field: obj.field //排序字段
                        ,order: obj.type //排序方式
                    }
                });
                localStorage.setItem('field',obj.field);
                localStorage.setItem('order',obj.type);
            });


            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'del'){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{ route('admin.product.destroy') }}",{_method:'delete',ids:[data.id]},function (result) {
                            if (result.code===0){
                                delReload(dataTable)
                                layer.msg(result.msg,{icon:1})
                            }else {
                                layer.msg(result.msg,{icon:2})
                            }
                            layer.close(index);
                        });
                    });
                }else if(layEvent==='edit'){
                    location.href = '/admin/product/'+data.id+'/edit';
                }else {

                }
            });

            //按钮批量删除
            $("#listDelete").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                if (ids.length>0){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("{{ route('admin.product.destroy') }}",{_method:'delete',ids:ids},function (result) {
                            if (result.code===0){
                                delReload(dataTable,ids.length);
                                layer.msg(result.msg,{icon:1});
                            }else {
                                layer.msg(result.msg,{icon:2});
                            }
                            layer.close(index);
                        });
                    })
                }else {
                    layer.msg('请选择删除项')
                }
            })

            //上下架
            form.on('switch(status)', function(data){
                var id=data.value;
                var status=data.elem.checked;
                $.post("{{route('admin.product.status')}}",{id:id,status:status},function (res) {
                    console.log(res);
                    if(res.code===0){
                        layer.msg(res.msg,{icon:1});
                    }else {
                        layer.msg(res.msg,{icon:2});
                        dataTable.reload();
                    }
                })
            });

            //excel
            $("#excel").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                var params=$('#search-form').serialize();
                var field=localStorage.getItem('field');
                var order=localStorage.getItem('order');
                window.location.href="{{ route('admin.product.excel') }}"+"?ids="+ids+"&"+params+"&field="+field+"&order="+order;
            })

        })
    </script>
@endsection