@extends('admin.layouts.base')
@section('content')
    <style type="text/css">
        form {
            width: 500px;
            margin: 10px auto;
        }
        .right-from{
            width: 800px;
            margin: 10px auto;
            height: 600px;
        }
        .xtree_contianer {
            width: 493px;
            border: 1px solid #fafafa;
            overflow: auto;
            margin-bottom: 30px;
            background-color: #fff;
            padding: 10px 0 25px 5px;
        }
        .fl{
            float: left;
            margin-top: 50px;
        }
        .wbr-head{
            background: #fafafa;
            height: 50px;
            line-height: 50px;
        }
        .span{
            margin-left: 20px;
            font-size: 16px;
        }
        .right-div{
            margin-left: 40px;
            margin-top: 40px;
        }
    </style>
    <div class="layui-card fl" style="margin-left: 30px;">
        <div class="wbr-head" style="width: 500px">
            <span class="span">选择评论产品</span>
        </div>
        <form class="layui-form" style="margin-top: 40px;">
            <div id="xtree1" class="xtree_contianer"></div>
        </form>
    </div>
    <div class="layui-card fl" style="margin-left: 80px">
        <div class="wbr-head">
            <span class="span">批量设置</span>
        </div>
        <div class="right-from">
            <div class="right-div">
                <label for="">加价类型：</label>
                <div class="layui-input-inline" id="set_type">
                    <input type="radio" class="layui-anim layui-icon" name="set_type" value="rate_value" id="rate_value_" checked>
                    <label for="rate_value_" style="margin-right:20px;">按比例调整</label>
                    <input type="radio" class="layui-anim layui-icon" name="set_type" value="price_value" id="price_value_">
                    <label for="price_value_">单价调整</label>
                </div>
            </div>
            <div class="right-div set_type rate_value">
                <label for="">上调比例(%)：</label>
                <div class="layui-input-inline">
                    <input type="number" class="layui-input" onblur="checkNumber(this,1,999999)"  id="rate_value"  placeholder="上调比例" name="rate_value" >
                </div>
            </div>
            <div class="right-div set_type price_value" style="display: none;">
                <label for="">上调单价(元)：</label>
                <div class="layui-input-inline">
                    <input type="number" class="layui-input" onblur="checkNumber(this,1,999999)"  id="price_value"  placeholder="上调单价" name="price_value" >
                </div>
            </div>
            <div class="right-div" >
                <div class="layui-input-inline" >
                    <button class="layui-btn layui-btn-sm" id="insertBtn" >确认添加</button>
                </div>
            </div>
        </div>

    </div>
@endsection
@section('script')
    <script src="{{asset('js/layui-xtree/layui-xtree.js') }}"></script>
    <script type="text/javascript">
        $(function(){
            $("#set_type :radio").on('click', function () {
                        var item= $(this).val();
                       $('.'+item).show().siblings('.set_type').hide();
                 })
        })

        var type = '{{ $type }}';
        var type_model = {
            'article':'软文',
            'zimeiti':'自媒体',
            'weixin':'公众号',
            'weibo':'微博',
            'video':'短视频',
            'redbook':'小红书'
        }
        $.post("{{ route('admin.virtual.comment.product.data') }}",{type:type},function (result) {

            var json = [{
                title: "全部资源", value: "", data:
                        [
                    { title: `${type_model[type]}`, checked: true, value: "", data: [] }
                ]
            } ];
            //资源产品初始化
            if(result.products.length > 0){
                for (var i = 0; i< result.products.length;i++){
                    var pro = result.products
                    json[0].data[0].data.push({ title: pro[i].name, value: 'pro,'+pro[i].id,data: [] })
                }
            }
            //资源产品初始化
            if(result.credits.length > 0){
                for (var i = 0; i< result.credits.length;i++){
                    var cre = result.credits
                    json[0].data[1].data.push({ title: cre[i].name, value: 'cre,'+cre[i].id, data: [] })
                }
            }
            //执行tree
            layui.use(['form','laydate'], function () {
                var form = layui.form;
                var laydate = layui.laydate;
                //3、最完整的参数用法
                //1、最基础的用法 - 直接绑定json
                var xtree1 = new layuiXtree({
                    elem: 'xtree1'   //(必填) 放置xtree的容器，样式参照 .xtree_contianer
                    , form: form     //(必填) layui 的 from
                    , data: json     //(必填) json数据
                });
            });
        });
        //虚拟评论提交
        $("#insertBtn").on('click',function () {
            var arr = [];
            //获取选中的产品
            $("input:checkbox[type='checkbox']:checked").each(function(i,e){
                var str =$(e).val();
                if(str.length > 3){
                    arr.push($(e).val());
                }
            });
            //TODO::
            if(arr.length == 0){
                layer.msg('请选择需要调整的资源', {icon: 2, time: 2000});
                return false;
            }else{
                let set_type =  $('input[name="set_type"]:checked').val(),
                rate_value = $("#rate_value").val(),// 输入的上调比例的值
                price_value = $("#price_value").val(); //输入的上调单价(元)的值
                if(set_type == 'rate_value' && rate_value=='')//rate_value,price_value
                {
                    layer.msg('上调比例不能为空', {icon: 2, time: 2000});
                }else if(set_type == 'price_value' && price_value==''){
                    layer.msg('上调单价不能为空', {icon: 2, time: 2000});
                }else {
                    var index = layer.load(1, {
                        shade: [0.1, '#fff'] //0.1透明度的白色背景
                    });
                    $('#insertBtn').attr('disabled', "true");
                    $.post("{{ route('admin.product.price') }}", {
                                data: arr,
                                set_type: set_type,
                                rate_value: rate_value,
                                price_value: price_value,
                                type: type
                            }
                            , function (result) {
//                                layer.close(index);
                                $('#insertBtn').removeAttr("disabled");
                                if (result.code == 200) {
                                    layer.msg(result.info, {icon: 1, time: 2000});
                                    setTimeout(function () {
                                        location.href = "/admin/product/batch";
                                    }, 2000);
                                } else {
                                    layer.msg(result.info, {icon: 2, time: 2000});
                                }
                            });
                }
            }
        });
        function checkNumber(obj,min,max){
            var v = $(obj).val();
            if(v < min){
                layer.msg('最小不能低于：'+min, {icon: 2, time: 2000});
                $(obj).val(min)
            }
            if(v > max){
                layer.msg('最大不能超过：'+max, {icon: 2, time: 2000});
                $(obj).val(max)
            }
        }
        function dataToUninx(string) {
            var f = string.split(' ', 2);
            var d = (f[0] ? f[0] : '').split('-', 3);
            var t = (f[1] ? f[1] : '').split(':', 3);
            return (new Date(
                            parseInt(d[0], 10) || null,
                            (parseInt(d[1], 10) || 1) - 1,
                            parseInt(d[2], 10) || null,
                            parseInt(t[0], 10) || null,
                            parseInt(t[1], 10) || null,
                            parseInt(t[2], 10) || null
                    )).getTime() / 1000;
        }


        function getNowFormatDate() {
            var date = new Date();
            var seperator1 = "-";
            var seperator2 = ":";
            var month = date.getMonth() + 1;
            var strDate = date.getDate();
            if (month >= 1 && month <= 9) {
                month = "0" + month;
            }
            if (strDate >= 0 && strDate <= 9) {
                strDate = "0" + strDate;
            }
            var currentdate = date.getFullYear() + seperator1 + month + seperator1 + strDate
                    + " " + date.getHours() + seperator2 + date.getMinutes()
                    + seperator2 + date.getSeconds();
            return currentdate;
        }
    </script>
@endsection


