@extends('admin.layouts.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-header">代理等级配置</div>
        <div class="layui-card-body" style="padding: 15px;">
            <form class="layui-form" method="post" action="{{ route('admin.work.single.store') }}">
                {{ csrf_field() }}
                <div style="border:1px solid green; margin-top: 20px;padding: 20px 0px 20px 0px;">
                    <div class="layui-form-item">
                        <label class="layui-form-label"><strong class="item-required">*</strong>工单类型:</label>
                        <div class="layui-input-block">
                            <input type="radio" name="type"   value="bug" title="系统BUG"  checked >
                            <div class="layui-unselect layui-form-radio layui-form-radioed"><i class="layui-anim layui-icon"></i>
                                <div>系统BUG</div>
                            </div>
                            {{--<input type="radio" name="status"   value="2" title="禁用" >
                            <div class="layui-unselect layui-form-radio layui-form-radioed"><i class="layui-anim layui-icon"></i>
                                <div>禁用</div>
                            </div>--}}
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label"><strong class="item-required">*</strong>工单标题:</label>
                        <div class="layui-input-block">
                            <input type="text" name="title" lay-verify="required" autocomplete="on" placeholder="请输入标题" class="layui-input" value="" maxlength="50" >
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label"><strong class="item-required">*</strong>工单内容:</label>
                        <div class="layui-input-block">
                            <textarea name="content"  lay-verify="required" placeholder="请输入内容" id="container" class="layui-textarea"></textarea>
                        </div>
                    </div>
                    <div class="layui-form-item layui-layout-admin">
                        <div class="layui-input-block">
                            <div class="layui-footer" style="left: 0;">
                                <button type="submit" class="layui-btn" lay-submit="" lay-filter="*">确 认</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@section('script')
    @include('vendor.ueditor.assets')
    <script type="text/javascript">
        var ue = UE.getEditor('container',{ toolbars: [
            ['source','undo', 'redo', 'bold', 'indent','bold', 'italic', 'underline','strikethrough', 'simpleupload','subscript','fontborder','superscript', 'cleardoc','pasteplain','selectall','removeformat', 'time', 'date', 'edittable', 'edittd','link', 'spechars','searchreplace','help', 'justifyleft','justifyright', 'justifycenter','justifyjustify','forecolor','backcolor','fullscreen','rowspacingtop','rowspacingbottom', 'imagecenter', 'lineheight','edittip','touppercase','tolowercase','preview']
        ],
            initialFrameWidth : 800,
            initialFrameHeight: 400,
            autoHeightEnabled: false
        });

        ue.ready(function() {
            ue.execCommand('serverparam', '_token', '{{ csrf_token() }}'); // 设置 CSRF token.
        });
    </script>
    <!-- 编辑器容器 -->
    <script id="container" name="content" type="text/plain"></script>
    <script>
        layui.use(['form','upload'], function () {
            var form = layui.form;
            //监听提交
            form.on('submit(formDemo)', function(data){
                $("input[name=url_type]").val('source')
                return true;
            });
            //监听提交
            form.on('submit(formDemo1)', function(data){
                return true;
            });
            //各种基于事件的操作，下面会有进一步介绍
            var upload = layui.upload;
            upload.render({
                elem: '#test8', // 文件选择
                accept: 'file',
                multiple: false,
                url: '/upload/file',
                auto: true, // 设置不自动提交
                exts: 'docx', //只允许上传word
                size:'102400',
                done: function (res) {
                    if(res.code == 0) {
                        $('#fileupload').val(res.data.path)
                        $('#uploadName').html(res.data.originName)
                        $('#uploadName1').val(res.data.originName)
                        layer.msg('上传成功', {icon: 1});
                        //*获取文本内容*//
                    }else{
                        layer.msg('上传失败', {icon: 2});
                    }
                },
                error: function (res) {
                    layer.msg('上传失败', {icon: 2});
                }
            });
        });
    </script>
@endsection