@extends('layouts.advert.member')
@section('title','充值记录')
@section('content')
    <div>
        <div class="fz18 bb-e0e0e0 pb10">充值记录</div>
        <table id="dataTable" class="mt20" lay-filter="dataTable"></table>
    </div>
@endsection
@section('script')
    <script type="text/html" id="options">
        <div class="layui-btn-group">
            @{{# if(d.status == 0){}}
            <span class="layui-btn layui-btn-sm">过期</span>
           {{-- <a class="layui-btn layui-btn-sm" lay-event="edit">发起支付</a>--}}
            @{{# } }}
        </div>
    </script>
    <script>
        layui.use(['form','table'], function () {
            var form = layui.form;
            var table = layui.table;
            //各种基于事件的操作，下面会有进一步介绍\
            var dataTable = table.render({
                elem: '#dataTable'
                ,autoSort: false //禁用前端自动排序。注意：该参数为 layui 2.4.4 新增
                ,url: "{{ url('advert/member/charge/data') }}" //数据接口
                ,page: true //开启分页
                ,limits: [50,100,200]
                ,limit: 20 //每页默认显示的数量
                ,cols: [[ //表头
                    {field: 'id', title: '编号',width:80}
                    ,{field: 'charge_no', title: '订单号',templet: function(d){
                        return d.charge_no
                    }}
                    ,{field: 'money', title: '充值金额',templet: function(d){
                        return d.money
                    }}
                    ,{field: 'pay_type', title: '充值类型',templet: function(d){
                        if(d.pay_type == 'alipay') {
                            return '支付宝';
                        }else if(d.pay_type == 'wechat'){
                            return '微信';
                        }
                    }
                    }
                    ,{field: 'status', title: '充值状态',templet: function(d){
                        if(d.status ==1 ){
                            return '已支付'
                        }else{
                            return '未支付'
                        }
                    }}
                    ,{field: 'pay_at', title: '支付时间'}
                   // ,{title:'操作',width: 150, toolbar: '#options'}
                ]]
            });
            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    ,layEvent = obj.event; //获得 lay-event 对应的值
                if(layEvent === 'del'){
                }else if(layEvent==='edit'){
                    location.href = '/Web/aliPay/'+data.id;
                }
            });

        });
    </script>
@endsection