@extends('layouts.advert.member')
@section('title','充值')
@section('content')
    <style>
        a {
            color: #333;
            text-decoration: none;
        }
        
        .list_Box li{
            padding: 15px 0 15px 15px;
            border-left: 2px solid #fff;
            cursor: pointer;
        }
        .list_Box li.active {
            border-left-color: #009688;
            color: #009688;
            background: #f0f0f0;
        }
        .headr{
            font-size:16px;
        }
        .blue {
            color: blue;
        }
        .mr30{
            margin-right:30px;
        }
        .mb20{
            margin-bottom:20px;
        }
        .pb20{
            padding-bottom:20px;
        }
        .sv-title {
            padding:20px 0;
            font-size:16px;
            font-weight: 600;
        }
        .sv-buy-card .item{
            width: 150px;
            height: 120px;
            border: 1px solid rgb(221, 221, 221);
            border-radius: 8px;
            background: #fff;
            position: relative;
            padding-top: 40px;
            box-sizing: border-box;
            text-align: center;
            font-size: 26px;
            cursor:pointer;
            position: relative;
        }

        .sv-buy-card .item.slf{
            width: 150px;
            height: 120px;
            border: 1px solid rgb(221, 221, 221);
            border-radius: 8px;
            background: #fff;
            position: relative;
            padding-top: 40px;
            box-sizing: border-box;
            text-align: center;
            font-size: 20px;
            cursor:pointer;
            position: relative;
        }
        .sv-buy-card .item.slf .p{
            position: absolute;
            top:0;left:0;right:0;bottom:0;
            padding-top: 40px;
        }
        .sv-buy-card .item.slf .input{
            display:none;
            border:none;
            background:none;
            width:80%;
            margin:0 auto;
            padding:10px 0;
            border-bottom:1px solid #ccc;
            text-align:center;
            color: #ff6200;
        }
        .sv-buy-card .item.active{
            border: 2px solid #ff6200;
            background: #fff url('/images/service-tips01.png') no-repeat right bottom;
        }
        .sv-btn {
            display: inline-block;
            height: 38px;
            line-height: 38px;
            padding: 0 18px;
            background-color: #fff;
            border:1px solid #2f75ec;
            color: #2f75ec;
            white-space: nowrap;
            text-align: center;
            font-size: 14px;
            border-radius: 2px;
            cursor: pointer;
        }
        .account .item{
            display: inline-block;
            width: 260px;
            height: 120px;
            padding: 18px;
            color: #fff;
            margin-right: 30px;
            /* background: url(/images/media/bg-billList.png) left top no-repeat; */
            /* background-color:green; */
            border-radius:6px;
        }
        .bg-2f75ec{
            background-color: rgba(47,142,236,0.6);
        }
        .bg-ff6200{
            background-color: rgba(255,174,0,0.6);
        }
    </style>
    <div>
        <div class="fz18 bb-e0e0e0 pb10">充值/余额</div>
        <!-- <div class="headr">
            <p class="sv-title">账户余额（元）：</p>
            <p style="margin-left: 20px">
                账号：<span class="blue mr30">{{ $account['phone'] }}</span>
                账户可用余额：<span class="blue mr30">{{ $account['total_money']??$account['total_money'].'元' }}  </span>
                账户冻结金额：<span class="blue" style="color:red;">{{ $account['freeze_money']??$account['freeze_money'].'元' }}  </span>
            </p>
        </div> -->
        <div class="account mt20">
            <div class="fz16 pb20">账户:<span class="ml10 blue">{{ $account['phone'] }}</span></div>
            <div>
                <div class="item bg-2f75ec">
                    <p class="fz20"> 账户可用余额 </p>
                    <p class="fz36 lh1 mt10">{{ $account['total_money']??$account['total_money'].'元' }}</p>
                </div>
                <div class="item bg-ff6200">
                    <p class="fz20"> 账户冻结金额 </p>
                    <p class="fz36 lh1 mt10">{{ $account['freeze_money']??$account['freeze_money'].'元' }} </p>
                </div>
            </div>
        </div>
        <p class="fz16 pb10 mt20">充值金额（元）：</p>
        <ul class="sv-buy-card clear mt20" id="buy-card">
            <li class="item fl mr30 mb20 active" data="50">50</li>
            <li class="item fl mr30 mb20" data="100">100</li>
            <li class="item fl mr30 mb20" data="150">150</li>
            <li class="item fl mr30 mb20" data="200">200</li>
            <li class="item fl mr30 mb20  slf" data="custom">
                <p class="p">自定义充值</p>
                <input class="input" type="text" placeholder="输入自定义金额" onkeyup="if(this.value.length==1){this.value=this.value.replace(/[^1-9]/g,'')}else{this.value=this.value.replace(/\D/g,'')}"  
                            onafterpaste="if(this.value.length==1){this.value=this.value.replace(/[^1-9]/g,'0')}else{this.value=this.value.replace(/\D/g,'')}">
            </li>
        </ul>
        <div class="">
            <button class="sv-btn" onclick="subm('alipay')"><img src="/images/icon-accs.png"> 支付宝</button>
            <button class="sv-btn" onclick="subm('wechat')"><img src="/images/icon_weixin.png" style="width: 26px;margin-right: 5px;"> 微信</button>
        </div>
        <canvas id="qr"></canvas>
    </div>
@endsection
@section('script')
    <script>
        layui.use(['form','table'], function () {
            var form = layui.form;
        });
    </script>
    <script>
        var charge_number = '';
        $('#buy-card .item').each(function(){
            $(this).click(function(){
                $('#buy-card .item').removeClass('active');
                $(this).addClass('active');
                if($(this).attr('data')==='custom'){
                    $(this).find('.p').hide().next().show()
                } else {
                    $('#buy-card .slf').find('.p').show().next().hide()
                }
            })
        })
        function subm(pay_type){
            let val = 0,
                thisDom = $('#buy-card .item.active');
            if(thisDom.attr('data')==='custom'){
                val = thisDom.find('.input').val()
            }else{
                val = thisDom.attr('data')
            }
            if(!val)
            {
                layer.msg('请填写充值金额');
                return false;
            }else{
                charge(val,pay_type);
            }
        }
        function  charge(val,pay_type) {
            $.ajax({
                url: '/advert/member/charge/pay',
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': "{{csrf_token()}}"
                },
                data: {'money':val,'pay_type':pay_type},
                success: function (res) {
                    if(res.code==200){
                        if(pay_type == 'alipay')
                        {
                            alipay(res.data)
                        }else{
                            wechat(res.data);
                        }
                    }else {
                        $msg(res.info,2);
                    }
                },
                error: function () {}
            })
        }
        function alipay(charge_no) {
            window.location.href='/advert/alipay/'+charge_no;
        }
        function wechat(charge_no) {
            window.location.href='/advert/wechat?charge_no='+charge_no;

        }
    </script>

@endsection

