@extends('layouts.advert.member')
@section('title','新增素材')
@section('content')
    <style>
        .layui-form-label{
            width:100px;
        }
    </style>
    <div>
        <div class="fz18 bb-e0e0e0 pb10">创建素材</div>
        <form class="layui-form mt20" action="/advert/member/file/store" method="post">
            <div class="layui-form-item">
                <label class="layui-form-label"><i class="span-dot">*</i>素材名称</label>
                <div class="layui-input-block">
                    <input type="text" name="title" required lay-verify="required" placeholder="请输入标题" autocomplete="off" class="layui-input">
                </div>
            </div>
            <input type="hidden" name="_token" value="{{ csrf_token() }}">
            <div class="layui-form-item">
                <label class="layui-form-label">类型</label>
                <div class="layui-input-block">
                    <input type="radio" name="type" value="1" title="附件上传" checked="checked" lay-filter="click_type" >
                    <div class="layui-unselect layui-form-radio">
                        <i class="layui-anim layui-icon"></i>
                        <div>附件上传</div>
                    </div>
                    <input type="radio" name="type" value="2" title="在线编辑"  lay-filter="click_type">
                    <div class="layui-unselect layui-form-radio layui-form-radioed">
                        <i class="layui-anim layui-icon"></i>
                        <div>在线编辑</div>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <label class="layui-form-label">资源类型</label>
                <div class="layui-input-block">
                    @foreach($category as $item)
                            <input type="radio" name="type_id" value="{{$item->id}}" title="{{$item->name}}" @if($item->id == 1) checked @endif>
                            <div class="layui-unselect layui-form-radio">
                                <i class="layui-anim layui-icon"></i>
                                <div>{{$item->name}}</div>
                            </div>
                    @endforeach
                </div>
            </div>
            <div class="layui-form-item type_file" >
                <label class="layui-form-label">附件</label>
                <div class="layui-input-block">
                    <button type="button" class="layui-btn" id="test8" >
                        <i class="layui-icon">&#xe67c;</i>上传附件(仅支持:docx)
                    </button>
                    <span class="" id="uploadName"></span>
                </div>
                <input type="hidden" name="fileupload" id="fileupload" lay-verify=""  value="">
                <input type="hidden" name="uploadName" id="uploadName1" lay-verify=""  value="">
            </div>
            <div class="layui-form-item layui-form-text type_online">
                <label class="layui-form-label">在线编辑</label>
                <div class="layui-input-block">
                    <textarea name="content" placeholder="请输入内容" id="container" class="layui-textarea"></textarea>
                </div>
            </div>
            <div class="layui-form-item layui-form-text">{{--type_file--}}
                <label class="layui-form-label">备注</label>
                <div class="layui-input-block">
                    <textarea name="mark" placeholder="请输入内容" class="layui-textarea"></textarea>
                </div>
            </div>
            <input type="hidden" name="url_type" value="source">
            <div class="layui-form-item pt20">
                <div class="layui-input-block">
                    <button class="layui-btn" lay-submit lay-filter="formDemo">保存</button>
                    <button class="layui-btn layui-btn-warm" lay-submit="" lay-filter="formDemo1">保存并发稿</button>
                    <button type="reset" class="layui-btn">重置</button>
                </div>
            </div>
        </form>
    </div>
@endsection
@section('script')
    @include('vendor.ueditor.assets')
    <script type="text/javascript">
        var ue = UE.getEditor('container',{ toolbars: [
                    ['source','undo', 'redo', 'bold', 'indent','bold', 'italic', 'underline','strikethrough', 'simpleupload','subscript','fontborder','superscript', 'cleardoc','pasteplain','selectall','removeformat', 'time', 'date', 'edittable', 'edittd','link', 'spechars','searchreplace','help', 'justifyleft','justifyright', 'justifycenter','justifyjustify','forecolor','backcolor','fullscreen','rowspacingtop','rowspacingbottom', 'imagecenter', 'lineheight','edittip','touppercase','tolowercase','preview','autotypeset']
                ],
            initialFrameWidth : 800,
            initialFrameHeight: 400,
            autoHeightEnabled: false
        });

        ue.ready(function() {
            ue.execCommand('serverparam', '_token', '{{ csrf_token() }}'); // 设置 CSRF token.
        });
    </script>
    <!-- 编辑器容器 -->
    <script id="container" name="content" type="text/plain"></script>
    <script>
        layui.use(['form','upload'], function () {
            var form = layui.form;
            //监听提交
            form.on('submit(formDemo)', function(data){
                $("input[name=url_type]").val('source')
                var type = data.field.type;
                /* if(type == 1 && data.field.file == '')
                 {
                 layer.msg('请上传附件');
                 return false;
                 }else*/
                if(type == 2 && data.field.content == '')
                {
                    layer.msg('请编辑内容');
                    return false;
                }
                return true;
            });
            //监听提交
            form.on('submit(formDemo1)', function(data){
                $("input[name=url_type]").val('index')
                return true;
            });
            //各种基于事件的操作，下面会有进一步介绍
            var upload = layui.upload;
            upload.render({
                elem: '#test8', // 文件选择
                accept: 'file',
                multiple: false,
                url: '/upload/file',
                auto: true, // 设置不自动提交
                exts: 'docx', //只允许上传word
                size:'102400',
                done: function (res) {
                    if(res.code == 0) {
                        $('#fileupload').val(res.data.path)
                        $('#uploadName').html(res.data.originName)
                        $('#uploadName1').val(res.data.originName)
                        layer.msg('上传成功', {icon: 1});
                        //*获取文本内容*//
                        getContent(res.data.path)


                    }else{
                        layer.msg('上传失败', {icon: 2});
                    }
                },
                error: function (res) {
                    layer.msg('上传失败', {icon: 2});
                }
            });
            form.on('radio(click_type)', function (data) {
                var click_type =data.value;
                if(click_type == 1)
                {
                    $('.type_online').hide()
                    $('.type_file').show()
                }else{
                    $('.type_file').hide()
                    $('.type_online').show()
                }
            });
        });
        function getContent(p){
            var params = {};
            params.theData = {path:p};
            params.theUrl = allAPI.advert.content
            doPostAjax(params, function (data) {
                if(data.code == 200){
//                    $('#container').html(data.data.content)//默认显示内容必须在实例化编辑器之后才能显示
                    var ue = UE.getEditor('container',{  toolbars: [
                        ['source','undo', 'redo', 'bold', 'indent','bold', 'italic', 'underline','strikethrough', 'simpleupload','subscript','fontborder','superscript', 'cleardoc','pasteplain','selectall','removeformat', 'time', 'date', 'edittable', 'edittd','link', 'spechars','searchreplace','help', 'justifyleft','justifyright', 'justifycenter','justifyjustify','forecolor','backcolor','fullscreen','rowspacingtop','rowspacingbottom', 'imagecenter', 'lineheight','edittip','touppercase','tolowercase','preview','autotypeset']
                    ],
                        initialFrameWidth : 800,
                        initialFrameHeight: 400,
                        autoHeightEnabled: false
                    });

                    ue.ready(function() {
                        ue.execCommand('serverparam', '_token', '{{ csrf_token() }}'); // 设置 CSRF token.
                        ue.setContent(data.data.content)
                    });
                }
            })
        }
    </script>
@endsection