@extends('layouts.advert.member')
@section('title','系统消息')
@section('content')
    <div>
        <div class="fz18 bb-e0e0e0 pb10">系统消息</div>
        <table class="mt20" id="dataTable" lay-filter="dataTable"></table>
    </div>
@endsection
@section('script')
<script type="text/html" id="options">
    <div class="layui-btn-group">
        <a class="layui-btn layui-btn-sm" lay-event="edit">查看</a>
    </div>
</script>
<script>
    layui.use('element', function(){
        var $ = layui.jquery
            ,element = layui.element; //Tab的切换功能，切换事件监听等，需要依赖element模块
    });
    layui.use(['form','table'], function () {
        var form = layui.form;
        var table = layui.table;
        //各种基于事件的操作，下面会有进一步介绍\
        var dataTable = table.render({
            elem: '#dataTable'
            ,autoSort: false //禁用前端自动排序。注意：该参数为 layui 2.4.4 新增
            ,url: "{{url('advert/message/data')}}" //数据接口
            ,page: true //开启分页
            ,limits: [50,100,200]
            ,limit: 20 //每页默认显示的数量
            ,cols: [[ //表头
                {checkbox: true,fixed: false}
                ,
                {field: 'title', title: '发送标题',width:150}
                ,{field: 'content',width: 300, title: '发送内容'}
                ,{field: 'order_no',width: 120, title: '订单号',templet: function(d){
                    if(d.order)
                    {
                        return d.order.order_no
                    }else{
                        return '暂无信息'
                    }
                }}
                // ,{field: 'numbers', title: '接收号码'}
                ,{field: 'pay_time',width: 120, title: '下单时间',templet: function(d){
                    if(d.order)
                    {
                        return d.order.pay_time
                    }else{
                        return '暂无信息'
                    }
                }}
                ,{field: 'created_at', title: '发送时间'}
                // ,{title:'操作',width: 100, toolbar: '#options'}
            ]]
        });
    });
</script>
@endsection