@extends('layouts.advert.member')
@section('title','订单详情')
@section('content')
<!--crumb_nav end-->
    <div>
        <div class="fz18 bb-e0e0e0 pb10">步骤</div>
        <div id="steps"></div>
    </div>
@endsection
@section('script')

<style>
    .list_Box li{
        padding: 15px 0 15px 15px;
        border-left: 2px solid #fff;
        cursor: pointer;
    }
    .list_Box li.active {
        border-left-color: #009688;
        color: #009688;
        background: #f0f0f0;
    }
    #steps {
    }

    .step-item {
        display: inline-block;
        line-height: 26px;
        position: relative;
        background: #ffffff;
    }

    .step-item-tail {
        width: 100%;
        padding: 0 10px;
        position: absolute;
        left: 0;
        top: 13px;
    }

    .step-item-tail i {
        display: inline-block;
        width: 100%;
        height: 1px;
        vertical-align: top;
        background: #c2c2c2;
        position: relative;
    }
    .step-item-tail-done {
        background: #009688 !important;
    }

    .step-item-head {
        position: relative;
        display: inline-block;
        height: 26px;
        width: 26px;
        text-align: center;
        vertical-align: top;
        color: #009688;
        border: 1px solid #009688;
        border-radius: 50%;
        background: #ffffff;
    }

    .step-item-head.step-item-head-active {
        background: #009688;
        color: #ffffff;
    }

    .step-item-main {
        background: #ffffff;
        display: block;
        position: relative;
    }

    .step-item-main-title {
        font-weight: bolder;
        color: #555555;
    }
    .step-item-main-desc {
        color: #aaaaaa;
    }
</style>
<script>
    var data_list= [];
    layui.config({
        base: '/layui/lay/modules/'
    });
    var id = "{{$apply->id}}"
    $.ajax({
        url:  "{{ url('/advert/member/order/plan')}}" ,
        type: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },

        data: {id:id},
        dataType: "json",
        success: function (res) {
            var json = res.data;
            for(var i=0; i<json.length; i++)
            {
                data_list.push({
                    'title':json[i].mark,
                    'desc':json[i].created_at
                })
            }
            layui.use('steps', function () {
                var steps = layui.steps;
                steps.make(data_list, '#steps', 3);
            });
        }
    })
</script>
@endsection