@extends('layouts.advert.layout')
@section('css')
    <link rel="stylesheet" href="/assets/css/resourcelist.css">
@endsection
@section('title','微博资源')
@section('content')
    @include('layouts.advert.cart')
    {{--筛选区域--}}
    <section class="mtb20 wrap minh-ad">
        <div class="wrap-container">
            <div class="clear container zst-filter">
                <div class="filter-header clear">
                    <!-- <label class="yun-batch" for="batchSearchPop" onclick="batchSearch(this)">批量搜索</label> -->
                    <div class="yun-search zst-search">
                        <input class="search con-keydown" id="name" type="text" name="search" data-title="关键词" data-search="name"
                               placeholder="请输入微信资源名称">
                        <span class="icon--search con-click" id="nameSearch" onclick="keywordsSearch()"></span>
                    </div>
                </div>
                <div class="mainWidth batchResultBox resHide">
                    <div class="resultBox clear">
                        <div class="tit">批量查询结果：</div>
                        <div class="successRes"><b class="successNum"></b>个资源查询成功</div>
                        <div class="failRes fails resHide"><b class="failNum"></b>个资源查询失败</div>
                        <label class="viewRes fails resHide" for="batchResultPop">查看失败资源</label>
                    </div>
                </div>
                <div class="_filter_ search1">
                    <div class="filters" data-tit="覆盖区域">
                        <label class="showMore" for="con1">更多</label>
                        <div class="tit">
                            <span>覆盖区域：</span>
                            <label><input type="radio" class="none filter" name="district" value="" checked=""><b>不限</b></label>
                        </div>
                        <input type="checkbox" class="none con" id="con1">
                        <div class="con clear">
                            @foreach($condition['district'] as $item)
                                <label><input type="radio" @if($item->id == $status['district']) checked @endif   class="none filter" name="district" value="{{$item->id}}"><b>{{ $item->name }}</b></label>
                            @endforeach
                        </div>
                    </div>
                    <div class="filters" data-tit="资源分类">
                        <label class="showMore" for="con2">更多</label>
                        <div class="tit">
                            <span>频道分类：</span>
                            <label><input type="radio" class="none filter" name="source" value="" checked=""><b>不限</b></label>
                        </div>
                        <input type="checkbox" class="none con" id="con2">
                        <div class="con clear">
                            @foreach($condition['source'] as $item)
                                <label><input type="radio" @if($item->id == $status['source']) checked @endif  class="none filter" name="source" value="{{$item->id}}"><b>{{ $item->name }}</b></label>
                            @endforeach
                        </div>
                    </div>
                    <div class="filters" data-tit="会员价格">
                       {{-- <div class="rFilter priceFilter clear">
                            <input type="text" class="blur price1" autocomplete="off"><span>-</span>
                            <input type="text" class="blur price2" autocomplete="off">
                            <b class="ok">确定</b>
                        </div>--}}
                        <div class="tit">
                            <span>会员价格：</span>
                            <label><input type="radio" class="none filter" name="price" value="" checked=""><b>不限</b></label>
                        </div>
                        <div class="con clear">
                            @foreach($condition['price'] as $item)
                                <label><input type="radio" @if($item->id == $status['price']) checked @endif  class="none filter" name="price" value="{{$item->id}}"><b>
                                       @if($item->type==1)
                                            {{$item->per_value}}元以下
                                        @elseif($item->type==3)
                                            {{$item->per_value}}元以上
                                        @else
                                            {{$item->min.'-'.$item->max}}元
                                        @endif
                                    </b>
                                </label>
                            @endforeach
                        </div>
                    </div>
                    <div class="filters" data-tit="粉丝数量">
                        {{-- <div class="rFilter priceFilter clear">
                             <input type="text" class="blur price1" autocomplete="off"><span>-</span>
                             <input type="text" class="blur price2" autocomplete="off">
                             <b class="ok">确定</b>
                         </div>--}}
                        <div class="tit">
                            <span>粉丝数量：</span>
                            <label><input type="radio" class="none filter" name="fans" value="" checked=""><b>不限</b></label>
                        </div>
                        <div class="con clear">
                            @foreach($condition['fans'] as $item)
                                <label><input type="radio" @if($item->id == $status['fans']) checked @endif  class="none filter" name="fans" value="{{$item->id}}"><b>
                                        @if($item->type==1)
                                            {{$item->per_value}}万以下
                                        @elseif($item->type==3)
                                            {{$item->per_value}}万以上
                                        @else
                                            {{$item->min.'-'.$item->max}}万
                                        @endif
                                    </b>
                                </label>
                            @endforeach
                        </div>
                    </div>

                    <div class="filters" data-tit="出稿时间">
                        <div class="tit">
                            <span>出稿时间：</span>
                            <label><input type="radio" class="none filter" name="period" value="" checked=""><b>不限</b></label>
                        </div>
                        <div class="con clear">
                            @foreach($condition['period'] as $item)
                                <label><input type="radio" @if($item->id == $status['period']) checked @endif  class="none filter" name="period" value="{{$item->id}}"><b>
                                        @if($item->type==1)
                                            {{$item->per_value}}小时以内
                                        @elseif($item->type==3)
                                            {{$item->per_value}}小时以上
                                        @else
                                            {{$item->min.'-'.$item->max}}小时
                                        @endif
                                    </b></label>
                            @endforeach
                        </div>
                    </div>
                    <div class="filters selected" data-tit="已选择">

                    </div>
                </div>
            </div>
            <div class="list-content mt30 bgff plr20 pb20">
                <table class="table" id="searchTable">
                    <thead>
                    <tr>
                        <th style="width:380px;">资源名称</th>
                        <th class="td-center">硬广价格</th>
                        <th class="td-center">软广价格</th>
                       {{-- <th class="td-center">会员价格<img class="vip-img" src="/images/VIPlogo/V1.png" alt=""></th>--}}
                        <th class="td-center">
                            <span>粉丝数</span>
                        </th>
                        <th class="td-center">
                            <span>阅读数</span>
                        </th>
                        <th class="td-center" style="width:190px;">操作</th>
                    </tr>
                    </thead>
                    <!-- 列表模板 -->
                    <tbody>
                    @if(count($data))
                        @foreach($data as $item)
                            <tr class="item-list">
                                <td style="width:380px;">
                                    <div class="res avatar article" style="width: 80px;">
                                        <img class="list-img"  @if($item->created_from != 'cloud') src="{{ env('IMG_URL').$item->logo }}"
                                             @else src="{{$item->logo }}"  @endif onerror="javascript:this.src= '/images/avatar_icon.png'">
                                    </div>
                                    <div class="info" style="max-width: 280px;">
                                        <div class="res-name" data-resname="{{ mb_substr($item->name,0,30) }}">
                                            <a href="javascript:;" rel="nofollow" target="_blank">{{ mb_substr($item->name,0,30) }}<i class="baidu-i" title=""></i></a>
                                        </div>
                                        <div class="res-desc" title="{{$item->slogan}}">{{ mb_substr($item->slogan,0,30)}}</div>
                                        {{--<div class="finish-hour">平均出稿时间 27.5小时</div>
                                        <div class="finish-rate">出稿率 19.0%</div>--}}
                                    </div>
                                </td>
                                <td class="td-center">
                                    <div class="mb10" data-price="{{$item->quota_min}}">￥{{$item->quota_min}}</div>
                                </td>
                                <td class="td-center">
                                    <div class="mb10" data-price="{{$item->quota_max}}">￥{{$item->quota_max}}</div>
                                </td>
                                {{--<td class="td-center">
                                    <div class="red-price" data-price="{{$item->quota_min}}">￥{{$item->sale}}</div>
                                </td>--}}
                                <td class="td-center">
                                    <div class="order-count">{{$item->fans?$item->fans['fans'].'万':'无'}}</div>
                                </td>
                                <td class="td-center">
                                    <div class="order-count">{{$item->views?$item->views['views'].'万':'无'}}</div>
                                </td>
                                <td class="handle" data-id="" style="width:190px;">
                                    <span  style="text-align:center;" class="detail-i _showDetail_" title="查看详情" data-show="detail" data-type="{{$menu}}" data-resid="{{ $item->id }}">查看详情</span>
                                    <span  style="text-align:center;" class="quote-i _addQuote_" title="加入购物车" data-resid="{{ $item->id }}" data-type="{{$menu}}">加入购物车</span>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
    </section>
    <div class="popMid _popResDetail_" id="detailPop"  data-type="{{ $menu }}">
        <div class="bg">
            <div class="cell">
                <div class="midBox white radius"><label class="close trans"></label>
                    <div class="tit">资源详情</div>
                    <div class="box">
                        <div class="prd">
                            <div class="resBase clear" data-tit="资源基本信息">
                                <div class="fl base clear">
                                    <div class="headImg">
                                        <div class="res avatar article"><img class="list-img" src="" alt=""></div>
                                    </div>
                                    <div class="infos">
                                        <div class="name"><a class="resName" href="" target="_blank"></a><span>(ID
                        : <b class="resId"></b>)</span></div>
                                        <div class="prices">
                                            <div>价格：<b>￥84</b></div>{{--<s>420</s>--}}<span title="用户评论得分">5 分</span>
                                        </div>
                                    </div>
                                </div>
                                {{-- <div class="fr adds"><label class="addCart to" for="res_19275"></label><span class="_addQuote_" data-type="pop" data-resid="19275">加入报价单</span></div>--}}
                            </div>
                            <div class="resOther" id="sc_box">
                                <div class="sc_container">
                                    <div class="dArea" data-tit="资源说明">
                                        <div class="tits">资源说明</div>
                                        <div class="dList">
                                            <ul class="clear">
                                                <li class="clear "><b>粉丝数量：</b><span class="website-fans"></span></li>
                                                <li class="clear "><b>阅读数量：</b><span class="website-read"></span></li>
                                                <li class="clear "><b>认证类型：</b><span class="website-material">-</span></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="dArea quoted-price" data-tit="资源报价">
                                        <div class="tits">资源报价</div>
                                        <div class="mt10 plr10">
                                            <table width="100%" cellpadding="0" cellspacing="0">
                                                <tbody>
                                                    <tr><td style="width:200px;">硬广报价：</td><td><span class="red quota-min"></span></td></tr>
                                                    <tr><td style="width:200px;">软广报价：</td><td><span class="red quota-max"></span></td></tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="dArea tgIntro" data-tit="公众号简介">
                                        <div class="tits">公众号简介</div>
                                        <div class="dList">
                                            <pre class="clear apply-condition">

                                            </pre>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @if(!$member_info)
        @include('layouts.advert.info')
    @endif

    @if($data)
        {{$data->links('common.page')}}
    @endif
@endsection
