

<?php $__env->startSection('content'); ?>
    <div class="layui-card">
        <div class="layui-card-header layuiadmin-card-header-auto layui-form">
          
            <div>
                <div class="layui-btn-group">
                    <button class="layui-btn layui-btn-sm  layui-btn-normal type_tag" data="article">软文资源</button>
                </div>
                <div class="layui-btn-group">
                    <button class="layui-btn layui-btn-sm  layui-btn-normal type_tag" data="zimeiti">自媒体资源</button>
                </div>
                <div class="layui-btn-group">
                    <button class="layui-btn layui-btn-sm  layui-btn-normal type_tag" data="weixin">公众号资源</button>
                </div>
                <div class="layui-btn-group">
                    <button class="layui-btn layui-btn-sm  layui-btn-normal type_tag" data="weibo" >微博资源</button>
                </div>
                <div class="layui-btn-group">
                    <button class="layui-btn layui-btn-sm  layui-btn-normal type_tag" data="video">短视频资源</button>
                </div>
                <div class="layui-btn-group">
                    <button class="layui-btn layui-btn-sm  layui-btn-normal type_tag" data="redbook">小红书资源</button>
                </div>
            </div>
        <div class="layui-card-body">
            <div >
                <p>提示1：<span style="color: red">请选择同步的产品，同步产品后才能使用 </span></p>
                <p>提示2：<span style="color: red">产品同步后可以任意编辑修改，价格可以使用批量调价 </span></p>
                <p>提示3：<span style="color: red">使用平台资源，当资源有更新时，无法进行下单，请更新产品，查看提示！</span></p>
            </div>
            <div class="layui-btn-group layui-inline" style="padding-bottom: 10px">
               
            </div>

            <table id="dataTable" lay-filter="dataTable"></table>

            <script id="platformTpl" type="text/html">
                {{#  layui.each(d.platform, function(index, item){ }}
                 <span>{{ item.platform }}</span>&nbsp;&nbsp;&nbsp;
                {{#  }); }}
            </script>

            <script id="statusTpl" type="text/html">
                <input type="checkbox" name="status" {{#  if(d.fit){  }} lay-filter="status"  {{#  } }}  lay-skin="switch" lay-text="上架|下架"  {{#  if(d.fit){ }} value="{{d.fit.product_id}}"   {{# } else { }} value=""  {{#  } }}  {{#  if(d.product_status == 1){ }} checked {{#  } }}  >
            </script>
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    {{#  if(d.fit){ }}
                        <a class="layui-btn layui-btn-sm" lay-event="edit">编辑</a>
                    <a class="layui-btn layui-btn-sm layui-btn-normal" lay-event="sync">更新</a>
                    {{# } else { }}
                         <a class="layui-btn layui-btn-sm layui-btn-warm" lay-event="upload">同步</a>
                    {{#  } }}
                </div>
            </script>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        layui.use(['layer','table','form'],function () {
            var layer = layui.layer;
            var form = layui.form;
            var table = layui.table;
            //用户表格初始化
            var dataTable = table.render({
                elem: '#dataTable'
                ,url: "<?php echo e(route('admin.product.cloud.data')); ?>" //数据接口
                ,page: true //开启分页
                ,autoSort: false
                ,limit: 20 //每页默认显示的数量
                ,cols: [[ //表头
                    {checkbox: true,fixed: true}
                    ,{field: 'uuid', title: 'ID'}
                    ,{field: 'name', title: '产品名称'}
                    ,{field: 'typename', title: '资源类型'}
                    ,{field: 'quota_min', title: '价格'}
                    ,{field: 'min_money', title: '原价',template:function(d){
                       console.log(d);
                        if(d.fit)
                        {
                            return d.fit.min_money
                        }else{
                            return d.quota_min
                        }
                    }}
                    ,{field: 'apply', title: '下单数',sort:true}
                    ,{field: 'status', title: '资源状态',templet:'#statusTpl',sort:true}
                    ,{title:'操作',width: 220, toolbar: '#options'}
                ]]
            });


            //监听搜索
            form.on('submit(product-search)', function(data){
                var field = data.field;

                //执行重载
                table.reload('dataTable', {
                    where: field
                    ,page:{
                        curr:1
                    }
                });
                return false;
            });

            localStorage.setItem('field','sort');
            localStorage.setItem('order','desc');

            //监听排序事件
            table.on('sort(dataTable)', function(obj){
                table.reload('dataTable', {
                    initSort: obj
                    ,where: {
                        field: obj.field //排序字段
                        ,order: obj.type //排序方式
                    }
                });
                localStorage.setItem('field',obj.field);
                localStorage.setItem('order',obj.type);
            });


            //监听工具条
            table.on('tool(dataTable)', function(obj){ //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
                var data = obj.data //获得当前行数据
                    ,layEvent = obj.event; //获得 lay-event 对应的值
               if(layEvent==='edit'){
                    location.href = '/admin/product/cloud/'+data.fit.product_id+'/edit';
                }else if(layEvent==='upload') {
                    layer.confirm('确认已经更新数据库字典了吗？', function(index){
                        layer.close(index);
                        var ids =  [data.uuid]
                        $.post("<?php echo e(route('admin.product.cloud.fit')); ?>",{ids:ids},function (result) {
                            if (result.code=== '200'){
                                layer.msg(result.info,{icon:1});
                                dataTable.reload();
                            }else {
                                layer.msg(result.info,{icon:2});
                            }
                        });
                    });
                }else{
                   layer.confirm('更新价格', function(index){
                       layer.close(index);
                       $.post("<?php echo e(route('admin.product.cloud.sync')); ?>",{id:data.uuid},function (result) {
                           if (result.code=== 200){
                               layer.msg(result.info,{icon:1});
                               dataTable.reload();
                           }else {
                               layer.msg(result.info,{icon:2});
                           }
                       });
                   });
               }
            });

            //按钮批量删除
            $("#listDelete").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                if (ids.length>0){
                    layer.confirm('确认删除吗？', function(index){
                        $.post("<?php echo e(route('admin.product.destroy')); ?>",{_method:'delete',ids:ids},function (result) {
                            if (result.code===0){
                                delReload(dataTable,ids.length);
                                layer.msg(result.msg,{icon:1});
                            }else {
                                layer.msg(result.msg,{icon:2});
                            }
                            layer.close(index);
                        });
                    })
                }else {
                    layer.msg('请选择删除项')
                }
            })

            //上下架
            form.on('switch(status)', function(data){
                var id=data.value;
                var status=data.elem.checked;
                $.post("<?php echo e(route('admin.product.status')); ?>",{id:id,status:status},function (res) {
                    if(res.code===0){
                        layer.msg(res.msg,{icon:1});
                    }else {
                        layer.msg(res.msg,{icon:2});
                        dataTable.reload();
                    }
                })
            });

            //excel
            $("#excel").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                        ids.push(element.id)
                    })
                }
                var params=$('#search-form').serialize();
                var field=localStorage.getItem('field');
                var order=localStorage.getItem('order');
                window.location.href="<?php echo e(route('admin.product.excel')); ?>"+"?ids="+ids+"&"+params+"&field="+field+"&order="+order;
            })
            //批量一键更新
            $("#fitList").click(function () {
                var ids = []
                var hasCheck = table.checkStatus('dataTable')
                var hasCheckData = hasCheck.data
                if (hasCheckData.length>0){
                    $.each(hasCheckData,function (index,element) {
                         if(element.fit == null)
                         {
                             ids.push(element.uuid)
                         }
                    })
                }
                if(ids.length>0)
                {
                    layer.confirm('确认已经更新数据库字典了吗？', function(index){
                        layer.close(index);
                        $.post("<?php echo e(route('admin.product.cloud.fit')); ?>",{ids:ids},function (result) {
                            if (result.code=== '200'){
                                delReload(dataTable)
                                layer.msg(result.info,{icon:1});
                            }else {
                                layer.msg(result.info,{icon:2});
                            }
                        });
                    })
                }
                else
                {
                    layer.msg('请选择需要批量更新的数据',{icon:5})
                }
            })
            $(".type_tag").click(function () {
                 var tag = $(this).attr("data");
                 if(!tag)
                 {
                     layer.msg('请选择类型',{icon:2});
                     return false;
                 }else{
                     location.href ='/admin/product/cloud/type?type='+tag;
                 }
            })
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.base', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>