<?php

/**
 * 安装程序
 */

header('Content-Type: text/html; charset=utf-8');

// 判断环境
if (version_compare(PHP_VERSION, '5.3.10') < 0) {
    echo "<font color=red>PHP版本必须在5.3.10以上</font>";
	exit;
}
if (!function_exists('mcrypt_encrypt')) {
    exit('PHP未开启Mcrypt扩展');
}


define('WEBPATH', dirname(__FILE__).'/');

// 判断目录权限
foreach ([
             WEBPATH.'cms/cache/',
             WEBPATH.'cms/logs/',
             WEBPATH.'config/',
             WEBPATH.'uploadfile/',
         ] as $t) {
    if (!dr_check_put_path($t)) {
        exit('目录（'.$t.'）不可写');
    }
}

if (count($_POST) > 1) {

    // 数据库连接测试
    $mysqli = function_exists('mysqli_init') ? mysqli_init() : 0;
    if (!$mysqli) {
        exit('PHP环境必须启用Mysqli扩展');
    }


    if (!@mysqli_real_connect($mysqli, $_POST['host'], $_POST['root'], $_POST['pass'])) {
        exit(('无法连接到数据库服务器（'.$_POST['host'].'）<br>请检查用户名（'.$_POST['root'].'）和密码（'.$_POST['pass'].'）是否正确'));
    }
    if (!@mysqli_select_db($mysqli, $_POST['name'])) {
        if (!@mysqli_query($mysqli, 'CREATE DATABASE `'.$_POST['name'].'`')) {
            exit(('数据库（'.$_POST['name'].'）不存在，请手动建立数据库'));
        }
    }

    // utf8方式打开数据库

    $config = "
<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * 数据库配置文件
 */

return array(
    'hostname' => '".$_POST['host']."',
    'username' => '".$_POST['root']."',
    'password' => '".$_POST['pass']."',
    'database' => '".$_POST['name']."',
    'dbprefix' => '".$_POST['prefix']."',
);
    ";


    $size = file_put_contents(WEBPATH.'config/database.php', $config);
    if (!$size) {
        exit('文件写入失败：config/database.php');
    }

    @unlink('install.php');
    exit('数据库配置成功，请在服务端进行数据通信操作。');



} else {
    echo '
    <form action="install.php" method="post">
      <p>数据库主机: <input type="text" name="host" value="localhost" /></p>
      <p>数据库账号: <input type="text" name="root" /></p>
      <p>数据库密码: <input type="text" name="pass" /></p>
      <p>数据库名称: <input type="text" name="name" /></p>
      <p>数据表前缀: <input type="text" name="prefix" value="dr_" /> 必须和服务端表前缀保持一致</p>
      <input type="submit" value="点击安装程序" />
    </form>
    ';

    exit;

}



// 检查目录权限
function dr_check_put_path($dir) {

    if (!$dir) {
        return 0;
    } elseif (!is_dir($dir)) {
        return 0;
    }

    $size = file_put_contents($dir.'test.html', 'test');
    if ($size === false) {
        return 0;
    } else {
        @unlink($dir.'test.html');
        return 1;
    }
}