<?php

/**
 * URL解析规则
 * 例如：  114.html 对应 index.php?s=demo&c=show&id=114
 * 可以解析：  "114.html"  => 'index.php?s=demo&c=show&id=114',
 * 动态id解析：  "([0-9]+).html"  => 'index.php?s=demo&c=show&id=$1',
 */

return [

    /***********************系统默认URL解析规则*************************/

    'test.html' => 'index.php?s=test&c=home&m=index',
    'test222' => 'index.php?s=test&c=home&m=index',

    
    
    /***********************下面写你自己的URL解析规则********************/

    "tag\/(.+).html(.*)"  => 'tag/index/name/$1',
    "news.html(.*)"  => 'news/home/index/',
    "page\-([0-9]+).html(.*)"  => 'page/index/id/$1',
    "news\-list\-(.+).html(.*)"  => 'news/category/index/dir/$1',
    "news\/search.html(.*)"  => 'news/search/index',
    "news\/search\-(.+).html(.*)"  => 'news/search/index/rewrite/$1',
    "news\-[0-9]+\/([0-9]+).html(.*)"  => 'news/show/index/id/$1',



    "([\w]+)"  => 'category/index/dir/$1',
    
];