<?php namespace Phpcmf\Controllers\Member;

// 云服务
class Cloud extends \Phpcmf\Common
{
    private $admin_url;
    private $license_sn;
    private $service_url;
    private $version;
    private $cmf_version;

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        $this->service_url = 'http://yun.kouhaobang.com/cloud.php?domain='.urlencode(SITE_URL.SELF);

    }


    // 游戏
    public function index() {
        $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);
        $auth = select_auth($this->uid);
        \Phpcmf\Service::V()->assign([
            'url' => dr_member_url('cloud/game'),
            'hd_menu' => $menu,
            'auth' => $auth,
        ]);
        \Phpcmf\Service::V()->display('cloud.html');exit;
    }


    // 游戏
    public function game() {
        \Phpcmf\Service::V()->assign([
            'url' => $this->service_url.'&action=game',
        ]);
        \Phpcmf\Service::V()->admin();
        \Phpcmf\Service::V()->display('cloud_online.html');exit;
    }



    // 服务器下载
    function down() {
        $file = ($_GET['file']);
        $data = dr_catcher_data($file);
        if (!$data) {
            $this->_admin_msg(0, '没有从服务端获取到数据');
        }

		$zipfile = WRITEPATH.md5($file).'.zip';
        file_put_contents($zipfile, $data);

//        helper('filesystem');
        deldir(WRITEPATH.'/attach/');
        
        if (!is_dir(WRITEPATH.'/attach/')) {
             @rmdir(WRITEPATH.'/attach/');
        }

		// 下载成功，安装操作
		include_once(CMSPATH.'Library/Pclzip.php');
        $this->pclzip = new \Pclzip();
        $this->pclzip->PclFile($zipfile);
        if ($this->pclzip->extract(PCLZIP_OPT_PATH, WRITEPATH.'/attach/', PCLZIP_OPT_REPLACE_NEWER) == 0) {
            exit  ("Error : " . $this->pclzip->errorInfo(true));
        }
        unlink($zipfile);
        $dir = '';
        $local = dr_dir_map(WRITEPATH.'/attach/', 1);
        foreach ($local as $value) {
            if (is_file(WRITEPATH.'/attach/'.$value.'/Config/App.php')) {
                $dir = ucfirst($value);
                break;
            }
        }
        if (!$dir) {
            $this->_admin_msg(0, '压缩包不规范');
        }

        recurse_copy(WRITEPATH.'/attach/'.$dir.'/', PLUGPATH.$dir.'/');
        if (!is_file(PLUGPATH.$dir.'/Config/App.php')) {
            $this->_admin_msg(0, '文件复制失败');
        }



        $path = PLUGPATH.$dir.'/';
        !is_dir($path) && $this->_json(0, dr_lang('模块目录[%s]不存在', $path));

        // 对当前模块属性判断
        $cfg = require $path.'Config/App.php';
        !$cfg && $this->_json(0, dr_lang('文件[%s]不存在', 'App/'.$dir.'/Config/App.php'));

        //添加游戏
        $cfg['share'] = 3;
        $rt = \Phpcmf\Service::M('H5_module','hd')->install_game($dir, $cfg);
//        $this->_admin_msg(1, '安装成功');
        $this->_admin_msg($rt['code'], $rt['msg']);
    }

}
