<?php namespace Phpcmf\Controllers\Member;

include ("../JSSDK.php");
class My extends \Phpcmf\Table {
    public function __construct(...$params)
    {
        parent::__construct(...$params);
    }

    // index
    public function index()
    {

            //如果不是管理员
            $status = (int)\Phpcmf\Service::L("input")->get("status");
            if($status == 1){
                $where = '  delete_key=0 and status=1 and company_id="'.$this->member['company_id'].'"';
            }else if($status == 2){
                $where = '  delete_key=0 and status=2 and company_id="'.$this->member['company_id'].'"';
            }
            else if($status == 3){
                $where = '  delete_key=0 and status=3 and company_id="'.$this->member['company_id'].'"';
            }
            else if($status == 4){
                $where = '  delete_key=0 and status=4 and company_id="'.$this->member['company_id'].'"';
            }
            else if($status == 5){
                $where = ' delete_key=0 and status=5 and company_id="'.$this->member['company_id'].'"';
            }
            else{
                $where = ' delete_key=0 and company_id="'.$this->member['company_id'].'"';
            }


        // 支持附表存储
        $this->is_data = 0;
        // 表单显示名称
        $this->name = dr_lang('我的活动');
        // 初始化数据表
        $this->_init([
            'table' => '1_hd_activity', // 表名称
            'order_by' => 'id desc', // 默认排序
            'where_list' => $where, // 默认条件
        ]);

        $this->_List();

        $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);
        $auth = select_auth($this->uid);
        $auth['SHARE_URL'] = $this->DeleteHtml(SHARE_URL);

//        $auth['auth_func'] = \Phpcmf\Service::M('Config', 'Hd')->checkRole($auth[0]['rule_id']);
        \Phpcmf\Service::V()->assign(array(
            'hd_menu' => $menu,
            'auth' => $auth,
        ));

        \Phpcmf\Service::M('Winlist', 'Hd')->index();
        //根据uri 来查询当前方法的id
        $uri = \Phpcmf\Service::L("Router")->uri();
        $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
        \Phpcmf\Service::M('Config', 'Hd')->_auth_view($auth, $uriId, 'activity_list.html');
//        \Phpcmf\Service::V()->display('activity_list.html');
    }

//    去换行空格回车
    function DeleteHtml($str)
    {
        $str = trim($str); //清除字符串两边的空格
        $str = strip_tags($str,""); //利用php自带的函数清除html格式
        $str = preg_replace("/\t/","",$str); //使用正则表达式替换内容，如：空格，换行，并将替换为空。
        $str = preg_replace("/\r\n/","",$str);
        $str = preg_replace("/\r/","",$str);
        $str = preg_replace("/\n/","",$str);
        $str = preg_replace("/ /","",$str);
        $str = preg_replace("/  /","",$str);  //匹配html中的空格
        return trim($str); //返回字符串
    }

    //发布
    public function release(){
        //根据uri 来查询当前方法的id
        $auth = select_auth($this->uid);
        $uri = \Phpcmf\Service::L("Router")->uri();
        $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
        $result = \Phpcmf\Service::M('Config', 'Hd')->auth_func($auth, $uriId);
        if($result){
            $id = (int)\Phpcmf\Service::L("input")->get("id");
            $start_time = \Phpcmf\Service::L("input")->get("start_time");
            $end_time = \Phpcmf\Service::L("input")->get("end_time");

            $rt = \Phpcmf\Service::M('Activity', 'Hd')->_release($id,$start_time,$end_time,$this->member['username']);
            if($rt){
                return $this->_json('1','发布成功');
            }else{
                return $this->_json('0','发布错误');
            }
        }else{
            return $this->_json('-1','您没有权限发布');
        }


    }

    //结束活动
    public function over(){
        //根据uri 来查询当前方法的id
        $auth = select_auth($this->uid);
        $uri = \Phpcmf\Service::L("Router")->uri();
        $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
        $result = \Phpcmf\Service::M('Config', 'Hd')->auth_func($auth, $uriId);
        if($result) {
            $id = (int)\Phpcmf\Service::L("input")->post("id", true);

            $rt = \Phpcmf\Service::M('Activity', 'Hd')->_over($id, $this->member['username']);
            if ($rt) {
                return $this->_json('1', '结束成功');
            } else {
                return $this->_json('0', '结束失败');
            }
        }else{
            return $this->_json('-1','您没有权限结束活动');
        }
    }

    /**
     * @param $id
     * 复制活动
     */
    public function copy_hd(){
        //根据uri 来查询当前方法的id
        $auth = select_auth($this->uid);
        $uri = \Phpcmf\Service::L("Router")->uri();
        $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
        $result = \Phpcmf\Service::M('Config', 'Hd')->auth_func($auth, $uriId);
        if($result) {
            $id = (int)\Phpcmf\Service::L("input")->post("id", true);
            $rt = \Phpcmf\Service::M('Activity', 'Hd')->_copy_hd($id, $this->member['username']);
            if ($rt) {
                $this->_json('1', '复制成功');
            } else {
                $this->_json('0', '复制失败');
            }
        }else{
            return $this->_json('-1','您没有权限复制活动');
        }

    }

    //软删除
    public function delete_hd(){
        //根据uri 来查询当前方法的id
        $auth = select_auth($this->uid);
        $uri = \Phpcmf\Service::L("Router")->uri();
        $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
        $result = \Phpcmf\Service::M('Config', 'Hd')->auth_func($auth, $uriId);
        if($result) {
            $id = (int)\Phpcmf\Service::L("input")->post("id", true);
            $rt = \Phpcmf\Service::M('Activity', 'Hd')->soft_delete_hd($id, $this->member['username']);
            if ($rt) {
                $this->_json('1', '删除成功');
            } else {
                $this->_json('0', '删除失败');
            }
        }else{
            return $this->_json('-1','您没有权限删除活动');
        }
    }

    //真删除
    public function soft_delete_hd(){
        $auth = select_auth($this->uid);
        $uri = \Phpcmf\Service::L("Router")->uri();
        $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
        $result = \Phpcmf\Service::M('Config', 'Hd')->auth_func($auth, $uriId);
        if($result) {
            $id = (int)\Phpcmf\Service::L("input")->post("id", true);
            $rt = \Phpcmf\Service::M('Activity', 'Hd')->_delete_hd($id, $this->member['username']);
            if ($rt) {
                $this->_json('1', '删除成功');
            } else {
                $this->_json('0', '删除失败');
            }
        }else{
            return $this->_json('-1','您没有权限删除活动');
        }
    }



    //添加活动
    public function add() {
        //根据uri 来查询当前方法的id
        $auth = select_auth($this->uid);
        $uri = \Phpcmf\Service::L("Router")->uri();
        $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
        $result = \Phpcmf\Service::M('Config', 'Hd')->auth_func($auth, $uriId);
        if($result) {
            $id = (int)\Phpcmf\Service::L("input")->get("id");
            $file = \Phpcmf\Service::L("input")->get("file");
            $rt = \Phpcmf\Service::M('Activity', 'Hd')->_select_id($id);
//        $a = date('Y-m-d H:i:s',strtotime("+7 day"));
//        print_r($a);exit;
            if ($rt) {
//            $all_number = \Phpcmf\Service::M('Activity', 'Hd')->_hd_all_number();
                $data = array(
                    'hd_id' => $id,
                    'uid' => $this->uid,
                    'name' => $rt['title'],
                    'hd_img' => $rt['thumb'],
                    'create_time' => time(),
                    'start_time' => time(),
                    'end_time' => strtotime("+7 day"),
                    'file' => $file,
                    'company_id' => $this->member['company_id'],
                    'unit' => '企业名称',
//                'activity_code' => 'HD'.($all_number+1), //活动编码
                );
                \Phpcmf\Service::M('Activity', 'Hd')->_hd_create($data, $rt['title'], $this->member['username']);
            } else {
                return $this->_json('0', 'id有误');
            }
        }else{
            dr_redirect('/index.php?s=member');
        }
    }

    //显示
    public function show(){
        //根据uri 来查询当前方法的id
        $auth = select_auth($this->uid);
        $uri = \Phpcmf\Service::L("Router")->uri();
        $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
        $result = \Phpcmf\Service::M('Config', 'Hd')->auth_func($auth, $uriId);
        if($result){
            $id = (int)\Phpcmf\Service::L("input")->get("id");
            $file = \Phpcmf\Service::M('Activity', 'Hd')->_hd_show($id);

            $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);
            $auth = select_auth($this->uid);
            \Phpcmf\Service::V()->assign(array(
                'hd_menu' => $menu,
                'auth' =>  $auth,
            ));

            \Phpcmf\Service::M('Config', 'Hd')->_auth_view($auth, 2, 'static/'.$file.'/activity_create.html');
        }else{
            dr_redirect('/index.php?s=member');
        }
    }

    //显示奖品
    public function show_product(){

        $id = (int)\Phpcmf\Service::L("input")->get("id");
        $rt = \Phpcmf\Service::M('Activity', 'Hd')->_hd_show_product($id);

        if($rt){
            $this->_json('1','',$rt);
        }else{
            $this->_json('0','');
        }


    }

    //修改
    public function edit(){
        $post_data = \Phpcmf\Service::L("input")->post("data",true);
//        print_r($post_data);
        $rt = \Phpcmf\Service::M('Activity', 'Hd')->_hd_edit($post_data,$this->member['username']);

        if($rt){
            $this->_json('1','修改成功');
        }else{
            $this->_json('0','修改失败');
        }

    }

    //图片上传保存
    public function upload(){

        $rt = \Phpcmf\Service::L('upload')->upload_file([
            'path' => '',
            'form_name' => 'file',
            'file_exts' => ['jpg', 'png', 'jpeg','mp3','gif'],
            'file_size' => 2 * 1024 * 1024,
            'attachment' => \Phpcmf\Service::M('Attachment')->get_attach_info(0),
        ]);
        !$rt['code'] && exit(json_encode($rt));

        // 附件归档
        $data = \Phpcmf\Service::M('Attachment')->save_data($rt['data']);
        !$data['code'] && exit(json_encode($data));

        // 上传成功
        $this->_json(1, '', ['src' => $rt['data']['url']]);

        exit;
    }

    //音乐上传保存
    public function upload_music(){

        $rt = \Phpcmf\Service::L('upload')->upload_file([
            'path' => '',
            'form_name' => 'file',
            'file_exts' => ['mp3'],
            'attachment' => \Phpcmf\Service::M('Attachment')->get_attach_info(0),
        ]);
        !$rt['code'] && exit(json_encode($rt));

        // 附件归档
        $data = \Phpcmf\Service::M('Attachment')->save_data($rt['data']);
        !$data['code'] && exit(json_encode($data));

        // 上传成功
        $this->_json(1, '', ['src' => $rt['data']['url']]);

        exit;
    }

    //回收站
    public function reclaim(){
        // 支持附表存储
        $this->is_data = 0;
        // 表单显示名称
        $this->name = dr_lang('回收站');
        // 初始化数据表
        $this->_init([
            'table' => '1_hd_activity', // 表名称
            'order_by' => 'id desc', // 默认排序
            'where_list' => 'delete_key=1', // 默认条件
        ]);
        $this->_List();

        $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);
        \Phpcmf\Service::V()->assign(array(
            'hd_menu' => $menu,
            'auth' => select_auth($this->uid),
        ));

        return \Phpcmf\Service::V()->display('reclaim.html');
    }

    //恢复
    public function restore(){
        $id = (int)\Phpcmf\Service::L("input")->post("id",true);
        $rt = \Phpcmf\Service::M('Activity', 'Hd')->_restore($id, $this->member['username']);
        if($rt){
            $this->_json('1','恢复成功');
        }else{
            $this->_json('0','恢复失败');
        }
    }

    //减奖品
    public function minus(){
        $id = (int)\Phpcmf\Service::L("input")->get("id");
        $rt = \Phpcmf\Service::M('Activity', 'Hd')->_minus($id);
        if($rt){
            $this->_json('1','ok');
        }else{
            $this->_json('0','no');
        }
    }

    //加奖品
    public function add_product(){
        $id = (int)\Phpcmf\Service::L("input")->get("id");
        $rt = \Phpcmf\Service::M('Activity', 'Hd')->_add_product($id);
        if($rt){
            $this->_json('1','ok',$rt);
        }else{
            $this->_json('0','no');
        }
    }

    //获取要发布的奖品
    public function ajax_product(){
        $id = (int)\Phpcmf\Service::L("input")->post("id",true);
        $rt = \Phpcmf\Service::M('Activity', 'Hd')->_ajax_product($id);
        if($rt){
            $this->_json('1','',$rt);
        }else{
            $this->_json('0','查询有误');
        }
    }

    //清除回收站
    public function delete_all(){
        $rt = \Phpcmf\Service::M('activity', 'Hd')->_delete_all($this->member['username']);
        if($rt){
            return $this->_json('1','删除成功');
        }else{
            return $this->_json('0','删除失败');
        }
    }

    //中奖列表
    public function win(){
        $auth = select_auth($this->uid);
        $uri = \Phpcmf\Service::L("Router")->uri();
        $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
        $result = \Phpcmf\Service::M('Config', 'Hd')->auth_func($auth, $uriId);
        if($result) {
            $id = (int)\Phpcmf\Service::L("input")->get("id");
            // 支持附表存储
            $this->is_data = 0;
            // 表单显示名称
            $this->name = dr_lang('获奖名单');
            // 初始化数据表
            $this->_init([
                'table' => '1_hd_winlist', // 表名称
                'order_by' => '1_hd_winlist.id desc', // 默认排序
                'where_list' => '1_hd_winlist.hd_id=' . $id.' and 1_hd_winlist.admin_id="'.$this->member['uid'].'"', // 默认条件
                'join_list' => ['1_hd_user', '1_hd_user.id = 1_hd_winlist.user_id', 'left'], // 联表1
//            'join_list_two' => ['1_hd_product','1_hd_product.id = 1_hd_winlist.pid','left'], // 联表2
            ]);
            $this->_List();

            $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);
            \Phpcmf\Service::V()->assign(array(
                'hd_menu' => $menu,
                'auth' => select_auth($this->uid),
            ));

            return \Phpcmf\Service::V()->display('win_list.html');
        }else{
            dr_redirect('/index.php?s=member');
        }
    }

    //数据重置
    public function data_reset(){
        $id = (int)\Phpcmf\Service::L("input")->post("id",true);
        $rt = \Phpcmf\Service::M('Winlist', 'Hd')->_data_reset($id);
        if($rt){
            $this->_json('1','重置成功');
        }else{
            $this->_json('0','重置失败');
        }
    }

    //玩家列表
    public function pay(){
        $id = (int)\Phpcmf\Service::L("input")->get("id");
        // 支持附表存储
        $this->is_data = 0;
        // 表单显示名称
        $this->name = dr_lang('玩家列表');
        // 初始化数据表
        $this->_init([
            'table' => '1_hd_activity_list', // 表名称
            'order_by' => '1_hd_activity_list.id desc', // 默认排序
            'where_list' => '1_hd_activity_list.hd_id='.$id.' and 1_hd_activity_list.isback=0', // 默认条件
            'join_list' => ['1_hd_user','1_hd_user.id = 1_hd_activity_list.user_id','left'], // 默认条件
        ]);
        /*// 初始化数据表
        $this->_init([
            'table' => '1_hd_user', // 表名称
            'order_by' => 'id desc', // 默认排序

        ]);*/
        $this->_List();

        $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);
        \Phpcmf\Service::V()->assign(array(
            'hd_menu' => $menu,
            'auth' => select_auth($this->uid),
        ));

        return \Phpcmf\Service::V()->display('pay_list.html');
    }

    //黑名单
    public function back(){
        $id = (int)\Phpcmf\Service::L("input")->get("id");
        // 支持附表存储
        $this->is_data = 0;
        // 表单显示名称
        $this->name = dr_lang('黑名单列表');
        // 初始化数据表
        /*$this->_init([
            'table' => '1_hd_activity_list', // 表名称
            'order_by' => '1_hd_activity_list.id desc', // 默认排序
            'where_list' => '1_hd_activity_list.hd_id='.$id.' and 1_hd_activity_list.isback=1', // 默认条件
            'join_list' => ['1_hd_user','1_hd_user.id = 1_hd_activity_list.user_id','left'], // 默认条件
        ]);*/
        $this->_init([
            'table' => '1_hd_user_black', // 表名称
            'order_by' => '1_hd_user_black.id desc ', // 默认排序
            'where_list' => '1_hd_user_black.hd_id='.$id.'', // 默认条件
            'join_list' => ['1_hd_user','1_hd_user.id = 1_hd_user_black.user_id','left'], // 默认条件
        ]);
        $this->_List();
        $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);
        \Phpcmf\Service::V()->assign(array(
            'hd_menu' => $menu,
            'auth' => select_auth($this->uid),
        ));
        return \Phpcmf\Service::V()->display('back_list.html');
    }

    /**
     * 数据分析
     */
    public function analysis(){
        $auth = select_auth($this->uid);
        $uri = \Phpcmf\Service::L("Router")->uri();
        $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
        $result = \Phpcmf\Service::M('Config', 'Hd')->auth_func($auth, $uriId);
        if($result) {
            $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);
            $info = \Phpcmf\Service::M('Activity', 'Hd')->show($_GET['id']);
            \Phpcmf\Service::V()->assign(array(
                'hd_menu' => $menu,
                'auth' => select_auth($this->uid),
                'info' => $info
            ));
            return \Phpcmf\Service::V()->display('analysis.html');
        }else{
            dr_redirect('/index.php?s=member');
        }
    }

    /**
     * 活动平均数据
     */
    public function average(){
        $id = $_POST['id'];
        $type = $_POST['type'];
        $result = \Phpcmf\Service::M('Activity', 'Hd')->averageData($id,$type);
        $list = [];
        $number = [];
        $arr = [];
        $win = [];
        if($_POST['start'])
        {
            $start = strtotime($_POST['start']);
            $end =strtotime($_POST['end']);
        }else {
            $info = \Phpcmf\Service::M('Activity', 'Hd')->show($id);
            $start = $info['info']['start_time'];
            $end = $info['info']['end_time'];
        }
        if($result){
            foreach ($result['member'] as $k => $item) {
                $list[] = $item['time'];
                $number[] = $item['total'];
                $win[] = $arr[$k]['total'];
            }
            $data = $this->get_week($type,time(),"Y-m-d",$start,$end);//时间轴
//            $arr['time'] = $this->get_week($type,time());//时间轴
            sort($list);
//            $arr['time'] = strtotime('2018-01-01');
            $arr['time'] = $data ? $data : $list;
            $arr['number'] = $number;//参与人数
            $arr['view'] = $number;//访问人数
            foreach($win as &$w)
            {
                if(!$w)
                {
                    $w = 0;
                }
            }
            $arr['win'] = $win;//得奖人数
            /*男女比例**/

            $arr['sex'] = $result['sex'];

            /*男女比例**/

        }
        return $this->_json('1','请求成功',$arr);
    }

    /**
     * 获取一周日期
     * @param $time 时间戳
     * @param $format 转换格式
     */
    function get_week($type,$time, $format = "Y-m-d",$start=null,$end=null) {
        $data = [];
        if($type=='week') {
            $week = date('w', $time);
            $weekname = array('星期一', '星期二', '星期三', '星期四', '星期五', '星期六', '星期日');
            //星期日排到末位
            if (empty($week)) {
                $week = 7;
            }
            for ($i = 0; $i <= 6; $i++) {
                $data[$i] = date($format, strtotime('+' . $i + 1 - $week -7 . ' days', $time));
            }
        }
        if($type == 'month')
        {
            for ($i = 0; $i <= 30; $i++) {
                $data[] = date("Y-m-d", strtotime("-$i day"));
            }
            sort($data);
        }
        if($type=='search')
        {
            $dt_start = $start;
            $dt_end = $end;
            while ($dt_start<=$dt_end){
                $date = date('Y-m-d',$dt_start);
                $data[] = $date;
                $dt_start = strtotime('+1 day',$dt_start);
            }
        }
        return $data;
    }

//    移入黑名单
    public function mvin_black(){
        $chkStr = \Phpcmf\Service::L("input")->post("chkArr");
        $hd_id = (int)\Phpcmf\Service::L("input")->post("hd_id");
        $value = \Phpcmf\Service::L("input")->post("value");
        $chkArr = explode(',',$chkStr);

        $rt = \Phpcmf\Service::M('User', 'Hd')->mvin_black($chkArr, $hd_id, $this->member['username'],$value);
        if($rt){
            return $this->_json('1','移入成功');
        }else{
            return $this->_json('0','移入失败或者该用户已在黑名单');
        }
    }

    //移出黑名单
    public function mvout_black(){
        $chkStr = \Phpcmf\Service::L("input")->post("chkArr");
        $hd_id = (int)\Phpcmf\Service::L("input")->post("hd_id");
        $chkArr = explode(',',$chkStr);
        $rt = \Phpcmf\Service::M('User', 'Hd')->mvout_black($chkArr, $hd_id, $this->member['username']);
        if($rt){
            return $this->_json('1','移出成功');
        }else{
            return $this->_json('0','移出失败');
        }
    }


    public function checkAddress(){
        //TODO::微信配置
        $weixin = \Phpcmf\Service::M('Config', 'Hd')->getCompanyIdFromHdId(80);

        $weixinConfig = json_decode($weixin[0]['value'],true);
        //***微信js 配置**//

        $jssdk = new \JSSDK($weixinConfig['key'], $weixinConfig['secret']);

        $signPackage = $jssdk->GetSignPackage();

//            print_r($wchat_config);
//            print_r($signPackage);
        \Phpcmf\Service::V()->assign('signPackage', $signPackage);
        return \Phpcmf\Service::V()->display('test.html');
    }

}