<?php namespace Phpcmf\Controllers\Member;

//员工权限
class Permissions extends \Phpcmf\Table {
    public function __construct(...$params)
    {
        parent::__construct(...$params);
    }

    public function index(){
        // 支持附表存储
        $this->is_data = 0;
        // 表单显示名称
        $this->name = dr_lang('我的活动');
        // 初始化数据表
        $this->_init([
            'table' => 'member', // 表名称
            'order_by' => 'id desc', // 默认排序
            'where_list' => 'company_id = "'.$this->member['company_id'].'"', // 默认条件
        ]);
        $this->_List();
        $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);
        $auth = select_auth($this->uid);
        \Phpcmf\Service::V()->assign(array(
            'hd_menu' => $menu,
            'auth' => $auth,
        ));

        if($this->member['is_admin']){
            //根据uri 来查询当前方法的id
            $uri = \Phpcmf\Service::L("Router")->uri();
            $uriId = \Phpcmf\Service::M('HdMenu', 'Hd')->getId($uri);
            \Phpcmf\Service::M('Config', 'Hd')->_auth_view($auth, $uriId, 'permissions.html');
//            \Phpcmf\Service::V()->display('permissions.html');
        }else{
            dr_redirect('/index.php?s=member');
        }



    }

    //显示修改页面
    public function show(){
        $id = (int)\Phpcmf\Service::L("input")->get("id");
        $rows = \Phpcmf\Service::M('Permissions', 'Hd')->_show($id);
        \Phpcmf\Service::V()->assign(array(
            'list' => $rows,
        ));

//        print_r($rows);
        $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);

//        $rule = \Phpcmf\Service::M('Permissions', 'Hd')->rule($id);

        \Phpcmf\Service::V()->assign(array(
            'hd_menu' => $menu,
//            'rule_id' => $rule,
            'auth' => select_auth($this->uid),
        ));

        \Phpcmf\Service::V()->display('permissions_edit.html');
    }

    //查询选中的权限
    public  function select_rule(){
        $id = (int)\Phpcmf\Service::L("input")->post("id",true);
        $rule = \Phpcmf\Service::M('Permissions', 'Hd')->_select_rule($id);
    }



    //修改
    public function edit(){
        $post_data = \Phpcmf\Service::L("input")->post("data",true);
        $rule_id = json_encode(explode(',',$post_data['rule_id']));
        $id = $post_data['id'];
        if($post_data['password']==null){
            if($post_data['rule_id']==null){
                $data_member_data = array(
                    'position' => $post_data['position'],
                    'game_access' => $post_data['game_access'],
                    'sex' => $post_data['sex'],
                    'jobs' => $post_data['jobs'],
                    'birthday' => $post_data['birthday'],
                    'domicile' => $post_data['domicile'],
                    'home_phone' => $post_data['home_phone'],
                    'id_card' => $post_data['id_card'],
                    'note' => $post_data['note'],
                );
            }else{
                $data_member_data = array(
                    'position' => $post_data['position'],
                    'game_access' => $post_data['game_access'],
                    'sex' => $post_data['sex'],
                    'jobs' => $post_data['jobs'],
                    'birthday' => $post_data['birthday'],
                    'domicile' => $post_data['domicile'],
                    'home_phone' => $post_data['home_phone'],
                    'id_card' => $post_data['id_card'],
                    'note' => $post_data['note'],
                    'rule_id' => $rule_id,
                );
            }

            $data_member = array(
                'username' => $post_data['username'],
                'name' => $post_data['name'],
                'email' => $post_data['email'],
                'phone' => $post_data['phone'],
            );
        }else{
            if($post_data['rule_id']==null){
                $data_member_data = array(
                    'position' => $post_data['position'],
                    'game_access' => $post_data['game_access'],
                    'sex' => $post_data['sex'],
                    'jobs' => $post_data['jobs'],
                    'birthday' => $post_data['birthday'],
                    'domicile' => $post_data['domicile'],
                    'home_phone' => $post_data['home_phone'],
                    'id_card' => $post_data['id_card'],
                    'note' => $post_data['note'],
                );
            }else{
                $data_member_data = array(
                    'position' => $post_data['position'],
                    'game_access' => $post_data['game_access'],
                    'sex' => $post_data['sex'],
                    'jobs' => $post_data['jobs'],
                    'birthday' => $post_data['birthday'],
                    'domicile' => $post_data['domicile'],
                    'home_phone' => $post_data['home_phone'],
                    'id_card' => $post_data['id_card'],
                    'note' => $post_data['note'],
                    'rule_id' => $rule_id,
                );
            }

            $data_member = array(
                'username' => $post_data['username'],
                'name' => $post_data['name'],
                'email' => $post_data['email'],
                'phone' => $post_data['phone'],
                'password' => dr_safe_password($post_data['password']),
            );
        }

        $rt = \Phpcmf\Service::M('Permissions', 'Hd')->_edit($id,$data_member,$data_member_data);
        if($rt){
            $this->_json('1','修改成功');
        }else{
            $this->_json('0','修改失败');
        }

    }

    //删除
    public function del(){
        $id = (int)\Phpcmf\Service::L("input")->post("id",true);
        $rt = \Phpcmf\Service::M('Permissions', 'Hd')->_del($id);
        if($rt){
            $this->_json('1','删除成功');
        }else{
            $this->_json('0','删除失败');
        }
    }

//    添加
    public function add(){

        $menu = \Phpcmf\Service::M('HdMenu', 'Hd')->show($id);
        \Phpcmf\Service::V()->assign(array(
            'hd_menu' => $menu,
            'auth' => select_auth($this->uid),
        ));

        \Phpcmf\Service::V()->display('permissions_add.html');
    }

    public function add_save(){
        $post = \Phpcmf\Service::L("input")->post("data",true);

        $rule_id = json_encode(explode(',',$post['rule_id']));

        $data_member = array(
            'username' => (string)$post['username'],
            'phone' => (string)$post['phone'],
            'email' => (string)$post['email'],
            'name' => (string)$post['name'],
            'password' => dr_safe_password($post['password']),
        );
        $data_member_data = array(
            'position' => $post['position'],
            'game_access' => $post['game_access'],
            'sex' => $post['sex'],
            'jobs' => $post['jobs'],
            'birthday' => $post['birthday'],
            'domicile' => $post['domicile'],
            'home_phone' => $post['home_phone'],
            'id_card' => $post['id_card'],
            'note' => $post['note'],
            'rule_id' => $rule_id,
        );
//        exit;
        $rt = \Phpcmf\Service::M('member')->register(2, $data_member, $data_member_data);
        if($rt){
            $this->_json(1, '添加成功');
        }else{
            $this->_json(0, '添加失败');
        }

    }


    //查询权限
    public function show_rule(){
        $rt = \Phpcmf\Service::M('HdMenu', 'Hd')->_show_rule($id);
        if($rt){
            $this->_json('1','',$rt);
        }else{
            $this->_json('0','查询有误');
        }
    }
}