<?php namespace Phpcmf\Model;

// 活动模型操作
class Activity extends \Phpcmf\Model
{
    public function index(){
        $recycling = \Phpcmf\Service::M()->db->query('select count(*) from dr_1_hd_activity where delete_key = 1 ');

        return  \Phpcmf\Service::V()->assign(array(
//            'p' => ['app'=>'hd'],
//            'recycling' => $recycling,
        ));
    }


    /**
     * @param $data
     * @return mixed
     * 创建活动 返回创建页面
     */
    public function _hd_create($data,$name,$operator){
        $rt = \Phpcmf\Service::M()->table('1_hd_activity')->insert($data);
        if(!$rt['code']){
            return 0;
        }
        $insert_id = $rt['code'];
        $this->_insert_data($insert_id);
        \Phpcmf\Service::M('Log', 'Hd')->create_log($insert_id,'新增活动:HD'.$insert_id,'新建活动:HD'.$insert_id.'-'.$name,$operator);
        return dr_redirect('index.php?s=member&app=hd&c=my&m=show&id='.$insert_id);
    }

    /**
     * 插入3条默认数据
     */
    public  function _insert_data($insert_id){
        $insert_data1 = array(
            'hd_id' => $insert_id,
            'level' => '一等奖',
            'level_name' => '一等奖',
            'start_time' => time(),
            'end_time' => strtotime("+7 day"),
            'p_name' => '100元礼品包'
        );
        $insert_data2 = array(
            'hd_id' => $insert_id,
            'level' => '二等奖',
            'level_name' => '二等奖',
            'start_time' => time(),
            'end_time' => strtotime("+7 day"),
            'p_name' => '50元礼品包'
        );
        $insert_data3 = array(
            'hd_id' => $insert_id,
            'level' => '三等奖',
            'level_name' => '三等奖',
            'start_time' => time(),
            'end_time' => strtotime("+7 day"),
            'p_name' => '20元礼品包'
        );
        $insert_data4 = array(
            'hd_id' => $insert_id,
            'level' => '四等奖',
            'level_name' => '四等奖',
            'start_time' => time(),
            'end_time' => strtotime("+7 day"),
            'p_status' => '1',
            'p_name' => '5元礼品包'
        );
        $insert_data5 = array(
            'hd_id' => $insert_id,
            'level' => '五等奖',
            'level_name' => '五等奖',
            'start_time' => time(),
            'end_time' => strtotime("+7 day"),
            'p_status' => '1',
            'p_name' => '5元礼品包'
        );
        $insert_data6 = array(
            'hd_id' => $insert_id,
            'level' => '六等奖',
            'level_name' => '六等奖',
            'start_time' => time(),
            'end_time' => strtotime("+7 day"),
            'p_status' => '1',
            'p_name' => '5元礼品包'
        );
        $insert_data7 = array(
            'hd_id' => $insert_id,
            'level' => '七等奖',
            'level_name' => '七等奖',
            'start_time' => time(),
            'end_time' => strtotime("+7 day"),
            'p_status' => '1',
            'p_name' => '5元礼品包'
        );
        $insert_data8 = array(
            'hd_id' => $insert_id,
            'level' => '八等奖',
            'level_name' => '八等奖',
            'start_time' => time(),
            'end_time' => strtotime("+7 day"),
            'p_status' => '1',
            'p_name' => '5元礼品包'
        );
        $insert_data9 = array(
            'hd_id' => $insert_id,
            'level' => '安慰奖',
            'level_name' => '安慰奖',
            'start_time' => time(),
            'end_time' => strtotime("+7 day"),
            'p_status' => '1',
            'p_name' => '5元礼品包'
        );
        \Phpcmf\Service::M()->db->table('1_hd_product')->insert($insert_data1);
        \Phpcmf\Service::M()->db->table('1_hd_product')->insert($insert_data2);
        \Phpcmf\Service::M()->db->table('1_hd_product')->insert($insert_data3);
        \Phpcmf\Service::M()->db->table('1_hd_product')->insert($insert_data4);
        \Phpcmf\Service::M()->db->table('1_hd_product')->insert($insert_data5);
        \Phpcmf\Service::M()->db->table('1_hd_product')->insert($insert_data6);
        \Phpcmf\Service::M()->db->table('1_hd_product')->insert($insert_data7);
        \Phpcmf\Service::M()->db->table('1_hd_product')->insert($insert_data8);
        \Phpcmf\Service::M()->db->table('1_hd_product')->insert($insert_data9);
    }

    /**
     * @param $id
     *  总活动数量
     */
    public function _hd_all_number(){
        return $all_number = \Phpcmf\Service::M()->db->table('1_hd_activity')->countAll();
    }

    /**
     * @return mixed
     * 显示页面
     */
    public function _hd_show($id){
        $row = $this->_hd_select_data($id);
        //设置模板变量
        $data = [ 'hd_id' => $id,
            'id' => $row['activity']['id'],
            'name' => $row['activity']['name'],
            'start_time' => date('Y-m-d H:i:s',$row['activity']['start_time']),
            'end_time' => date('Y-m-d H:i:s',$row['activity']['end_time']),
            'person' => $row['activity']['person'],
            'person_show' => $row['activity']['person_show'],
            'person_limit' => $row['activity']['person_limit'],
            'person_num' => $row['activity']['person_num'],
            'description' => $row['activity']['description'],
            'type' => $row['activity']['type'],
            'demand' => $row['activity']['demand'],
            'total' => $row['activity']['total'],
            'every_one' => $row['activity']['every_one'],
            'win_number' => $row['activity']['win_number'],
            'day_total' => $row['activity']['day_total'],
            'unit' => $row['activity']['unit'],
            'logo' => $row['activity']['logo'],
            'preview_qrcode' => $row['activity']['preview_qrcode'],
            'wx_qrcode' => $row['activity']['wx_qrcode'],
            'attention' => $row['activity']['attention'],
            'button_name' => $row['activity']['button_name'],
            'button_url' => $row['activity']['button_url'],
            'status' => $row['activity']['status'],
            'must_attention' => $row['activity']['must_attention'],
            'advertising' => $row['activity']['advertising'],
            'advertising1' => $row['activity']['advertising1'],
            'win_v' => $row['activity']['win_v'],
            'help' => $row['activity']['help'],
            'help_number' => $row['activity']['help_number'],
            'contact' => $row['activity']['contact'],
            'share' => $row['activity']['share'],
            'share_img_type' => $row['activity']['share_img_type'],
            'share_img' => $row['activity']['share_img'],
            'share_content_type' => $row['activity']['share_content_type'],
            'share_content_no' => $row['activity']['share_content_no'],
            'share_content_win' => $row['activity']['share_content_win'],
            'logo_type' => $row['activity']['logo_type'],
            'load_img_type' => $row['activity']['load_img_type'],
            'load_img' => $row['activity']['load_img'],
            'banner' => $row['activity']['banner'],
            'region' => $row['activity']['region'],
            'product' => $row['product'],
            'bgimg' => $row['activity']['bgimg'],
            'kits_img' => $row['activity']['kits_img'],
            'tbimg' => $row['activity']['tbimg'],
            'needleimg' => $row['activity']['needleimg'],
            'notin_img' => $row['activity']['notin_img'],
            'sb_img' => $row['activity']['sb_img'],
            'music' => $row['activity']['music'],
            'music_status' => $row['activity']['music_status'],
            'science' => $row['activity']['science'],
            'setting' => $row['activity']['setting'],
            'science_url' => $row['activity']['science_url'],
            'science_status' => $row['activity']['science_status'],
            'file' => $row['activity']['file'],
            'exchange_person' => $row['activity']['exchange_person'],
            'cityids1' => $row['activity']['cityids1']];
//        print_r($data);
       \Phpcmf\Service::V()->assign($data);
        return $row['activity']['file'];
    }

    /**
     * @param $id
     * 查询
     */
    public function _hd_select_data($id){

        //基本信息
        $activity = \Phpcmf\Service::M()->db->query("SELECT * FROM `dr_1_hd_activity` WHERE `id`='".$id."'");

        if ($activity) {
            $row['activity'] = $activity->getRowArray();
        }
//        print_r($row['activity']);
        //奖品信息
        $product = \Phpcmf\Service::M()->db->query("SELECT * FROM `dr_1_hd_product` WHERE `hd_id`='".$id."' and p_status=0");

        $row['product'] = $product->getResultArray();
        $arr = [];
        foreach($row['product'] as &$item){
            $arr[] = $item['period'];
            foreach($arr as $val){
                $brr = [];
                if($val){
                    $brr[] = json_decode($val);
                }
            }
            $item['period'] = $brr;
        }
        return $row;
    }

    /**
     * @param $id
     * @return mixed
     * 活动基本信息
     */
    public function show($id){
        
        //基本信息：
        $activity = \Phpcmf\Service::M()->db->query("SELECT * FROM `dr_1_hd_activity` WHERE `id`='".$id."'");
        //活动奖项：
        $options =  \Phpcmf\Service::M()->db->query("SELECT * FROM `dr_1_hd_product` WHERE `p_status`=0 and  `hd_id`='".$id."'");
        $arr['info'] = $activity->getResultArray()[0];
        $arr['options'] = $options->getResultArray();
        return $arr;
    }

    /**
     * 平均数据
     */
    public function averageData($id,$type,$start=null,$end=null){
        if($type == 'week')
        {
            //日期列表
          $time = time()-86400*30;
          $sql = "select  id,FROM_UNIXTIME(create_time, '%Y-%m-%d') as time,count(id) as total from dr_1_hd_activity_list  WHERE(' hd_id = {$id} and create_time > {$time}')
 group by FROM_UNIXTIME(create_time, '%Y-%m-%d') order by id desc limit 7 ";
          $sql2 = "select  id,FROM_UNIXTIME(create_time, '%Y-%m-%d') as time,count(id) as total from dr_1_hd_activity_list where('hd_id = {$id} and status = 1 ') group by FROM_UNIXTIME(create_time, '%Y-%m-%d') order by id desc limit 7 ";
        }
        elseif($type == 'month')
        {//月份
            $time = time()-86400*7;
            $sql = "select  id,FROM_UNIXTIME(create_time, '%Y-%m-%d') as time,count(id) as total from dr_1_hd_activity_list  WHERE('hd_id = {$id} and create_time > {$time}')
 group by FROM_UNIXTIME(create_time, '%Y-%m-%d') order by id desc limit 30 ";
            $sql2 = "select  id,FROM_UNIXTIME(create_time, '%Y-%m-%d') as time,count(id) as total from dr_1_hd_activity_list where('hd_id = {$id} and status = 1 ') group by FROM_UNIXTIME(create_time, '%Y-%m-%d') order by id desc limit 30 ";
        }
        elseif($type == 'limit')
        {//期间
            $sql = "select  id,FROM_UNIXTIME(create_time, '%Y-%m-%d') as time,count(id) as total from dr_1_hd_activity_list
 WHERE ('hd_id = {$id}') group by FROM_UNIXTIME(create_time, '%Y-%m-%d') order by id desc ";
            $sql2 = "select  id,FROM_UNIXTIME(create_time, '%Y-%m-%d') as time,count(id) as total from dr_1_hd_activity_list
where('hd_id = {$id} and  status = 1 ') group by FROM_UNIXTIME(create_time, '%Y-%m-%d') order by id desc ";
        }elseif($type == 'search'){
//            if($start > )
            $info = $this->show($id);
            $start_time = $info['info']['start_time'];
            $end_time = $info['info']['end_time'];
            if($start < $start_time){
                $start = $start_time;
            }
            if($end > $end_time)
            {
                $end = $end_time;
            }
            //搜索
            $sql = "select  id,create_time,FROM_UNIXTIME(create_time, '%Y-%m-%d') as time,count(id) as total from dr_1_hd_activity_list  WHERE( 'hd_id = {$id} and  create_time > {$start} and create_time > {$end}' ) group by FROM_UNIXTIME(create_time, '%Y-%m-%d') order by id asc";
            $sql2 = "select  id,FROM_UNIXTIME(create_time, '%Y-%m-%d') as time,count(id) as total from dr_1_hd_activity_list where('hd_id = {$id} and  status = 1 and create_time > {$start} and create_time < {$end} ') group by FROM_UNIXTIME(create_time, '%Y-%m-%d') order by id desc ";
        }
        //男女比例
        $sql3 = "select  a.id,a.create_time,b.sex,COUNT(a.id) as total from dr_1_hd_activity_list as a
        LEFT JOIN dr_1_hd_user as b ON a.user_id = b.id
        WHERE( ' a.hd_id = {$id} ' )
        GROUP By b.sex
        ";

        //浏览数
        $member = \Phpcmf\Service::M()->db->query($sql);
        $arr['member'] =  $member->getResultArray();
        if($sql2) {
            $win = \Phpcmf\Service::M()->db->query($sql2);
            $arr['win'] = $win->getResultArray();
        }
        if($sql3){//sex
            $member = \Phpcmf\Service::M()->db->query($sql);
            $arr['sex'] =  $member->getResultArray();
        }
        return $arr;
    }

    public function _hd_show_product($id){

        $product = \Phpcmf\Service::M()->db->query("SELECT * FROM `dr_1_hd_product` WHERE `hd_id`='".$id."' and p_status=0");

        $product = $product->getResultArray();
        $arr = [];
        foreach($product as &$item){
            $arr[] = $item['period'];
            foreach($arr as $val){
                $brr = [];
                if($val){
                    $brr[] = json_decode($val);
                }
            }
            $item['period'] = $brr;
        }
//        print_r($product);
        return $product;
    }

    /**
     * @param $id
     * 修改保存
     */
    public function _hd_edit($post_data, $operator)
    {
//        print_r($post_data);exit;
        $help_number = 1 ? $post_data['help_number1'] : $post_data['help_number2'];
        $data = array(
            'name' => $post_data['name'],
            'start_time' => strtotime($post_data['start_time']),
            'end_time' => strtotime($post_data['end_time']),
            'person' => $post_data['person'],
            'person_limit' => $post_data['person_limit'],
            'person_num' => $post_data['person_num'],
            'person_show' => $post_data['person_show'],
            'description' => $post_data['description'],
            'type' => $post_data['type'],
            'total' => $post_data['total'],
            'every_one' => $post_data['every_one'],
            'win_number' => $post_data['win_number'],
            'day_total' => $post_data['day_total'],
            'unit' => $post_data['unit'],
            'attention' => $post_data['attention'],
            'button_name' => $post_data['button_name'],
            'button_url' => $post_data['button_url'],
            'must_attention' => $post_data['must_attention'],
            'advertising' => $post_data['advertising'],
            'win_v' => $post_data['win_v'],
            'help' => $post_data['help'],
            'help_number' => $help_number,//助力次数
            'contact' => $post_data['contact'],
            'share' => $post_data['share'],
            'share_img_type' => $post_data['share_img_type'],
            'share_content_type' => $post_data['share_content_type'],
            'share_content_no' => $post_data['share_content_no'],
            'share_content_win' => $post_data['share_content_win'],
            'logo_type' => $post_data['logo_type'],
            'load_img_type' => $post_data['load_img_type'],
            'banner' => $post_data['banner'],
            'region' => $post_data['region'],
            'music_status' => $post_data['music_status'],
            'tbmusic_status' => $post_data['music_status'],
            'science' => $post_data['science'],
            'science_url' => $post_data['science_url'],
            'science_status' => $post_data['science_status'],
            'edit_time' => time(),
            'cityids1' => $post_data['cityids1'],
            'advertising1' => $post_data['advertising1'],
            'advertising' => $post_data['advertising'],
            'setting' => $post_data['setting'],
        );
        $id_str = '';
        if($post_data['cityids1']){
            $arr_val = explode('-',$post_data['cityids1']);
            if(count($arr_val)){
                foreach($arr_val as $item){
                    if($item<35 && $item>0){
                        $id_str .= $this->cityids($item);
                    }
                    else{
                        $id_str .= ','.$item;
                    }
                }
                $id_str = trim($id_str,',');
            }
        }
        $id_arr = explode(',',$id_str);
        $id_arr = array_unique($id_arr);
        $new_id_str =  implode(',',$id_arr);
        $data['cityids2'] = $new_id_str;
        if($post_data['share_img']!=null){
            $data['share_img'] = $post_data['share_img'];
        };
        if($post_data['load_img']!=null){
            $data['load_img'] = $post_data['load_img'];
        };
        if($post_data['logo']!=null){
            $data['logo'] = $post_data['logo'];
        };
        if($post_data['wx_qrcode']!=null){
            $data['wx_qrcode'] = $post_data['wx_qrcode'];
        };
        if($post_data['bgimg']!=null){
            $data['bgimg'] = $post_data['bgimg'];
        };
        if($post_data['kits_img']!=null){
            $data['kits_img'] = $post_data['kits_img'];
        };
        if($post_data['tbimg']!=null){
             $data['tbimg'] = $post_data['tbimg'];
        };
        if($post_data['needleimg']!=null){
            $data['needleimg'] = $post_data['needleimg'];
        };
        if($post_data['music']!=null){
            $data['music'] = $post_data['music'];
        };
        if($post_data['tbmusic']!=null){
            $data['tbmusic'] = $post_data['tbmusic'];
        };
        if($post_data['advertising_img']!=null){
            $data['advertising_img'] = $post_data['advertising_img'];
        };
        if($post_data['exchange_person']!=null){
            $data['exchange_person'] = $post_data['exchange_person'];
        };
        if($post_data['notin_img'] != null){
            $data['notin_img'] = $post_data['notin_img'];
        };
        if($post_data['sb_img'] != null){
            $data['sb_img'] = $post_data['sb_img'];
        };


//        print_r($post_data);exit;
        $product_arr = [];
        foreach($post_data['p'] as $key => $item){
//            print_r($item);exit;
            $product = array(
                'level' => $item['p_level'],
                'type' => $item['p_type'],
                'p_name' => $item['p_name'],
                'number' => $item['p_number'],
                'total_number' => $item['p_number'],
                'change_type' => $item['opp'],
                'prompt' => $item['p_prompt'],
                'p_address' => $item['p_address'],
               'url' => $item['url'],
//               'qrcode' => $item['p_level'],
                'ticket_type' => $item['ticket_type'],
                'start_time' => strtotime($item['start_time']),
                'end_time' => strtotime($item['end_time']),
//               'start' => $item['p_level'],
//               'end' => $item['p_level'],
                'period' => json_encode($item['period']),
                'vice_title' => $item['vice_title'],
                'customer_phone' => $item['customer_phone'],
                'must_know' => $item['must_know'],
//               'v' => $item['p_level'],
//               'order' => $item['p_level'],
                'securities' => $item['securities'],
                'exchange' => $item['exchange'],
                'period_type' => $item['period_type'],
                'attention' => $item['attention'],
                'type_product' => $item['type_product']?$item['type_product']:1,
                'original_price' => $item['original_price'],
                'target_price' => $item['target_price'],
                'cut_number' => $item['cut_number'],
//                'p_img' => $item['p_img'],
            );
            if($item['p_img'] != null){
                $product['p_img'] = $item['p_img'];
            };
            if($item['zj_img'] != null){
                $product['zj_img'] = $item['zj_img'];
            };

            $product_arr[] = \Phpcmf\Service::M()->db->table('1_hd_product')->where('id', $item['p_id'])->update($product);
        }


        $product_arr[] = \Phpcmf\Service::M()->db->table('1_hd_activity')->where('id', $post_data['id'])->update($data);

        \Phpcmf\Service::M('Log', 'Hd')->create_log($post_data['id'],'修改活动:HD'.$post_data['id'],'修改活动:HD'.$post_data['id'].'-'.$post_data['name'],$operator);

        return $this->_check_result($product_arr);
    }

    //返回改id下的所有子id
    public function cityids($id){
       $info =  \Phpcmf\Service::M()->db->table("linkage_data_1")->where('pid',$id)->get()->getResultArray();
        $ids = '';
        foreach($info as $val){
            $ids .=  ','.$val['id'];
        }
//        print_r($ids);exit;
        return $ids;
    }

    /**
     * @param $arr
     * @return int
     */
    public function _check_result($arr){
        $state = 0;
        foreach($arr as $item){
            if($item){
                $state = 1;
//               return dr_return_data(1, 'ok');
            }else{
//                return dr_return_data(0, 'no');
                $state = 0;
            }
        }

        if($state){
            return 1;
        }else{
            return 0;
        }
    }

    /**
     * @param $id
     * 查询id 情况
     */
    public function _select_id($id){
        if(!$id){
            return;
        }
       return  $this->table('1_hd')->get($id);
    }

    /**
     * @param $id
     * 发布
     */
    public function _release($id, $start_time, $end_time, $operator){
        //结束时间用linux 定时来检测 如果到期就改状态
        if($start_time<time()|| $start_time==time()){
            $data = array(
                'status'=>3,
                'edit_time'=>time(),
            );
        }else if($start_time>time()){
            $data = array(
                'status'=>2,
                'edit_time'=>time(),
            );
        }
        $rt = \Phpcmf\Service::M()->db->table('1_hd_activity')->where('id',$id)->update($data);
        \Phpcmf\Service::M('Log', 'Hd')->create_log($id,'发布活动:HD'.$id,'发布活动:HD'.$id,$operator);
        if($rt){
            return 1;
        }else{
            return 0;
        }
    }

    /**
     * @param $id
     * 结束活动
     */
    public function _over($id, $operator){
        $data = array(
            'status'=>4,
            'edit_time'=>time(),
        );
        $rt = \Phpcmf\Service::M()->db->table('1_hd_activity')->where('id',$id)->update($data);
        \Phpcmf\Service::M('Log', 'Hd')->create_log($id,'结束活动:HD'.$id,'手动结束活动:HD'.$id,$operator);
        if($rt){
            return 1;
        }else{
            return 0;
        }
    }

    /**
     * @param $id
     * @param $operator
     * @return int
     * 活动时间到了  定时器自动 结束活动
     */
    public function auto_over($id){
        $data = array(
            'status'=>4,
            'edit_time'=>time(),
        );
        $rt = \Phpcmf\Service::M()->db->table('1_hd_activity')->where('id',$id)->update($data);
        \Phpcmf\Service::M('Log', 'Hd')->create_log($id,'结束活动:HD'.$id,'活动时间到了自动结束活动:HD'.$id,'系统');
        if($rt){
            return 1;
        }else{
            return 0;
        }
    }

    /**
     * @param $id
     * @return int
     * 复制活动
     */
    public function _copy_hd($id, $operator){
        \Phpcmf\Service::M('Log', 'Hd')->create_log($id,'复制活动:HD'.$id,'复制活动:HD'.$id,$operator);
        if($id){
            $rt = \Phpcmf\Service::M()->db->simpleQuery("insert into dr_1_hd_activity(uid,hd_id,name,hd_img,start_time,end_time,file,company_id) select uid,hd_id,name,hd_img,start_time,end_time,file,company_id from dr_1_hd_activity where id='".$id."'");

//
            $insert_id = \Phpcmf\Service::M()->db->insertID();

            if($rt){
                $this->_insert_data($insert_id);
                return 1;
            }else{
                return 0;
            }
        }
    }

    /**
     * @param $id
     * 检测下id
     */
    public function _check_id($id){
        $rt = \Phpcmf\Service::M()->db->table("1_hd_activity")->where("id", $id)->get();
        if($rt){
            //存在
            return 0;
        }else{
            //不存在
            return 1;
        }
    }

    /**
     * @param $id
     * 软删除
     */
    public function soft_delete_hd($id, $operator){
        $data = array(
            'delete_key' => '1',
            'edit_time' => time(),
        );
        $rt = \Phpcmf\Service::M()->db->table('1_hd_activity')->where('id',$id)->set($data)->update();
        \Phpcmf\Service::M('Log', 'Hd')->create_log($id,'移入回收站:HD'.$id,'移入回收站:HD'.$id,$operator);
        if($rt){
            return 1;
        }else{
            return 0;
        }
    }

    /**
     * @param $id
     * @return int
     * 真删除
     */
    public function _delete_hd($id, $operator){
        $arr = [];
         $rt = \Phpcmf\Service::M()->db->simpleQuery("DELETE FROM dr_1_hd_activity WHERE id = '".$id."'");
         if($rt){
             $arr[] = 1;
         }else{
             $arr[] = 0;
         }
         $rt1 = \Phpcmf\Service::M()->db->simpleQuery("DELETE FROM dr_1_hd_product WHERE hd_id = '".$id."'");

        \Phpcmf\Service::M('Log', 'Hd')->create_log($id,'删除活动:HD'.$id,'删除活动:HD'.$id,$operator);

         if($rt1){
             $arr[] = 1;
         }else{
             $arr[] = 0;
         }
//        print_r($arr);exit;
        return $this->_check_result($arr);
    }

    //恢复
    public function _restore($id, $operator){
        $data = array(
            'delete_key' => '0',
            'edit_time' => time(),
        );
        $rt = \Phpcmf\Service::M()->db->table('1_hd_activity')->where('id',$id)->set($data)->update();
        \Phpcmf\Service::M('Log', 'Hd')->create_log($id,'恢复:HD'.$id,'恢复活动:HD'.$id,$operator);
        if($rt){
            return 1;
        }else{
            return 0;
        }
    }

    //减奖品
    public function _minus($id){

        $rt = \Phpcmf\Service::M()->db->simpleQuery('update dr_1_hd_product set p_status=1 where hd_id="'.$id.'" and p_status=0 order by id desc limit 1 ');
        if($rt){
            return 1;
        }else{
            return 0;
        }
    }


    //加奖品
    public function _add_product($id){
        \Phpcmf\Service::M()->db->query('update dr_1_hd_product set p_status=0 where hd_id="'.$id.'" and p_status=1  limit 1 ');
        $rt = $this->db->simpleQuery('select * from dr_1_hd_product where p_status=0 and hd_id="'.$id.'"');

        return $num = $rt->num_rows;
    }


    /* *
     * 活动配置属性
     * */
    public function get_config($id) {
        if (!$id) {
            return [];
        }
        // 活动表
        $data = $this->table_site('hd_activity')->get($id);
        // 奖品表
        $product = $this->table_site('hd_product')->where('hd_id', $id)->getAll();
        if (!$product) {
            return []; // 没有设置奖品返回空
        }
        foreach ($product as $k =>$t) {

            if ($t['level_name'] && $t['level'] && $t['p_status'] == 0) {
                $data['product'][] = $t;
                $data['product'][$k]['period'] = json_decode($t['period']);
            }
        }

        // 参与人数统计
        $data['total_person'] = $this->table_site('hd_activity_list')->where('hd_id', $id)->counts();

        // 已经抽奖的次数
        $count = $this->table_site('hd_activity_list')->where('hd_id', $id)->where('user_id', \Phpcmf\Service::C()->weixin_id)->counts();

        // 我的抽奖机会
        $data['my_counts'] =  -1; // -1表示不限制

        // 有总数限制
        if ($data['total']) {

            if ( $count >= $data['total']) {
                $data['my_counts'] =  0;
            }
            $data['my_counts'] =  $data['total'] - $count;
        }
        // 每天限制
        if (!$data['my_counts'] && $data['day_total']) {

            $count = $this->table_site('hd_activity_list')->where('hd_id', $id)->where('DATEDIFF(from_unixtime(create_time),now())=0')->where('user_id', \Phpcmf\Service::C()->weixin_id)->counts();
            if ($count >= $data['day_total']) {
                $data['my_counts'] =  0;
            }
            $data['my_counts'] =  $data['day_total'] - $count;
        }
//        print_r($count);
        return $data;
    }

    //获取要发布的奖品
    public function _ajax_product($id){

        $rt = \Phpcmf\Service::M()->db->query('select * from dr_1_hd_product where p_status=0 and hd_id="'.$id.'"');

        $rows = $rt->getResultArray();
//        print_r($rows);exit;
        if($rows){
            return $rows;
        }else{
            return 0;
        }
    }


    //清除回收站
    public function _delete_all($operator){
        $db = \Phpcmf\Service::M()->db->table('1_hd_activity');
        $rt = $db->delete(array('delete_key' => 1));
        \Phpcmf\Service::M('Log', 'Hd')->create_log('','回收站','清空了回收站',$operator);
        if($rt){
            return 1;
        }else{
            return 0;
        }
    }

    //获取项目创建之前默认数据
    public  function get_default($id){

        $db = \Phpcmf\Service::M()->db->query('select * from dr_1_hd where  id="'.$id.'"');

        $product = $db->getResultArray();

        return $product;
    }

    public function add_user_num($hd_id){
//        print_r($hd_id);
//
        $product = $this->db->query('SELECT COUNT(DISTINCT user_id ) FROM dr_1_hd_activity_list WHERE hd_id="'.$hd_id.'"')->getResultArray();
//        print_r($product[0]['COUNT(DISTINCT user_id )']);
         $this->db->query('update dr_1_hd_activity set actual_person="'.$product[0]['COUNT(DISTINCT user_id )'].'" where  id="'.$hd_id.'"');
    }


}

