<?php namespace Phpcmf\Model;

// 付款
class Buy extends \Phpcmf\Model
{

    // 付款表单格式
    public function get_myfield() {

        return [
            'fieldtype' => 'Pay', // 字段类型
            'fieldname' => 'price',
            'setting' => [
                'option' => [
                    'payfile' => 'hd_buy.html', // 模板文件
                    'is_finecms' => 0, // 是否启用余额付款
                ],
            ]
        ];
    }

    // 付款类型名称
    public function paytype() {
        return  '<span class="label label-danger"> 活动</span>';
    }

    // 付款价格
    public function get_price($id) {

        $data = $this->table('1_hd_activity')->get($id);
        if ($data['price'] > 0) {
            return $data['price'];
        }
        return 200; // 留空 测试200
    }

    // 付款数据
    public function get_row($id) {

        $data = $this->table('1_hd_activity')->get($id);
        if (!$data) {
            return [];
        }

        return [
            'price' => $this->get_price($id),
            'title' => '升级《'.$data['name'].'》',
        ];
    }

    // 付款成功
    public function success($id, $data) {

        $this->table('1_hd_activity')->update($id, [
            'is_bay' => 1,
        ]);
    }
}