<?php namespace Phpcmf\Model;

// 基本配置模式
class Config extends \Phpcmf\Model
{
    /**
     * @param $id
     * @return mixed
     * 读取用户公司信息
     */
    public function getConfig($id){
        $config = \Phpcmf\Service::M()->db->table("config")->where("company_id",$id)->get();
        return $config->getResultArray();
    }

    public function setWeixinConfig($arr)
    {
        $id = $arr['cid'];//公司id
        $uid = $arr['uid'];//用户信息
        $key = $arr['key'];//key
        $secret = $arr['secret'];//secret
        $arr = array('key' => $key, 'secret' => $secret);
        $exist = \Phpcmf\Service::M()->db->table("config")
            ->where("company_id", $id)
            ->get();
        $exist = $exist->getResultArray();
        if (count($exist)) {//存在
            $config = \Phpcmf\Service::M()->db->table("config")
                ->where('id', $exist[0]['id'])
                ->update(['value' => json_encode($arr), 'name' => 'weixin', 'create_time' => time(), 'member_id' => $uid, 'company_id' => $id,'update_time'=>time()]);
            } else {
                $config = \Phpcmf\Service::M()->db->table("config")
                    ->insert(['value' => json_encode($arr), 'name' => 'weixin', 'create_time' => time(), 'member_id' => $uid, 'company_id' => $id]);
            }
            if ($config) {
                return '1';
            } else {
                return '0';
            }
        }

    /**
     * @param $uid
     * @return mixed|string
     * 通过公司id查询配置
     */
    public function getCompanyId($uid)
    {
        $config = \Phpcmf\Service::M()->db->table("member")->where("id",$uid)->get();
        if(count($config))
        {
            $config =  $config->getResultArray();
            $company = $this->getConfig($config[0]['company_id']);
            return $company;
        }else{
            return '0';
        }
    }

    /**
     * @param $hdid
     * @return mixed|string
     * 根据公司活动id查询公司id
     */
    public function getCompanyIdFromHdId($hdid){
        $config = \Phpcmf\Service::M()->db->table("1_hd_activity")->where("id",$hdid)->get();
//        print_r($config->getResultArray());
        if(count($config))
        {
            $config =  $config->getResultArray();
            $company = $this->getConfig($config[0]['company_id']);
            return $company;
        }else{
            return '0';
        }
    }
    /**
     * @param $uid
     * @return mixed|string
     */
    public function getToken($cid)
    {
        $token = \Phpcmf\Service::M()->db->table("config_token")->where("cid",$cid)
            ->where('expire_time > '.time())
            ->orderBy('id')
            ->get();
        if(count($token))
        {
            $token =  $token->getResultArray();
            return $token[0]['token'];
        }else{
            return '';
        }
    }

    /**
     * @param $uid
     * @return mixed|string
     */
    public function setToken($data)
    {
        $res = \Phpcmf\Service::M()->db->table("config_token")
            ->insert(array('token'=>$data['token'],'expire_time'=>$data['expire_time'],'create_time'=>time(),'cid'=>$data['cid']));
        return $res;
    }

    public function setUser($data){
        $exist =  \Phpcmf\Service::M()->db->table("1_hd_user")
            ->where('openid',$data['openid'])
            ->get();
        if(count($exist->getResultArray())){
            return $exist->getResultArray();
        } else {
            $res = \Phpcmf\Service::M()->db->table("1_hd_user")
                ->insert(array('openid' => $data['openid'], 'nick' => $data['nickname'], 'header_img' => $data['headimgurl'], 'sex' => $data['sex'], 'create_time' => time()));//值为1时是男性，值为2时是女性，值为0时是未知
            return $res;
        }
    }

    public function getUser($openid)
    {
        $exist =  \Phpcmf\Service::M()->db->table("1_hd_user")
            ->where('openid',$openid)
            ->get();
        return $exist->getResultArray();
    }


    public function getUserByPrize($prizeid)
    {
        $exist =  \Phpcmf\Service::M()->db->table("1_hd_winlist")
            ->where('id',$prizeid)
            ->get();
        $exist =  $exist->getResultArray();
        $user =  \Phpcmf\Service::M()->db->table("1_hd_user")
            ->where('id',$exist[0]['user_id'])
            ->get();
        return $user->getResultArray();
    }
    /**
     * @param $openid
     * @return mixed
     * 定位城市
     */
    public function getCityId($name)
    {
        $exist =  \Phpcmf\Service::M()->db->table("linkage_data_1")
            ->where('name',$name)
            ->get();
        return $exist->getResultArray();
    }
    /**
     * @param $url
     * @return mixed
     * 记录用户跳转记录
     */
    public function setRedirectUrl($url,$openid)
    {
        $res =  \Phpcmf\Service::M()->db->table("1_hd_redirect")
            ->insert(array('url'=>$url,'from_uid'=>$openid));
        if($res) {
            $res = \Phpcmf\Service::M()->db->table("1_hd_redirect")
                ->where('url', $url)
                ->orderBy('id','desc')
                ->get();
        }
        return $res->getResultArray();
    }
    /**
     * @param $url
     * @return mixed
     * 获取用户跳转记录
     */
    public function getRedirectUrl($id)
    {
        $res =  \Phpcmf\Service::M()->db->table("1_hd_redirect")
            ->where('id',$id)
            ->get();
        return $res->getResultArray();
    }


    //前端权限判断
    public function _auth_view($auth, $num, $view) {
//        print_r($auth);
        if( $auth[0]['game_access'] == 1){

            \Phpcmf\Service::V()->display($view);
        }elseif($auth[0]['game_access'] == 4){
            dr_redirect('/index.php?s=member');
        }else{

            if(in_array($num,$auth[0]['rule_id'])){
                \Phpcmf\Service::V()->display($view);
            }else{
                dr_redirect('/index.php?s=member');
            }
        }
    }

    //编辑 发布 等等方法的权限
    public  function auth_func($auth, $num){
//        print_r($auth[0]['game_access']);
        if( $auth[0]['game_access'] == 1){
            return 1;
        }elseif($auth[0]['game_access'] == 4){
            return 0;
        }else{
            if(in_array($num,$auth[0]['rule_id'])){
                return 1;
            }else{
                return 0;
            }
        }
    }

    //返回省市区数据
    public function get_province(){
        $res = \Phpcmf\Service::L('cache')->get('get_province');
        if(!$res){
            $link = \Phpcmf\Service::M()->db->table("linkage_data_1")->get();
            $data = $link->getResultArray();
            //TODO::
            foreach($data as $item){
                $value = [];
                $value = [$item['name'],$item['cname']];
                $id = '';
                $id = $item['id'];
                $area[$id] = $value;
            }
            $res = \Phpcmf\Service::L('cache')->set_file('get_province', $area);
        }
       return $res;
    }

    //返回地区数据
    public function get_region(){
        $res = \Phpcmf\Service::L('cache')->get('get_region');
        if(!$res){
            $link = \Phpcmf\Service::M()->db->table("linkage_data_1")->where('pid',0)->get();
            $data = $link->getResultArray();
            $area = array();
            foreach($data as $k=>$item){
                /*$pids = $item['childids'];
                $pids_arr = explode(',',$pids);
                array_shift($pids_arr);
                $area[$item[id]]=$pids_arr;*/

                $id = $item['id'];
                $info = \Phpcmf\Service::M()->db->table("linkage_data_1")->where('pid',$id)->get()->getResultArray();
                $arr = array();
                foreach($info as $val){
                    $arr[] =  $val['id'];
                }
                $area[$item[id]]=$arr;
            }
            $res = \Phpcmf\Service::L('cache')->set_file('get_region', $area);
        }
        return $res;
    }

//    返回省份
    public function get_provinces(){
        $res = \Phpcmf\Service::L('cache')->get('get_provinces');
        if(!$res) {
            $link = \Phpcmf\Service::M()->db->table("linkage_data_1")->where('pid', 0)->get();
            $data = $link->getResultArray();
            foreach ($data as $item) {
                $area[] = $item['id'];
            }
            $res = \Phpcmf\Service::L('cache')->set_file('get_provinces', $area);
        }
        return $res;
    }

    //返回非顶级地区
    public function get_district(){
//        $link = \Phpcmf\Service::M()->db->table("linkage_data_1")->where('pid',0)->get();
        $res = \Phpcmf\Service::L('cache')->get('get_district');
        if(!$res) {
            $link = \Phpcmf\Service::M()->db->query("select * from dr_linkage_data_1 where pid != 0");
            $data = $link->getResultArray();
            foreach ($data as $item) {
                $area[] = $item['id'];
            }
            $res = \Phpcmf\Service::L('cache')->set_file('get_district', $area);
        }
        return $res;
    }

    //回调城市名称
    public function get_city_name($arr_val){
        $name = '';
        if(is_array($arr_val)){
            foreach($arr_val as $item){
                $arr_name = \Phpcmf\Service::M()->db->query("select name from dr_linkage_data_1 where id='".$item."'")->getResultArray();
                $name .= '-'.$arr_name[0]['name'];
            }

        }else{
            return 0;
        }
        $name = trim($name,'-');
        return $name;
    }

    /**
     * 对用户次数添加：删除一条未中奖的记录
     */
    public function setTimes($hd_id,$user_id)
    {
        $config = \Phpcmf\Service::M()->db->query("select name from dr_1_hd_activity_list where user_id= $user_id and hd_id = $hd_id and pid = 0 and create_time > ". strtotime(date('Y-m-d',time())) ." limit 1 ")->getResultArray();
        if($config)
        {
            \Phpcmf\Service::M()->db->table('1_hd_activity_list')->delete('id',$config[0]['id']);
        }


    }

    /**
     * 获奖用户的地址添加
     */
    public function setAddress($hd_id,$prize_id,$data)
    {
        \Phpcmf\Service::M()->db->table('1_hd_winlist')
            ->where('id', $prize_id)
            ->update($data);

    }

    /**
     * 分享次数的设置
     */
    public function setShareTimes($data)
    {
        //TODO::查询活动分享次数设置
        $activity = \Phpcmf\Service::M()->db->query("SELECT * FROM `dr_1_hd_activity` WHERE `id`='".$data['hd_id']."'");

        if($activity)
        {
            $res = $activity->getResultArray();
            if($res[0]['help'] == 1)
            {//TODO::存在分享奖励条件
                $time = \Phpcmf\Service::M()->db->table("1_hd_share_list")
                    ->where('uid',$data['uid'])
                    ->where('hd_id',$data['hd_id'])
                    ->where('create_time >',strtotime(date('Y-m-d',time())))
                    ->get();
                $r = $time->getResultArray();
                if(count($r)) {//符合分享奖励条件
                    if (count($r) < $res[0]['help_number'])
                    {
                        //TODO::添加分享记录
                        $data['prize_number'] = 1;
                        \Phpcmf\Service::M()->db->table('1_hd_share_list')
                            ->insert($data);
                        //当天:次数记录
                        $exist = \Phpcmf\Service::M()->db->table("1_hd_activity_times")
                            ->where('uid',$data['uid'])
                            ->where('hd_id',$data['hd_id'])
                            ->where('create_time >',strtotime(date('Y-m-d',time())))
                            ->get();
                        $exist = $exist->getResultArray();
                        //TODO::次数+1
                        $res = \Phpcmf\Service::M()->db->table('1_hd_activity_times')
                            ->where('id',$exist[0]['id'])
                            ->update(['times'=>count($r)+1,'update_time'=>time()]);
                    }
                    else{//分享奖励达到上限
                        \Phpcmf\Service::M()->db->table('1_hd_share_list')
                            ->insert($data);
                        $i = \Phpcmf\Service::M()->db->insertID();
                    }
                }else{
                    //TODO::添加分享记录
                    $data['prize_number'] = 1;
                   \Phpcmf\Service::M()->db->table('1_hd_share_list')
                        ->insert($data);
                    $i = \Phpcmf\Service::M()->db->insertID();

                   \Phpcmf\Service::M()->db->table('1_hd_activity_times')
                        ->insert(['uid'=>$data['uid'],'hd_id'=>$data['hd_id'],'times'=>1,'create_time'=>time()]);
                    $id = \Phpcmf\Service::M()->db->insertID();
                }
            }
        }
        return 'yes';
    }
}