<?php namespace Phpcmf\Controllers\Admin;

class Form extends \Phpcmf\Common
{

	private $form; // 表单验证配置

	public function __construct(...$params) {
		parent::__construct(...$params);
		\Phpcmf\Service::V()->assign('menu', \Phpcmf\Service::M('auth')->_admin_menu(
			[
				'网站表单' => ['form/index', 'fa fa-table'],
				'添加' => ['add:form/add', 'fa fa-plus', '500px', '310px'],
				'导入' => ['add:form/import_add', 'fa fa-sign-in', '60%', '70%'],
				'重建表单' => ['ajax:form/init_index', 'fa fa-refresh'],
				'修改' => ['hide:form/edit', 'fa fa-edit'],
                'help' => [54],
			]
		));
		// 表单验证配置
		$this->form = [
			'name' => [
				'name' => '表单名称',
				'rule' => [
					'empty' => dr_lang('表单名称不能为空')
				],
				'filter' => [],
				'length' => '200'
			],
			'table' => [
				'name' => '数据表名称',
				'rule' => [
					'empty' => dr_lang('数据表名称不能为空'),
					'table' => dr_lang('数据表名称格式不正确'),
				],
				'filter' => [],
				'length' => '200'
			],
		];
	}

	public function index() {

		\Phpcmf\Service::V()->assign([
			'list' => \Phpcmf\Service::M('Form')->getAll(),
		]);
		\Phpcmf\Service::V()->display('form_list.html');
	}

	public function init_index() {

		$data = \Phpcmf\Service::M('Form')->getAll();
		!$data && $this->_json(0, dr_lang('没有任何可用表单'));

		$ok = 0;
		foreach ($data as $t) {
			$rt = \Phpcmf\Service::M('Form')->create_file($t['table'], 1);
			!$rt['code'] && $this->_json(0, $rt['msg']);
			$ok+= (int)$rt['msg'];
		}

		$this->_json(1, dr_lang('重建表单（%s）个', $ok));
	}


	public function add() {

		if (IS_AJAX_POST) {
			$data = \Phpcmf\Service::L('Input')->post('data', true);
			$this->_validation(0, $data);
			\Phpcmf\Service::L('Input')->system_log('创建网站表单('.$data['name'].')');
			$rt = \Phpcmf\Service::M('Form')->create($data);
			!$rt['code'] && $this->_json(0, $rt['msg']);
			exit($this->_json(1, dr_lang('操作成功')));
		}

		\Phpcmf\Service::V()->assign([
			'form' => dr_form_hidden()
		]);
		\Phpcmf\Service::V()->display('form_add.html');
		exit;
	}

	public function edit() {

		$id = intval(\Phpcmf\Service::L('Input')->get('id'));
		$data = \Phpcmf\Service::M('Form')->get($id);
		!$data && $this->_admin_msg(0, dr_lang('网站表单（%s）不存在', $id));
		$data['setting'] = dr_string2array($data['setting']);
		!$data['setting']['list_field'] && $data['setting']['list_field'] = [
			'title' => [
				'use' => 1,
				'name' => dr_lang('主题'),
				'func' => 'title',
				'width' => 0,
				'order' => 1,
			],
			'author' => [
				'use' => 1,
				'name' => dr_lang('作者'),
				'func' => 'author',
				'width' => 100,
				'order' => 2,
			],
			'inputtime' => [
				'use' => 1,
				'name' => dr_lang('录入时间'),
				'func' => 'datetime',
				'width' => 160,
				'order' => 3,
			],
		];

		if (IS_AJAX_POST) {
			$data = \Phpcmf\Service::L('Input')->post('data', true);
			\Phpcmf\Service::M('Form')->update($id,
				[
					'name' => $data['name'],
					'setting' => dr_array2string($data['setting'])
				]
			);
			\Phpcmf\Service::L('Input')->system_log('修改网站表单('.$data['name'].')配置');
			exit($this->_json(1, dr_lang('操作成功')));
		}

		// 主表字段
		$field = \Phpcmf\Service::M()->db->table('field')
						->where('disabled', 0)
						->where('ismain', 1)
						->where('relatedname', 'form-'.SITE_ID)
						->where('relatedid', $id)
						->orderBy('displayorder ASC,id ASC')
						->get()->getResultArray();
		$sys_field = \Phpcmf\Service::L('field')->sys_field(['author', 'inputtime']);
		sort($sys_field);
        $page = intval(\Phpcmf\Service::L('Input')->get('page'));

		\Phpcmf\Service::V()->assign([
			'data' => $data,
			'page' => $page,
			'form' => dr_form_hidden(['page' => $page]),
			'field' => dr_array2array($sys_field, $field),
		]);
		\Phpcmf\Service::V()->display('form_edit.html');
	}

	public function del() {

		$ids = \Phpcmf\Service::L('Input')->get_post_ids();
		!$ids && exit($this->_json(0, dr_lang('你还没有选择呢')));

		$rt = \Phpcmf\Service::M('Form')->delete_form($ids);
		!$rt['code'] && exit($this->_json(0, $rt['msg']));

		\Phpcmf\Service::L('Input')->system_log('批量删除网站表单: '. @implode(',', $ids));

		exit($this->_json(1, dr_lang('操作成功'), ['ids' => $ids]));
	}

	// 验证数据
	private function _validation($id, $data) {

		list($data, $return) = \Phpcmf\Service::L('form')->validation($data, $this->form);
		$return && exit($this->_json(0, $return['error'], ['field' => $return['name']]));
		\Phpcmf\Service::M('Form')->table('form')->is_exists($id, 'table', $data['table']) && exit($this->_json(0, dr_lang('数据表名称已经存在'), ['field' => 'table']));
	}

	// 导出
    public function export() {

        $id = intval(\Phpcmf\Service::L('Input')->get('id'));
        $data = \Phpcmf\Service::M('Form')->get($id);
        !$data && $this->_admin_msg(0, dr_lang('网站表单（%s）不存在', $id));

        // 字段
        $data['field'] = \Phpcmf\Service::M()->db->table('field')->where('relatedname', 'form-'.SITE_ID)->where('relatedid', $id)->orderBy('displayorder ASC,id ASC')->get()->getResultArray();

        $data['setting'] = dr_string2array($data['setting']);

        // 数据结构
        $data['sql'] = '';

        $table = \Phpcmf\Service::M()->dbprefix(SITE_ID.'_form_'.$data['table']);
        $sql = \Phpcmf\Service::M()->db->query("SHOW CREATE TABLE `".$table."`")->getRowArray();
        $sql = 'DROP TABLE IF EXISTS `'.$table.'`;'.PHP_EOL.str_replace('CREATE TABLE', 'CREATE TABLE IF NOT EXISTS', $sql['Create Table']).';';
        $data['sql'].= str_replace($table, '{table}', $sql).PHP_EOL;

        $table = \Phpcmf\Service::M()->dbprefix(SITE_ID.'_form_'.$data['table'].'_data_0');
        $sql = \Phpcmf\Service::M()->db->query("SHOW CREATE TABLE `".$table."`")->getRowArray();
        $sql = 'DROP TABLE IF EXISTS `'.$table.'`;'.PHP_EOL.str_replace('CREATE TABLE', 'CREATE TABLE IF NOT EXISTS', $sql['Create Table']).';';
        $data['sql'].= str_replace($table, '{table}_data_0', $sql).PHP_EOL;

        \Phpcmf\Service::V()->assign([
            'data' => dr_array2string($data),
        ]);
        \Phpcmf\Service::V()->display('form_export.html');exit;
    }

    // 导入
    public function import_add() {

        if (IS_AJAX_POST) {
            $data = \Phpcmf\Service::L('Input')->post('code', true);
            $data = dr_string2array($data);
            if (!is_array($data)) {
                $this->_json(0, dr_lang('导入信息验证失败'));
            } elseif (!$data['table']) {
                $this->_json(0, dr_lang('导入信息不完整'));
            } elseif (!$data['field']) {
                $this->_json(0, dr_lang('字段信息不完整'));
            } elseif (!$data['sql']) {
                $this->_json(0, dr_lang('数据结构不完整'));
            }
            $rt = \Phpcmf\Service::M('Form')->import($data);
            !$rt['code'] && $this->_json(0, $rt['msg']);
            \Phpcmf\Service::L('Input')->system_log('导入网站表单('.$data['name'].')');
            exit($this->_json(1, dr_lang('操作成功')));
        }

        \Phpcmf\Service::V()->assign([
            'form' => dr_form_hidden()
        ]);
        \Phpcmf\Service::V()->display('form_import.html');
        exit;
    }

}
