<?php namespace Phpcmf\Controllers\Admin;

// 提醒
class Member_notice extends \Phpcmf\Table
{

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        \Phpcmf\Service::V()->assign('menu', \Phpcmf\Service::M('auth')->_admin_menu(
            [
                '提醒消息' => ['member_notice/index', 'fa fa-bell'],
                '发送消息' => ['member_notice/add', 'fa fa-plus'],
            ]
        ));
        // 表单显示名称
        $this->name = dr_lang('消息提醒');
    }

    public function index() {

        $this->my_field = array(
            'username' => array(
                'ismain' => 1,
                'name' => dr_lang('用户名'),
                'fieldname' => 'username',
            ),
            'uid' => array(
                'ismain' => 1,
                'name' => dr_lang('uid'),
                'fieldname' => 'uid',
                'fieldtype' => 'Text',
                'setting' => array(
                    'option' => array(
                        'width' => 200,
                    ),
                )
            ),
        );

        $param = [
            'table' => 'member_notice',
            'field' => $this->my_field,
        ];
        $name = dr_safe_replace(\Phpcmf\Service::L('Input')->request('field'));
        $value = dr_safe_replace(\Phpcmf\Service::L('Input')->request('keyword'));
        if ($name == 'username' && $value) {
            unset($param['field']['username']);
            $param['where_list'] = '`uid` IN (select id from `'.\Phpcmf\Service::M()->dbprefix('member').'` where username="'.$value.'")';
        }

        // 初始化数据表
        $this->_init($param);
        \Phpcmf\Service::V()->assign([
            'type' => dr_notice_info(),
            'field' => $this->my_field,
        ]);
        $this->_List();
        \Phpcmf\Service::V()->display('member_notice_list.html');
    }

    // 删除
    public function del() {
        // 初始化数据表
        $this->_init([
            'table' => 'member_notice',
        ]);
        $this->_Del(\Phpcmf\Service::L('Input')->get_post_ids());
    }

    // 发送
    public function add() {


        if (IS_AJAX_POST) {
            $post = \Phpcmf\Service::L('Input')->post('data');
            $user = \Phpcmf\Service::M()->db->table('member')->where('username', $post['username'])->get()->getRowArray();
            if (!$user) {
                $this->_json(0, dr_lang('账号[%s]不存在', $post['username']), ['field' => 'username']);
            } elseif (!$post['note']) {
                $this->_json(0, dr_lang('提醒内容未填写'), ['field' => 'note']);
            }
            \Phpcmf\Service::M('member')->notice($user['id'], 1, $post['note'], $post['url']);
            $this->_json(1, dr_lang('操作成功'));
        }

        $fdata = \Phpcmf\Service::L('field')->sys_field(['username']);
        $fdata['username']['name'] = dr_lang('用户账号');

        \Phpcmf\Service::V()->assign([
            'form' => dr_form_hidden(),
            'myfield' => \Phpcmf\Service::L('field')->toform(0, $fdata),
        ]);
        \Phpcmf\Service::V()->display('member_notice_post.html');
    }

    
}
