<?php namespace Phpcmf\Controllers\Admin;

class Member_setting_notice extends \Phpcmf\Common
{

    public function index() {

        $local = dr_dir_map(APPSPATH, 1);
        $notice['member'] = [
            'value' => require CMSPATH.'Config/Notice.php',
        ];

        if (is_file(MYPATH.'Config/Notice.php')) {
            $notice['my'] = [
                'value' => require MYPATH.'Config/Notice.php',
            ];
        }

        foreach ($local as $dir) {
            if (is_file(APPSPATH.$dir.'/Config/Notice.php')
                && is_file(APPSPATH.$dir.'/Config/App.php')) {
                $app = require APPSPATH.$dir.'/Config/App.php';
                $cfg = require APPSPATH.$dir.'/Config/Notice.php';
                $app && $cfg && $notice[strtolower($dir)] = [
                    'name' => $app['name'],
                    'value' => $cfg
                ];
            }
        }

        $data = \Phpcmf\Service::M()->db->table('member_setting')->where('name', 'notice')->get()->getRowArray();

        \Phpcmf\Service::V()->assign([
            'menu' => \Phpcmf\Service::M('auth')->_admin_menu(
                [
                    '通知设置' => ['member_setting_notice/index', 'fa fa-volume-up'],
                ]
            ),
            'value' => dr_string2array($data['value']),
            'notice_config' => $notice,
        ]);
        \Phpcmf\Service::V()->display('member_setting_notice.html');
    }

    // 保存配置
    public function add() {

        if (IS_AJAX_POST) {
            \Phpcmf\Service::M()->db->table('member_setting')->replace([
                'name' => 'notice',
                'value' => dr_array2string(\Phpcmf\Service::L('input')->post('data', true))
            ]);
            $this->_json(1, dr_lang('操作成功'));
        } else {
            $this->_json(0, dr_lang('异常请求'));
        }
    }

    // 修改模板
    public function edit() {

        $file = dr_safe_filename($_GET['file']);
        $list = [];
        foreach ($this->site_info as $sid => $t) {
            $path = \Phpcmf\Service::L('html')->get_webpath($sid, 'site', '');
            $list[$sid] = [
                'name' => $t['SITE_NAME'],
                'data' => [
                    'mobile' => [
                        'name' => dr_lang('短信和消息'),
                        'code' => htmlentities(file_get_contents($path.'config/notice/mobile/'.$file.'.html'),ENT_COMPAT,'UTF-8'),
                        'file' => $path.'config/notice/mobile/'.$file.'.html',
                        'height' => '60',
                    ],
                    'email' => [
                        'name' => dr_lang('邮件'),
                        'code' => htmlentities(file_get_contents($path.'config/notice/email/'.$file.'.html'),ENT_COMPAT,'UTF-8'),
                        'file' => $path.'config/notice/email/'.$file.'.html',
                        'height' => '400',
                    ],
                    'weixin' => [
                        'name' => dr_lang('微信'),
                        'code' => htmlentities(file_get_contents($path.'config/notice/weixin/'.$file.'.html'),ENT_COMPAT,'UTF-8'),
                        'file' => $path.'config/notice/weixin/'.$file.'.html',
                        'height' => '250',
                    ],
                ]
            ];
        }

        if (IS_POST) {

            $post = \Phpcmf\Service::L('input')->post('data', true);
            foreach ($list as $sid => $t) {
                foreach ($t['data'] as $id => $m) {
                    dr_mkdirs(dirname($m['file']).'/');
                    $code = (string)$post[$sid][$id];
                    $size = file_put_contents($m['file'], $code);
                    $size === false && $this->_json(0, dr_lang('无法写入文件[%s]', $m['file']));
                }
            }

            $this->_json(1, dr_lang('操作成功'));
        }


        \Phpcmf\Service::V()->assign([
            'list' => $list,
        ]);
        \Phpcmf\Service::V()->display('member_setting_notice_edit.html');exit;
    }

}
