<?php namespace Phpcmf\Controllers\Admin;

class Module_comment extends \Phpcmf\Common
{
	public function index() {

        $module = \Phpcmf\Service::M('Module')->get_module_info();

        if (IS_AJAX_POST) {

            $data = \Phpcmf\Service::L('Input')->post('data');
            foreach ($data as $dir => $t) {
                $module[$dir]['comment'] = $t;
                \Phpcmf\Service::M()->db->table('module')->where('dirname', $dir)->update([
                    'comment' => dr_array2string($module[$dir]['comment']),
                ]);
            }

            $this->_json(1, dr_lang('操作成功'));
        }

        $page = \Phpcmf\Service::L('Input')->get('page');
        if ($module) {
            if (!$page) {
                $one = reset($module);
                $page = $one['dirname'];
            }
            foreach ($module as $dir => $t) {
                if (!isset($t['comment']['review'])) {
                    // 默认点评
                    $module[$dir]['comment']['review']['use'] = 0;
                    $module[$dir]['comment']['review']['score'] = 10;
                    $module[$dir]['comment']['review']['option'] = [];
                    // 点评选项
                    for ($i = 1; $i <= 9; $i++) {
                        $module[$dir]['comment']['review']['option'][$i] = [
                            'use' => 0,
                            'name' => '选项'.$i,
                        ];
                    }
                    // 点评值
                    for ($i = 1; $i <= 5; $i++) {
                        $module[$dir]['comment']['review']['value'][$i] = [
                            'use' => 0,
                            'name' => $i.'星评价',
                        ];
                    }
                }
            }
        }


        \Phpcmf\Service::V()->assign([
            'menu' => \Phpcmf\Service::M('auth')->_admin_menu(
                [
                    '评论设置' => [\Phpcmf\Service::L('Router')->class.'/index', 'fa fa-comment'],
                ]
            ),
            'page' => $page,
            'form' => dr_form_hidden(['page' => $page]),
            'module' => $module
        ]);
        \Phpcmf\Service::V()->display('module_comment.html');
	}

}
