<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/5/8
 * Time: 9:25
 */

namespace Phpcmf\Controllers\Admin;
/**
 * Class option
 * @package Phpcmf\Controllers\Admin
 * 权限自定义功能类
 */

class Option extends \Phpcmf\Common
{
    /**
     * Product constructor.
     * @param array ...$params
     * 构造函数
     */
    public function __construct(...$params)
    {
        parent::__construct(...$params);
    }
    /**
     * 选项列表
     */
    public function index()
    {
        $list =  \Phpcmf\Service::M()->db->table("member_product_options")
            ->where('pid >',0)
            ->where('status',1)
            ->get();
        $exist = $list->getResultArray();
        if($exist) {
            foreach($exist as &$item){
                if($item['pid'])
                {
                    $option = \Phpcmf\Service::M()->db->table("member_product_options")
                        ->where('id',$item['pid'])
                        ->get();
                    $option = $option->getResultArray();
                    $item['p_name'] = $option[0]['option_name'];
                }else{
                    $item['p_name'] = '无';
                }
            }
            \Phpcmf\Service::V()->assign([
                'data' => $exist
            ]);
        }
        \Phpcmf\Service::V()->display('option_index.html');
    }

    /**
     * 添加选项
     */
    public function add()
    {
        $list =  \Phpcmf\Service::M()->db->table("member_product_options")
            ->where("pid", 0)
            ->get();
        $exist = $list->getResultArray();
        if($exist) {
            \Phpcmf\Service::V()->assign([
                'data' => $exist
            ]);
        }
        //编辑
        if($_GET['id']) {
            $option = \Phpcmf\Service::M()->db->table("member_product_options")
                ->where("id", $_GET['id'])
                ->get();
            $option = $option->getResultArray();
            if ($exist) {
                \Phpcmf\Service::V()->assign([
                    'option' => $option[0]
                ]);
            }
        }
        \Phpcmf\Service::V()->display('option_add.html');
    }

    /**
     * 选项保存
     */
    public function save()
    {
        if (IS_AJAX_POST) {
            /*检查该产品是否存在*/
            $data = \Phpcmf\Service::L('Input')->post('data');
            $exist = \Phpcmf\Service::M()->db->table("member_product_options")
                ->where("option_name", $data['option_name'])
                ->get();
            $exist = $exist->getResultArray();
            if($exist[0]) {
                //已存在
                exit($this->_json(0, dr_lang('已经存在')));
            }else{
                //保存数据
                $res = \Phpcmf\Service::M()->db->table("member_product_options")
                    ->insert($data);
                $i = \Phpcmf\Service::M()->db->insertID();
                if($i)
                {
                    exit($this->_json(1, dr_lang('操作成功')));
                }else{
                    exit($this->_json(0, dr_lang('操作失败')));
                }
            }
        }
    }

    /**
     * 删除会员授权类型
     */
    public function delete(){
        $id = $_GET['id'];
        $option = \Phpcmf\Service::M()->db->table("member_product_options")
            ->where('id',$id)
            ->update(['status'=>0]);
        exit($this->_json(1, dr_lang('操作成功')));
    }
}