<?php namespace Phpcmf\Controllers\Admin;
/**
 * Class Product
 * @package Phpcmf\Controllers\Admin
 * 系统产品配置控制器
 */
class Product extends \Phpcmf\Common
{
    /**
     * Product constructor.
     * @param array ...$params
     * 构造函数
     */
    public function __construct(...$params)
    {
        parent::__construct(...$params);
    }

    /**
     * 会员产品列表
     */
    public function index()
    {
        $config = \Phpcmf\Service::M()->db->table("member_product")->where("status",1)->get();
        $data =  $config->getResultArray();
        if($data){
            foreach($data as &$item)
            {
                $option = \Phpcmf\Service::M()->db->table("member_product_options")
                    ->where('id',$item['option_id'])
                    ->get();
                $option =  $option->getResultArray();
                $item['option_name'] = $option[0]['option_name'];
            }
        }
        \Phpcmf\Service::V()->assign([
            'data'=>$data
        ]);

        \Phpcmf\Service::V()->display('product_index.html');
    }

    /**
     * 会员产品新增
     */
    public function add()
    {
        $id = \Phpcmf\Service::L('Input')->get('id');
        $info =  \Phpcmf\Service::M()->db->table("member_product")
            ->where("status",1)
            ->where("id", $id)
            ->get();
        $exist = $info->getResultArray();
        if($exist) {
            \Phpcmf\Service::V()->assign([
                'data' => $exist[0]
            ]);
        }
        //查询功能选项分类
        $option = \Phpcmf\Service::M()->db->table("member_product_options")
            ->where('pid',0)
            ->get();
        $option = $option->getResultArray();
        if($option){
            \Phpcmf\Service::V()->assign([
                'option' => $option
            ]);
        }
        \Phpcmf\Service::V()->display('product_add.html');
    }

    /**
     * 产品添加：保存
     */
    public function save()
    {

        if (IS_AJAX_POST) {
            /*检查该产品是否存在*/
            $data = \Phpcmf\Service::L('Input')->post('data');
            if($data['role_details']) {
                $data['role_details'] = implode(',', $data['role_details']);
            }
            $exist = \Phpcmf\Service::M()->db->table("member_product")
                ->where("status",1)
                ->where("p_name", $data['p_name'])
                ->get();
            $exist = $exist->getResultArray();
            if($exist[0]) {
                if($data['id']){
                    //修改
                    $id = $data['id'];
                    unset($data['id']);
                    $option = \Phpcmf\Service::M()->db->table("member_product")
                        ->where('id',$id)
                        ->update($data);
                    exit($this->_json(1, dr_lang('操作成功')));
                }else {
                    //已存在
                    exit($this->_json(0, dr_lang('已经存在')));
                }
            }else{
                //保存数据
                $res = \Phpcmf\Service::M()->db->table("member_product")
                    ->insert($data);
                $i = \Phpcmf\Service::M()->db->insertID();
                if($i)
                {
                    exit($this->_json(1, dr_lang('操作成功')));
                }else{
                    exit($this->_json(0, dr_lang('操作失败')));
                }
            }
        }
    }

    /**
     * 异步读取会员等级权限数据
     */
    public function getRoleOptions(){
        $id = $_GET['id'];
        $option = \Phpcmf\Service::M()->db->table("member_product_options")
            ->where('pid',$id)
            ->get();
        $option = $option->getResultArray();
        if(count($option)){
            exit($this->_json(1, dr_lang('操作成功'),[$option]));
        }else{
            exit($this->_json(1, dr_lang('操作成功'),[]));
        }

    }

    /**
     * 删除会员授权类型
     */
    public function delete(){
        $id = $_GET['id'];
        $option = \Phpcmf\Service::M()->db->table("member_product")
            ->where('id',$id)
            ->update(['status'=>0]);
        exit($this->_json(1, dr_lang('操作成功')));
    }
}