<?php namespace Phpcmf\Controllers\Api;
class Weixin extends \Phpcmf\Common
{
    public $infoUrl = '';
    protected function https_request($url, $data = null)
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        if (!empty($data)){
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        }
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($curl);
        curl_close($curl);
        return $output;
    }

    private function checkSignature()
    {
        // you must define TOKEN by yourself
        // if (!defined("TOKEN")) {
        //  throw new Exception('TOKEN is not defined!');
        // }
        $signature = $_GET["signature"];
        $timestamp = $_GET["timestamp"];
        $nonce = $_GET["nonce"];
        $token = 'TOKEN';
        $tmpArr = array($token, $timestamp, $nonce);
        // use SORT_STRING rule
        sort($tmpArr, SORT_STRING);
        $tmpStr = implode( $tmpArr );
        $tmpStr = sha1( $tmpStr );
        if( $tmpStr == $signature ){
            return true;
        }else{
            return false;
        }
    }

    public function valid()
    {
        $echoStr = $_GET["echostr"];
//        var_dump(__DIR__);
        //valid signature , option
//        file_put_contents(__DIR__.'/log.txt',count($_GET),FILE_APPEND );//
        file_put_contents(__DIR__.'/log.txt','-1-',FILE_APPEND );//
        if($this->checkSignature()&&$echoStr)
        {//配置url
            header('content-type:text');
            file_put_contents(__DIR__.'/log.txt',$echoStr,FILE_APPEND );//
            echo  $echoStr;
            exit;
        }
        else
        {//关注，事件
            file_put_contents(__DIR__.'/log.txt','-2-',FILE_APPEND );//log
            $this->responseMsg();
        }
    }

    public function responseMsg()
    {
        //get post data, May be due to the different environments
        $postArr = file_get_contents("php://input");
        if(!empty($postArr)){
            $postObj = simplexml_load_string($postArr, 'SimpleXMLElement', LIBXML_NOCDATA);
            file_put_contents(__DIR__.'/log.txt',$postObj,FILE_APPEND );//log
            if( strtolower( $postObj->MsgType) == 'event')
            {
                //如果是关注 subscribe 事件
                if( strtolower($postObj->Event) == 'subscribe')
                {
                    /*用户信息记录*/
                    // $key = C('APPKEY');
                    // $secret = C('APPSECRET');
                    // $token = $this->getLocalToken();
                    //file_put_contents(APP_PATH.'Home/Controller/log.txt','-token:'.$token.'---',FILE_APPEND );//log
                    $openId = $postObj->FromUserName;
                    // $this->updateUser($openId,$token);
                    //回复用户消息(纯文本格式)
                    $toUser   = $postObj->FromUserName;
                    $fromUser = $postObj->ToUserName;
                    $time     = time();
                    $msgType  =  'text';
                    $content  = "欢迎关注!";
                    $template = "<xml><ToUserName><![CDATA[%s]]></ToUserName>
										<FromUserName><![CDATA[%s]]></FromUserName>
										<CreateTime>%s</CreateTime>
										<MsgType><![CDATA[%s]]></MsgType>
										<Content><![CDATA[%s]]></Content></xml>";
                    echo sprintf($template, $toUser, $fromUser, $time, $msgType, $content);
                }
                elseif(strtolower($postObj->Event) == 'unsubscribe')
                {
                    $openId = $postObj->FromUserName;
                    // M('user')->where(" openid = '{$openId}' ")->save(array('status'=>0));
                }
                else
                {
//                    if($postObj->EventKey == 'help'){
//                        $content = "发烧友请回复［单机］，查看最新单机大作。\n\n剁手党请回复［steam］,查看G胖最新动态。\n\n技术宅请回复［硬件］,查看游戏相关硬件资讯。";
//                    }else{
//                        $content = "小编正在努力策划ing.....";
//                    }
                    $content = '1111';
                    $template = "<xml>
					 				<ToUserName><![CDATA[%s]]></ToUserName>
					 				<FromUserName><![CDATA[%s]]></FromUserName>
					 				<CreateTime>%s</CreateTime>
					 				<MsgType><![CDATA[%s]]></MsgType>
					 				<Content><![CDATA[%s]]></Content>
					 				</xml>";
                    $fromUser = $postObj->ToUserName;
                    $toUser   = $postObj->FromUserName;
                    $time = time();
                    $msgType = 'text';
                    echo sprintf($template,$toUser,$fromUser,$time,$msgType,$content);
                }
            }
        }
    }

    /**
     * @param $APPID
     * @param $APPSECRET
     * @return mixed
     * 获取token
     */
    public function getToken($key,$secret){
        $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=$key&secret=".$secret;
        $res = json_decode($this->https_request($url),true);
        $token = $res['access_token'];
        return $token;
    }

    /**
     *'APPKEY' => 'wx448afadf55692eba',
     *'APPSECRET' => 'eb03d8cb616c23c11a9bb9c43aac6c97',
     */
    /**
     * @param $token
     * @param $openid
     * @return string
     * 获取用户信息
     */
    public function getInfo($token,$openId){
        $url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=".$token."&openid=".$openId."&lang=zh_CN";
        $res = json_decode($this->https_request($url),true);
//        file_put_contents(APP_PATH.'Home/Controller/log.txt','-info-+:'.json_encode($this->https_request($url)).'++',FILE_APPEND );
        return $res;
    }


    public function checkAuth(){
        $cid = (int)$_GET['cid'];
        $urlId = (int)$_GET['url'];
        $info = \Phpcmf\Service::M('Config', 'Hd')->getConfig($cid);
        $key = json_decode($info[0]['value'],true)['key'];
        //$secret = json_decode($info[0]['value'],true)['secret'];
       // $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=$key&secret=".$secret;
//        var_dump($this->https_request($url));
       // $_SESSION['company_id'] = $cid;
//        $redirect = urlencode("http://mmcms.kuanjiedai.com/index.php?s=api&c=weixin&m=redirect&cid=$cid&url=$urlId");
        $redirect = urlencode("http://yx.kouhaobang.com/index.php?s=api&c=weixin&m=redirect&cid=$cid&url=$urlId");
        $url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=$key&redirect_uri=".$redirect."&response_type=code&scope=snsapi_userinfo&state=STATE#wechat_redirect";
        return redirect($url);
    }

    public function redirect(){
        $info = \Phpcmf\Service::M('Config', 'Hd')->getConfig($_GET['cid']);
        $key = json_decode($info[0]['value'],true)['key'];
        $secret = json_decode($info[0]['value'],true)['secret'];
       /*用户信息保存*/
        $code = $_GET['code'];
        $res = $this->getInfoFromCode($key,$secret,$code);
        //跳转至活动页面
        $info = \Phpcmf\Service::M('Config', 'Hd')->getRedirectUrl($_GET['url']);
        $url = $info[0]['url'];
        return redirect($url.'&openid='.$res);
    }

    /**
     * @param $key
     * @param $secret
     * @param $code
     * @return mixed
     * 通过code 拉取用户信息
     */
    public function getInfoFromCode($key,$secret,$code){
        $url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=$key&secret=$secret&code=$code&grant_type=authorization_code";
        $res = json_decode($this->https_request($url),true);
        $access_token = $res['access_token'];
        $openid = $res['openid'];
        $url = "https://api.weixin.qq.com/sns/userinfo?access_token=$access_token&openid=$openid&lang=zh_CN";
        $info = json_decode($this->https_request($url),true);
        //用户信息检查
        $res = \Phpcmf\Service::M('Config', 'Hd')->setUser($info);
        return $info['openid'];
    }

    /**
     * 分享次数奖励
     */
    public function setShareTimes()
    {
        if($_POST['openid']) {
            $uid = \Phpcmf\Service::M('Config', 'Hd')->getUser($_POST['openid']);
            $data['uid'] = $uid[0]['id'];
            $data['share_url'] = $_POST['url'];
            $data['hd_id'] = $_POST['id'];
            $data['create_time'] = time();
            $res = \Phpcmf\Service::M('Config', 'Hd')->setShareTimes($data);
            return $res;
        }
    }

}