<?php namespace Phpcmf\Controllers\Member;

// 内容互动
class Content extends \Phpcmf\Table
{
    public $module;
    public $my_module;

    public function __construct(...$params)
    {
        parent::__construct(...$params);
        $this->module = \Phpcmf\Service::L('cache')->get('module-'.SITE_ID.'-content');
        if (!$this->module) {
            $this->_msg(0, dr_lang('系统还没有可用的内容模块'));
            exit;
        }
        $dir = \Phpcmf\Service::L('Input')->get('module');
        if (!$dir || !isset($this->module[$dir])) {
            $one = reset($this->module);
            $this->my_module = $one['dirname'];
        } else {
            $this->my_module = $dir;
        }
    }

    // 模板显示
    private function _display($data) {

        // 初始化变量
        unset($data['param']['module']);
        unset($data['param']['total']);
        unset($data['param']['order']);

        // 列出内容模块
        foreach ($this->module as $i => $t) {
            $data['param']['module'] = $i;
            $this->module[$i]['url'] =\Phpcmf\Service::L('Router')->member_url('member/content/'.\Phpcmf\Service::L('Router')->method, $data['param']);
        }

        $list = [];
        if ($data['list']) {
            foreach ($data['list'] as $i => $t) {
                $t['url'] = dr_url_prefix($t['url'], $this->my_module);
                $list[] = $t;
            }
        }

        \Phpcmf\Service::V()->assign([
            'list' => $list,
            'module' => $this->module,
            'my_module' => $this->my_module,
            'del_url' =>\Phpcmf\Service::L('Router')->member_url('member/content/delete', [
                'module' => $this->my_module,
                'action' =>\Phpcmf\Service::L('Router')->method
            ])
        ]);
        \Phpcmf\Service::V()->display('content_'.\Phpcmf\Service::L('Router')->method.'.html');
    }

    /**
     * 删除
     */
    public function delete() {

        !IS_POST && $this->_json(0, dr_lang('请求错误'));

        $ids = \Phpcmf\Service::L('Input')->get_post_ids();
        !$ids && $this->_json(0, dr_lang('所选数据不存在'));

        // 格式化
        $in = [];
        foreach ($ids as $i) {
            $i && $in[] = intval($i);
        }

        !$in && $this->_json(0, dr_lang('所选数据不存在'));


        $table = dr_module_table_prefix($this->my_module);
        $action = \Phpcmf\Service::L('Input')->get('action');
        switch ($action) {

            case 'support':
                // 跳转到module方法
                goto module;
                break;

            case 'oppose':
                // 跳转到module方法
                goto module;
                break;

            case 'favorite':
                module:
                // 收藏夹
                \Phpcmf\Service::M()->db->table($table.'_'.$action)->where('uid', $this->uid)->whereIn('cid', $in)->delete();
                break;

            default:
                $this->_json(0, dr_lang('未知项目'));
                break;

        }

        $this->_json(1, dr_lang('操作成功'));
    }


    /**
     * 收藏
     */
    public function favorite() {

        $table = dr_module_table_prefix($this->my_module);
        $this->_init([
            'table' => $table,
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
            'where_list' => '`id` IN (select cid from `'.\Phpcmf\Service::M()->dbprefix($table).'_'.\Phpcmf\Service::L('Router')->method.'` where `uid`='.$this->uid.')',
        ]);

        list($tpl, $data) = $this->_List();

        $this->_display($data);
    }


    /**
     * 支持
     */
    public function support() {

        $table = dr_module_table_prefix($this->my_module);
        $this->_init([
            'table' => $table,
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
            'where_list' => '`id` IN (select cid from `'.\Phpcmf\Service::M()->dbprefix($table).'_'.\Phpcmf\Service::L('Router')->method.'` where `uid`='.$this->uid.')',
        ]);

        list($tpl, $data) = $this->_List();

        $this->_display($data);
    }

    /**
     * 反对
     */
    public function oppose() {

        $table = dr_module_table_prefix($this->my_module);
        $this->_init([
            'table' => $table,
            'order_by' => 'inputtime desc',
            'date_field' => 'inputtime',
            'where_list' => '`id` IN (select cid from `'.\Phpcmf\Service::M()->dbprefix($table).'_'.\Phpcmf\Service::L('Router')->method.'` where `uid`='.$this->uid.')',
        ]);

        list($tpl, $data) = $this->_List();

        $this->_display($data);
    }

    /**
     * 打赏
     */
    public function donation() {

        $table = dr_module_table_prefix($this->my_module);
        $this->_init([
            'table' => $table,
            'order_by' => 'inputtime desc',
            'where_list' => '`id` IN (select cid from `'.\Phpcmf\Service::M()->dbprefix($table).'_'.\Phpcmf\Service::L('Router')->method.'` where `uid`='.$this->uid.')',
        ]);

        list($tpl, $data) = $this->_List();


        $this->_display($data);
    }

    /**
     * 评论
     */
    public function comment() {

        $table = dr_module_table_prefix($this->my_module);
        $this->_init([
            'table' => $table.'_comment',
            'select_list' => $table.'_comment.*,'.$table.'.title,'.$table.'.url',
            'order_by' => $table.'_comment.inputtime desc',
            'join_list' => [$table, $table.'.id='.$table.'_comment.cid', 'left'],
            'where_list' => $table.'_comment.uid='.$this->uid.'',
        ]);

        list($tpl, $data) = $this->_List();

        $this->_display($data);
    }

}
