<?php namespace Phpcmf\Controllers\Member;

// 充值
class Recharge extends \Phpcmf\Common
{

    /**
     * 在线充值
     */
    public function index() {
        define('FC_PAY', 1);
        $value = max(floatval(\Phpcmf\Service::L('Input')->get('value')), floatval($this->member_cache['pay']['min']));
        \Phpcmf\Service::V()->assign([
            'payfield' => dr_payform('recharge', $value ? $value : '', '', '', 1),
        ]);
        \Phpcmf\Service::V()->display('recharge_index.html');
    }

    /**
     * 会员升级
     */
    public function member()
    {
        $config = \Phpcmf\Service::M()->db->table("member_product")
            ->where("status",1)
            ->orderby('sort','desc')
            ->get();
        $data =  $config->getResultArray();
        if($data){
            \Phpcmf\Service::V()->assign([
                'data'=>$data
            ]);
        }
        \Phpcmf\Service::V()->display('member.html');
    }

    /**
     * 付款页面
     */
    public function pay()
    {
        $type = $_GET['type'];
        $uid = $_SESSION['uid'];
        $res = \Phpcmf\Service::M('MemberOrder', 'Hd')->checkOrder($uid,$type);
        \Phpcmf\Service::V()->assign([
            'res'=>$res
        ]);
        \Phpcmf\Service::V()->display('pay.html');
    }
}
