<?php namespace Phpcmf\Home;

// 用于前端模块内容显示
class Module extends \Phpcmf\Common
{
    public $module; // 模块信息

    // 模块首页
    protected function _Index($html = 0) {

        // 初始化模块
        $this->_module_init();

        // 共享模块时禁止访问首页
        IS_SHARE && exit($this->goto_404_page(dr_lang('共享模块没有首页功能')));

        // 判断URL重复问题
        !$html && \Phpcmf\Service::L('Router')->is_redirect_url(dr_url_prefix(MODULE_URL, MOD_DIR));

        // 模板变量
        \Phpcmf\Service::V()->assign([
            'indexm' => 1,
            'markid' => 'module-'.MOD_DIR,
        ]);
        \Phpcmf\Service::V()->assign(\Phpcmf\Service::L('Seo')->module($this->module));

        // 系统开启静态首页
        if (!defined('SC_HTML_FILE') && $this->module['setting']['module_index_html']) {

            ob_start();
            \Phpcmf\Service::V()->display('index.html');
            $html = ob_get_clean();

            if ($this->module['domain']) {
                // 绑定域名时
                $file = 'index.html';
            } else {
                $file = ltrim(\Phpcmf\Service::L('Router')->remove_domain(MODULE_URL), '/'); // 从地址中获取要生成的文件名;
            }

            if (!$file) {
                echo $html;exit;
            }


            if (\Phpcmf\Service::IS_PC()) {
                // 电脑端访问
                file_put_contents(\Phpcmf\Service::L('html')->get_webpath(SITE_ID, MOD_DIR, $file), $html);
                // 生成移动端
                ob_start();
                \Phpcmf\Service::V()->init(1);
                \Phpcmf\Service::V()->display('index.html');
                file_put_contents(\Phpcmf\Service::L('html')->get_webpath(SITE_ID, MOD_DIR, 'mobile/'.$file), ob_get_clean());
            } else {
                // 移动端访问
                file_put_contents(\Phpcmf\Service::L('html')->get_webpath(SITE_ID, MOD_DIR, 'mobile/'.$file), $html);
                // 生成电脑端
                ob_start();
                \Phpcmf\Service::V()->init(0);
                \Phpcmf\Service::V()->display('index.html');
                file_put_contents(\Phpcmf\Service::L('html')->get_webpath(SITE_ID, MOD_DIR, $file), ob_get_clean());
            }

            echo $html;
        } else {
            \Phpcmf\Service::V()->display('index.html');
        }
    }

    // 模块打赏
    protected function _Donation($id = 0, $rt = 0) {

        !$id && $id = intval(\Phpcmf\Service::L('Input')->get('id'));

        // 初始化模块
        $this->_module_init();
        define('SC_HTML_FILE', 1); // 不跳转
        $data = $this->_Show($id, [], 1, 1);

        if ($rt) {
            return $data;
        }

        \Phpcmf\Service::V()->assign('meta_title', dr_lang('打赏作者').SITE_SEOJOIN.\Phpcmf\Service::V()->get_value('meta_title'));
        \Phpcmf\Service::V()->display('donation.html');
    }

    // 模块栏目页
    protected function _Category($catid = 0, $catdir = null, $page = 1) {

        if ($catid) {
            $category = $this->module['category'][$catid];
            if (!$category) {
                $this->goto_404_page(dr_lang('模块【%s】栏目（%s）不存在', MOD_DIR, $catid));
                return;
            }
        } elseif ($catdir) {
            $catid = intval($this->module['category_dir'][$catdir]);
            $category = $this->module['category'][$catid];
            if (!$category) {
                // 无法通过目录找到栏目时，尝试多及目录
                foreach ($this->module['category'] as $t) {
                    if ($t['setting']['urlrule']) {
                        $rule = \Phpcmf\Service::L('cache')->get('urlrule', $t['setting']['urlrule']);
                        $rule['value']['catjoin'] = '/';
                        if ($rule['value']['catjoin'] && strpos($catdir, $rule['value']['catjoin'])) {
                            $catdir = trim(strchr($catdir, $rule['value']['catjoin']), $rule['value']['catjoin']);
                            if (isset($this->module['category_dir'][$catdir])) {
                                $catid = $this->module['category_dir'][$catdir];
                                $category = $this->module['category'][$catid];
                                break;
                            }
                        }
                    }
                }
                // 返回无法找到栏目
                if (!$category) {
                    $this->goto_404_page(dr_lang('模块【%s】栏目（%s）不存在', MOD_DIR, $catdir));
                    return;
                }
            }
        } else {
            $this->goto_404_page(dr_lang('模块【%s】栏目不存在', MOD_DIR));
            return;
        }

        // 判断是否外链
        if ($category['tid'] == 2) {
            dr_redirect(dr_url_prefix($category['url'], MOD_DIR), 'refresh');exit;
        }

        // 单页验证是否存在子栏目，是否将下级第一个单页作为当前页
        if ($category['child'] && $category['setting']['getchild']) {
            $temp = explode(',', $category['childids']);
            if ($temp) {
                foreach ($temp as $i) {
                    if ($i != $catid && $this->module['category'][$i]['show'] && !$this->module['category'][$i]['child']) {
                        $catid = $i;
                        $category = $this->module['category'][$i];
                        // 初始化模块
                        $this->_module_init($category['mid'] ? $category['mid'] : 'share');
                        break;
                    }
                }
            }
        }

        // 跳转到搜索页面
        if (!defined('SC_HTML_FILE')
            && isset($this->module['setting']['search']['catsync'])
            && $this->module['setting']['search']['catsync']
            && $category['tid'] == 1) {
            return $this->_Search($catid);
        }

        // 无权限访问栏目
        if (IS_SHARE && $category['tid'] == 0) {
            // 识别栏目单网页
            if (!dr_member_auth($this->member_authid, $this->member_cache['auth_module'][SITE_ID]['share']['category'][$catid]['show'])) {
                $this->_msg(0, dr_lang('您的用户组无权限访问栏目'));
                return;
            }
        } else {
            if (!dr_member_auth($this->member_authid, $this->member_cache['auth_module'][SITE_ID][MOD_DIR]['category'][$catid]['show'])) {
                $this->_msg(0, dr_lang('您的用户组无权限访问栏目'));
                return;
            }
        }

        // 判断内容唯一性
        \Phpcmf\Service::L('Router')->is_redirect_url(dr_url_prefix($category['url'], MOD_DIR));

        // 获取同级栏目及父级栏目
        list($parent, $related) = dr_related_cat(
            !IS_SHARE ? $this->module['category'] : \Phpcmf\Service::L('cache')->get('module-'.SITE_ID.'-share', 'category'),
            $catid
        );

        // 格式化字段
        $this->module['category_field']['content'] = [
            'name' => dr_lang('栏目内容'),
            'ismain' => 1,
            'fieldtype' => 'Ueditor',
            'fieldname' => 'content',
            'setting' => array(
                'option' => array(
                    'mode' => 1,
                    'height' => 300,
                    'width' => '100%'
                )
            ),
        ];

        $category = \Phpcmf\Service::L('Field')->format_value($this->module['category_field'], $category, $page);

        \Phpcmf\Service::V()->assign(\Phpcmf\Service::L('Seo')->category($this->module, $catid, $page));
        \Phpcmf\Service::V()->assign(array(
            'id' => $catid,
            'cat' => $category,
            'page' => $page,
            'catid' => $catid,
            'params' => ['catid' => $catid],
            'markid' => 'module-'.MOD_DIR.'-'.$catid,
            'top' => $category['topid'] ? $this->module['category'][$category['topid']] : $category,
            'parent' => $parent,
            'related' => $related,
            'urlrule' =>\Phpcmf\Service::L('Router')->category_url($this->module, $category, '[page]'),
        ));

        // 识别栏目单网页模板
        if (IS_SHARE && $category['tid'] == 0) {
            \Phpcmf\Service::V()->assign($category);
            \Phpcmf\Service::V()->assign(array(
                'pageid' => $catid,
            ));
            $tpl = !$category['setting']['template']['page'] ? 'page.html' : $category['setting']['template']['page'];
        } else {
            \Phpcmf\Service::V()->module(MOD_DIR);
            $tpl = $category['child'] ? $category['setting']['template']['category'] : $category['setting']['template']['list'];
        }
        \Phpcmf\Service::V()->display($tpl);
    }

    // 模块搜索
    protected function _Search($_catid = 0) {


        // 模型类
        $search = \Phpcmf\Service::M('Search', MOD_DIR)->init(MOD_DIR);

        // 搜索参数
        list($catid, $get) = $search->get_param($this->module);
        !$catid && $_catid && $catid = $_catid;
        $catid = intval($catid);

        // 非http请求之下
        if (!IS_API_HTTP) {
            if (!isset($this->module['setting']['search']['use']) || !$this->module['setting']['search']['use']) {
                exit($this->_msg(0, dr_lang('此模块已经关闭了搜索功能')));
            } elseif (!dr_member_auth($this->member_authid, $this->member_cache['auth_module'][SITE_ID][MOD_DIR]['home'])) {
                exit($this->_msg(0, dr_lang('您的用户组无权限搜索')));
            } elseif ($get['keyword'] && strlen($get['keyword']) < (int)$this->module['setting']['search']['length']) {
                exit($this->_msg(0, dr_lang('关键字不得少于系统规定的长度')));
            } elseif (strlen($get['keyword']) > 100) {
                exit($this->_msg(0, dr_lang('关键字太长了')));
            }
        }

        // 搜索数据
        $data = $search->get($this->module, $get, $catid);
        isset($data['code']) && $data['code'] == 0 && $data['msg'] && exit($this->_msg(0, $data['msg']));
        unset($data['params']['page']);

        // 获取同级栏目及父级栏目
        list($parent, $related) = dr_related_cat(
            !IS_SHARE ? $this->module['category'] : \Phpcmf\Service::L('cache')->get('module-'.SITE_ID.'-share', 'category'),
            $catid
        );

        $sototal = $data['contentid'] ? substr_count($data['contentid'], ',') + 1 : 0;

        $list = [];
        if (IS_API_HTTP && $data['id']) {
            // 移动端请求时
            $pagesize = intval($_GET['pagesize']);
            $tag = 'search module='.MOD_DIR.' id='.$data['id'].' total='.$sototal.' order='.$data['params']['order'].' catid='.$catid.' more=1 page=1 pagesize='.$pagesize.' urlrule=test';

            $rt = \Phpcmf\Service::V()->list_tag($tag);
            $list = $rt['return'];
        }

        \Phpcmf\Service::V()->assign(\Phpcmf\Service::L('Seo')->search($this->module, $catid, $data['params'], $get['page']));
        \Phpcmf\Service::V()->assign(array(
            'cat' => $this->module['category'][$catid],
            'get' => $get,
            'list' => $list,
            'catid' => $catid,
            'parent' => $parent,
            'params' => $data['params'],
            'keyword' => $data['keyword'],
            'related' => $related,
            'urlrule' => \Phpcmf\Service::L('Router')->search_url($data['params'], 'page', '{page}'),
            'sototal' => $sototal,
            'searchid' => $data['id'],
            'search_id' => $data['id'],
            'search_sql' => $data['sql'],
        ));
        \Phpcmf\Service::V()->module(MOD_DIR);

        // 挂钩点 搜索完成之后
        \Phpcmf\Hooks::trigger('module_search_data', $data);

        \Phpcmf\Service::V()->display($catid && $this->module['category'][$catid]['setting']['template']['search'] ? $this->module['category'][$catid]['setting']['template']['search'] : 'search.html');
    }

    // 模块内容页
    // $param 自定义字段检索
    protected function _Show($id = 0, $param = [], $page = 1, $rt = 0) {

        // 通过自定义字段查找id
        !$id && isset($param['field']) && $this->module['field'][$param['field']]['ismain'] && $id = $this->content_model->find_id($param['field'], $param['value']);

        $name = 'module_'.MOD_DIR.'_show_id_'.$id;
        $data = \Phpcmf\Service::L('cache')->init()->get($name);
        if (!$data) {
            $data = $this->content_model->get_data($id);
            if (!$data) {
                $this->goto_404_page(dr_lang('%s内容(#%s)不存在', $this->module['name'], $id));
                return;
            }

            // 检测转向字段
            foreach ($this->module['field'] as $t) {
                if ($t['fieldtype'] == 'Redirect' && $data[$t['fieldname']]) {
                    // 存在转向字段时的情况
                    \Phpcmf\Service::M()->db->table(SITE_ID.'_'.MOD_DIR)->where('id', $id)->set('hits', 'hits+1', FALSE)->update();
                    \Phpcmf\Service::V()->assign('gotu_url', $data[$t['fieldname']]);
                    \Phpcmf\Service::V()->display('go', 'admin');
                    return;
                }
            }

            // 处理关键字标签
            $data['tag'] = $data['keywords'];
            $data['tags'] = [];
            if ($data['keywords']) {
                $tag = explode(',', $data['keywords']);
                foreach ($tag as $t) {
                    $t = trim($t);
                    $t && $data['tags'][$t] = $this->content_model->get_tag_url($t);
                }
            }

            // 上一篇文章
            $builder = \Phpcmf\Service::M()->db->table($this->content_model->mytable);
            $builder->where('catid', (int)$data['catid'])->where('status', 9);
            $builder->where('id<', $id)->orderBy('id desc');
            $data['prev_page'] = $builder->limit(1)->get()->getRowArray();

            // 下一篇文章
            $builder = \Phpcmf\Service::M()->db->table($this->content_model->mytable);
            $builder->where('catid', (int)$data['catid'])->where('status', 9);
            $builder->where('id>', $id)->orderBy('id asc');
            $data['next_page'] = $builder->limit(1)->get()->getRowArray();

            // 格式化输出自定义字段
            $fields = $this->module['category'][$data['catid']]['field'] ? array_merge($this->module['field'], $this->module['category'][$data['catid']]['field']) : $this->module['field'];
            $fields['inputtime'] = ['fieldtype' => 'Date'];
            $fields['updatetime'] = ['fieldtype' => 'Date'];

            // 格式化字段
            $data = \Phpcmf\Service::L('Field')->format_value($fields, $data, $page);

            // 模块的回调处理
            $data = $this->_call_show($data);

            // 缓存结果
            $data['uid'] != $this->uid && \Phpcmf\Service::L('cache')->init()->save($name, $data, SYS_CACHE_SHOW * 3600);
        }

        // 挂钩点 内容读取之后
        \Phpcmf\Hooks::trigger('module_show_read_data', $data);

        // 状态判断
        if ($data['status'] == 10 && !($this->uid == $data['uid'] || $this->member['is_admin'])) {
            $this->goto_404_page(dr_lang('内容被删除，暂时无法访问'));
            return;
        }

        $catid = $data['catid'];

        // 无权限访问栏目内容
        if (!dr_member_auth($this->member_authid, $this->member_cache['auth_module'][SITE_ID][MOD_DIR]['category'][$catid]['show'])) {
            $this->_msg(0, dr_lang('您的用户组无权限访问栏目'));
            return;
        }

        // 判断是否同步栏目
        if ($data['link_id'] && $data['link_id'] > 0) {
            \Phpcmf\Service::V()->assign('gotu_url', dr_url_prefix($data['url'], MOD_DIR));
            \Phpcmf\Service::V()->display('go.html', 'admin');
            return;
        }

        // 判断分页
        if ($page && $data['content_page'] && !$data['content_page'][$page]) {
            $this->goto_404_page(dr_lang('该分页不存在'));
            return;
        }

        // 判断内容唯一性
        !$rt && \Phpcmf\Service::L('Router')->is_redirect_url(dr_url_prefix($data['url'], MOD_DIR));

        // 获取同级栏目及父级栏目
        list($parent, $related) = dr_related_cat(
            !IS_SHARE ? $this->module['category'] : \Phpcmf\Service::L('cache')->get('module-'.SITE_ID.'-share', 'category'),
            $data['catid']
        );

        \Phpcmf\Service::V()->assign($data);
        \Phpcmf\Service::V()->assign(\Phpcmf\Service::L('Seo')->show($this->module, $data, $page));
        \Phpcmf\Service::V()->assign([
            'cat' => $this->module['category'][$data['catid']],
            'page' => $page,
            'params' => ['catid' => $catid],
            'parent' => $parent,
            'markid' => 'module-'.MOD_DIR.'-'.$catid,
            'related' => $related,
            'urlrule' =>\Phpcmf\Service::L('Router')->show_url($this->module, $data, '[page]'),
        ]);
        \Phpcmf\Service::V()->module(MOD_DIR);
        !$rt && (\Phpcmf\Service::V()->display(isset($data['template']) && strpos($data['template'], '.html') !== FALSE ? $data['template'] : ($this->module['category'][$data['catid']]['setting']['template']['show'] ? $this->module['category'][$data['catid']]['setting']['template']['show'] : 'show.html')));
        return $data;
    }

    // 模块草稿、审核、定时、内容页
    protected function _MyShow($type, $id = 0, $page = 1) {

        switch($type) {

            case 'time':
                $row = \Phpcmf\Service::M()->table(SITE_ID.'_'.MOD_DIR.'_time')->get($id);
                $data = dr_string2array($row['content']);
                !$data && $this->_msg(0, dr_lang('定时内容#%s不存在', $id));
                ($this->uid != $data['uid'] || !$this->member['is_admin']) && $this->_msg(0, dr_lang('定时内容只能自己访问'));
                break;

            case 'recycle':
                $row = \Phpcmf\Service::M()->table(SITE_ID.'_'.MOD_DIR.'_recycle')->get($id);
                $row = dr_string2array($row['content']);
                !$row && $this->_msg(0, dr_lang('回收站内容#%s不存在', $id));
                !$row[SITE_ID.'_'.MOD_DIR] && $this->_msg(0, dr_lang('回收站内容#%s格式不规范', $id));
                !$this->member['is_admin'] && $this->_msg(0, dr_lang('无权限访问'));
                $data = $row[SITE_ID.'_'.MOD_DIR];
                isset($row[SITE_ID.'_'.MOD_DIR.'_data_'.intval($data['tableid'])])
                && $row[SITE_ID.'_'.MOD_DIR.'_data_'.intval($data['tableid'])]
                && $data = array_merge($data, $row[SITE_ID.'_'.MOD_DIR.'_data_'.intval($data['tableid'])]);
                break;

            case 'verify':
                $row = \Phpcmf\Service::M()->table(SITE_ID.'_'.MOD_DIR.'_verify')->get($id);
                $data = dr_string2array($row['content']);
                !$data && $this->_msg(0, dr_lang('审核内容#%s不存在', $id));
                ($this->uid != $data['uid'] || !$this->member['is_admin']) && $this->_msg(0, dr_lang('无权限访问'));
                break;

            case 'draft':
                $row = \Phpcmf\Service::M()->table(SITE_ID.'_'.MOD_DIR.'_draft')->get($id);
                $data = dr_string2array($row['content']);
                !$data && $this->_msg(0, dr_lang('草稿内容#%s不存在', $id));
                ($this->uid != $data['uid'] || !$this->member['is_admin']) && $this->_msg(0, dr_lang('无权限访问'));
                break;

            default:
                $this->_msg(0, dr_lang('未定义的操作'));exit;
        }

        $data['id'] = 0;

        // 处理关键字标签
        $data['tag'] = $data['keywords'];
        $data['keyword_list'] = [];
        if ($data['keywords']) {
            $data['keywords'] = explode(',', $data['keywords']);
            foreach ($data['keywords'] as $t) {
                $t = trim($t);
                $t && $data['keyword_list'][$t] = $this->content_model->get_tag_url($t);
            }
        }

        // 格式化输出自定义字段
        $fields = $this->module['category'][$data['catid']]['field'] ? array_merge($this->module['field'], $this->module['category'][$data['catid']]['field']) : $this->module['field'];
        $fields['inputtime'] = ['fieldtype' => 'Date'];
        $fields['updatetime'] = ['fieldtype' => 'Date'];

        // 格式化字段
        $data = \Phpcmf\Service::L('Field')->app(MOD_DIR)->format_value($fields, $data, $page);

        // 判断分页
        if ($page && $data['content_page'] && !$data['content_page'][$page]) {
            $this->goto_404_page(dr_lang('该分页不存在'));
            return;
        }

        // 获取同级栏目及父级栏目
        list($parent, $related) = dr_related_cat(
            !IS_SHARE ? $this->module['category'] : \Phpcmf\Service::L('cache')->get('module-'.SITE_ID.'-share', 'category'),
            $data['catid']
        );

        \Phpcmf\Service::V()->assign($data);
        \Phpcmf\Service::V()->assign(\Phpcmf\Service::L('Seo')->show($this->module, $data, $page));
        \Phpcmf\Service::V()->assign([
            'cat' => $this->module['category'][$data['catid']],
            'page' => $page,
            'params' => ['catid' => $data['catid']],
            'parent' => $parent,
            'markid' => 'module-'.MOD_DIR.'-'.$data['catid'],
            'related' => $related,
            'urlrule' =>\Phpcmf\Service::L('Router')->show_url($this->module, $data, '[page]'),
        ]);
        \Phpcmf\Service::V()->module(MOD_DIR);
        \Phpcmf\Service::V()->display(isset($data['template']) && strpos($data['template'], '.html') !== FALSE ? $data['template'] : ($this->module['category'][$data['catid']]['setting']['template']['show'] ? $this->module['category'][$data['catid']]['setting']['template']['show'] : 'show.html'));
        return $data;
    }




    //==================生成静态部分 -  创建文件=========================


    // 生成栏目静态页面
    protected function _Create_Category_Html($catid, $page = 0) {
        
        if (!$catid) {
            return dr_return_data(0, '栏目id不存在');
        }
        if (!defined('MODULE_NAME')) {
            return dr_return_data(0, 'MODULE_NAME未定义');
        }

        $cat = $this->module['category'][$catid];
        if (!$cat) {
            return dr_return_data(0, '栏目#'.$catid.'不存在');
        }

        $url = $page > 0 ?\Phpcmf\Service::L('Router')->category_url($this->module, $cat, $page) : $cat['url'];
        $file =\Phpcmf\Service::L('Router')->remove_domain($url); // 从地址中获取要生成的文件名

        $root = \Phpcmf\Service::L('html')->get_webpath(SITE_ID, MOD_DIR);

        $hfile = dr_to_html_file($file, $root);  // 格式化生成文件
        if (!$hfile) {
            return dr_return_data(0, '地址【'.$cat['url'].'】不规范');
        }

        // 标识变量
        !defined('SC_HTML_FILE') && define('SC_HTML_FILE', 1);

        // 开启ob函数
        ob_start();
        $_GET['page'] = $page;
        \Phpcmf\Service::V()->init(0);
        $this->_Category($catid, '', $page);
        $html = ob_get_clean();

        // 无权限访问栏目内容
        if ($this->member_cache['auth_module'][SITE_ID][MOD_DIR]['category'][$catid]['show']) {
            return dr_return_data(0, '开启了栏目访问权限');
        } elseif ($this->member_cache['auth_module'][SITE_ID][MOD_DIR]['home']) {
            return dr_return_data(0, '开启了模块访问权限');
        } elseif ($this->member_cache['auth_site'][SITE_ID]['home']) {
            return dr_return_data(0, '开启了站点访问权限');
        }

        // 格式化生成文件
        if (!@file_put_contents($hfile, $html, LOCK_EX)) {
            return dr_return_data(0, '文件【'.$hfile.'】写入失败');
        }

        // 移动端生成
        if (SITE_IS_MOBILE) {
            ob_start();
            \Phpcmf\Service::V()->init(1);
            $_GET['page'] = $page;
            $this->_Category($catid, '', $page);
            $html = ob_get_clean();

            $hfile = dr_to_html_file($file, $root . 'mobile/');

            $size = file_put_contents($hfile, $html, LOCK_EX);
            if (!$size) {
                return dr_return_data(0, '无权限写入文件【' . $hfile . '】');
            }
        }
        return dr_return_data(1, 'ok');
    }

    // 生成内容静态页面
    protected function _Create_Show_Html($id, $page = 0) {

        if (!$id) {
            return dr_return_data(0, '内容id不存在');
        }

        // 标识变量
        !defined('SC_HTML_FILE') && define('SC_HTML_FILE', 1);

        // 开启ob函数
        ob_start();
        \Phpcmf\Service::V()->init(0);
        \Phpcmf\Service::V()->module(IS_SHARE ? 'share' : MOD_DIR);
        $data = $this->_Show($id, '', $page);
        $html = ob_get_clean();

        // 无权限访问栏目内容
        if ($this->member_cache['auth_module'][SITE_ID][MOD_DIR]['category'][$data['catid']]['show']) {
            return dr_return_data(0, '开启了栏目访问权限');
        } elseif ($this->member_cache['auth_module'][SITE_ID][MOD_DIR]['home']) {
            return dr_return_data(0, '开启了模块访问权限');
        } elseif ($this->member_cache['auth_site'][SITE_ID]['home']) {
            return dr_return_data(0, '开启了站点访问权限');
        }

        // 同步数据不执行生成
        if ($data['link_id'] > 0) {
            return dr_return_data(0, '同步数据不执行生成');
        }

        $url = $page > 0 ?\Phpcmf\Service::L('Router')->show_url($this->module, $data, $page) : $data['url'];
        $file =\Phpcmf\Service::L('Router')->remove_domain($url); // 从地址中获取要生成的文件名

        $root = \Phpcmf\Service::L('html')->get_webpath(SITE_ID, MOD_DIR);
        $hfile = dr_to_html_file($file, $root);  // 格式化生成文件

        if (!$hfile) {
            return dr_return_data(0, '地址【'.$data['url'].'】不规范');
        }

        if (!@file_put_contents($hfile, $html, LOCK_EX)) {
            return dr_return_data(0, '文件【'.$hfile.'】写入失败');
        }

        // 移动端生成
        if (SITE_IS_MOBILE) {
            ob_start();
            \Phpcmf\Service::V()->init(1);
            \Phpcmf\Service::V()->module(IS_SHARE ? 'share' : MOD_DIR);
            $data = $this->_Show($id, '', $page);
            $html = ob_get_clean();
            $hfile = dr_to_html_file($file, $root.'mobile/');
            $size = file_put_contents($hfile, $html, LOCK_EX);
            if (!$size) {
                return dr_return_data(0, '无权限写入文件【'.$hfile.'】');
            }

            if ($page == 0 && $data['content_page']) {
                // 生成分页的页面
                foreach ($data['content_page'] as $i => $t) {
                    $this->_Create_Show_Html($id, $i);
                }
            }
        }


        return dr_return_data(1, 'ok');
    }


    //==================生成静态部分 - 单个文件生成（继承，用于增加修改时实时生成）=========================


    // 生成栏目静态页
    protected function _Category_Html_File() {

        // 判断权限
        !dr_html_auth() && $this->_json(0, '权限验证超时，请重新执行生成');

        // 初始化模块
        $this->_module_init();

        $this->member_cache['auth_site'][SITE_ID]['home'] && $this->_json(0, '当前网站设置了访问权限，无法生成静态');
        $this->member_cache['auth_module'][SITE_ID][MOD_DIR]['home'] && $this->_json(0, '当前模块设置了访问权限，无法生成静态');

        $this->_Create_Category_Html(intval(\Phpcmf\Service::L('Input')->get('id')));
        exit;

    }

    // 生成内容静态单页
    protected function _Show_Html_File() {

        // 判断权限
        !dr_html_auth() && $this->_json(0, '权限验证超时，请重新执行生成');

        // 初始化模块
        $this->_module_init();

        $this->member_cache['auth_site'][SITE_ID]['home'] && $this->_json(0, '当前网站设置了访问权限，无法生成静态');
        $this->member_cache['auth_module'][SITE_ID][MOD_DIR]['home'] && $this->_json(0, '当前模块设置了访问权限，无法生成静态');

        $this->_Create_Show_Html(intval(\Phpcmf\Service::L('Input')->get('id')));
        exit;
    }


    //==================生成静态部分 - 后台操作Ajax生成执行=========================


    // 生成首页静态选项
    protected function _Index_Html() {

        // 判断权限
        !dr_html_auth() && $this->_json(0, '权限验证超时，请重新执行生成');

        $this->member_cache['auth_site'][SITE_ID]['home'] && $this->_json(0, '当前网站设置了访问权限，无法生成静态');
        $this->member_cache['auth_module'][SITE_ID][APP_DIR]['home'] && $this->_json(0, '当前模块设置了访问权限，无法生成静态');

        // 标识变量
        !defined('SC_HTML_FILE') && define('SC_HTML_FILE', 1);

        !$this->module && $this->_module_init();
        !$this->module['setting']['module_index_html'] && $this->_json(0, '当前模块未开启首页静态功能');


        if ($this->module['domain']) {
            // 绑定域名时
            $file = 'index.html';
        } else {
            $file = ltrim(\Phpcmf\Service::L('Router')->remove_domain(MODULE_URL), '/'); // 从地址中获取要生成的文件名;
            !$file && $this->_json(0, dr_lang('生成文件名不合法: %s', MODULE_URL));
        }

        // 生成静态文件
        ob_start();
        $this->_Index(1);
        $html = ob_get_clean();
        $pc = file_put_contents(\Phpcmf\Service::L('html')->get_webpath(SITE_ID, MOD_DIR, $file), $html, LOCK_EX);

        if (SITE_IS_MOBILE) {
            ob_start();
            \Phpcmf\Service::V()->init(1);
            $this->_Index(1);
            $html = ob_get_clean();
            $mobile = file_put_contents(\Phpcmf\Service::L('html')->get_webpath(SITE_ID, MOD_DIR, 'mobile/' . $file), $html, LOCK_EX);
        }

        $this->_json(1, dr_lang('电脑端 （%s），移动端 （%s）', dr_format_file_size($pc), dr_format_file_size($mobile)));
    }

    // 生成内容静态选项
    protected function _Show_Html() {

        // 判断权限
        !dr_html_auth() && $this->_json(0, '权限验证超时，请重新执行生成');

        $page = max(1, intval($_GET['pp']));
        $name = 'show-'.APP_DIR.'-html-file';
        $cache = \Phpcmf\Service::L('cache')->init()->get($name);
        !$cache && $this->_json(0, '临时缓存数据缓存不存在'.$name);

        $data = $cache[$page];
        if ($data) {
            $html = '';
            foreach ($data as $t) {

                // 初始化模块
                !$this->module && $this->_module_init(APP_DIR);

                $class = '';
                if (!$this->module) {
                    $ok = "<a class='error' href='".$t['url']."' target='_blank'>模块".$t['mid']."未被初始化</a>";
                    $class = ' p_error';
                } elseif (!$this->module['category'][$t['catid']]['setting']['html']) {
                    $ok = "<a class='error' href='".$t['url']."' target='_blank'>它是动态模式</a>";
                    $class = ' p_error';
                } elseif ($this->member_cache['auth_site'][SITE_ID]['page'][$t['id']]['show']) {
                    $ok = "<a class='error' href='".$t['url']."' target='_blank'>设置的有访问权限</a>";
                    $class = ' p_error';
                } else {
                    $rt = $this->_Create_Show_Html($t['id']);
                    if ($rt['code']) {
                        $ok = "<a class='ok' href='".$t['url']."' target='_blank'>生成成功</a>";
                    } else {
                        $ok = "<a class='error' href='".$t['url']."' target='_blank'>".$rt['msg']."</a>";
                        $class = ' p_error';
                    }

                }

                $html.= '<p class="'.$class.'"><label class="rleft">'.$t['title'].'</label><label class="rright">'.$ok.'</label></p>';

            }
            $this->_json($page + 1, $html);
        }

        // 完成
        \Phpcmf\Service::L('cache')->clear($name);
        $this->_json(100, '');
    }

    // 生成内容静态选项
    protected function _Category_Html() {

        // 判断权限
        !dr_html_auth() && $this->_json(0, '权限验证超时，请重新执行生成');

        $page = max(1, intval($_GET['pp']));
        $name = 'category-'.APP_DIR.'-html-file';
        $cache = \Phpcmf\Service::L('cache')->init()->get($name);
        !$cache && $this->_json(0, '临时缓存数据缓存不存在'.$name);

        $data = $cache[$page];
        if ($data) {
            $html = '';
            foreach ($data as $t) {

                // 初始化模块
                !$this->module && $this->_module_init($t['mid'] ? $t['mid'] : 'share');

                $class = '';
                if (!$this->module) {
                    $ok = "<a class='error' href='".$t['url']."' target='_blank'>模块".$t['mid']."未被初始化</a>";
                    $class = ' p_error';
                } elseif (!$t['html']) {
                    $ok = "<a class='error' href='".$t['url']."' target='_blank'>它是动态模式</a>";
                    $class = ' p_error';
                } elseif ($this->member_cache['auth_site'][SITE_ID]['page'][$t['id']]['show']) {
                    $ok = "<a class='error' href='".$t['url']."' target='_blank'>设置的有访问权限</a>";
                    $class = ' p_error';
                } else {
                    $rt = $this->_Create_Category_Html($t['id'], $t['page']);
                    if ($rt['code']) {
                        $ok = "<a class='ok' href='".$t['url']."' target='_blank'>生成成功</a>";
                    } else {
                        $ok = "<a class='error' href='".$t['url']."' target='_blank'>".$rt['msg']."</a>";
                        $class = ' p_error';
                    }

                }
                $html.= '<p class="'.$class.'"><label class="rleft">'.$t['name'].'</label><label class="rright">'.$ok.'</label></p>';

            }
            $this->_json($page + 1, $html);
        }

        // 完成
        \Phpcmf\Service::L('cache')->clear($name);
        $this->_json(100, '');
    }

    // 前端模块回调处理类
    protected function _Call_Show($data) {

        return $data;
    }




}
