<?php
namespace Phpcmf\Extend;

/**
 * 继承异常类，用于Services.php
 */

class Exceptions extends \CodeIgniter\Debug\Exceptions
{

    /**
     * 排除部分错误提示
     */
    public function errorHandler( $severity,  $message,  $file = null,  $line = null, $context = null)
    {

        if (!in_array($severity, [E_NOTICE, E_WARNING])) { //E_WARNING
            throw new \ErrorException($message, 0, $severity, $file, $line);
        }
    }

    /**
     * 错误输出结果
     */
    protected function render(\Throwable $exception, int $statusCode)
    {

        $file    = $exception->getFile();
        $line    = $exception->getLine();
        $title   = get_class($exception);
        $message = $exception->getMessage();

        // 前端访问屏蔽敏感信息
        !IS_ADMIN && $message = str_replace([FCPATH, WEBPATH], ['/', '/'], $message);

        if (empty($message)) {
            $message = '(null)';
        } elseif (strpos($message, 'The action you requested is not allowed') !== false) {
            $this->_save_error_file($title, $file, $line, $message);
            dr_exit_msg(0, '防跨站提交验证失败');
        } else {
            $this->_save_error_file($title, $file, $line, $message);
        }

        // ajax 返回
        if (IS_AJAX) {
            dr_exit_msg(0, $message);
        } elseif (IS_DEV) {
            echo $message;
            exit;
        }

        return parent::render($exception, $statusCode);
    }

    private function _save_error_file($title, $file, $line, $message, $is_kz = 0) {

        // 写入错误日志
        $filepath = WRITEPATH.'phperror/'.date('Y-m-d').'.php';
        $newfile = 0;

        $msg = '';
        if (!is_file($filepath) ) {
            $newfile = true;
            $msg .= "<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>\n\n\n";
        }

        if ( $fp = @fopen($filepath, 'ab')) {
            $msg .= date('Y-m-d H:i:s').' --> '.$title."\n";
            $msg .= '文件: '.$file."\n";
            $msg .= '行号: '.$line."\n";
            $msg .= '错误: '.str_replace(PHP_EOL, '<br>', $message)."\n";
            $msg .= json_encode(['html' => $is_kz ? var_export($_POST, true) : self::highlightFile($file, $line)])."\n";
            $msg .= '地址: '.FC_NOW_URL."\n";
            $msg .= "\n\n";
        } else {
            return;
        }

        flock($fp, LOCK_EX);

        for ($written = 0, $length = strlen($msg); $written < $length; $written += $result) {
            if (($result = fwrite($fp, substr($msg, $written))) === false) {
                break;
            }
        }

        flock($fp, LOCK_UN);
        fclose($fp);

        if ($newfile) {
            chmod($filepath, 0777);
        }

        return;
    }
}