<?php namespace Phpcmf\Model;

// 程序插件管理
class App extends \Phpcmf\Model
{

    // 开始安装app
    public function install($dir) {

        $path = APPSPATH.ucfirst($dir);
        if (!is_file($path.'/Config/App.php')) {
            return dr_return_data(0, dr_lang('插件配置文件不存在'));
        }

        // 写入锁定文件
        $rt = file_put_contents($path.'/install.test', SYS_TIME);
        if (!$rt) {
            return dr_return_data(0, 'App/'.ucfirst($dir).'/程序目录无法写入');
        }

        if (is_file($path.'/install.lock')) {
            return dr_return_data(0, dr_lang('此程序已经安装'));
        }

        // 执行sql语句
        if (is_file($path.'/Config/Install.sql')) {
            $rt = $this->query_all(file_get_contents($path.'/Config/Install.sql'));
            if ($rt) {
                return dr_return_data(0, $rt);
            }
        }

        // 执行站点sql语句
        if (is_file($path.'/Config/Install_site.sql')) {
            $sql = file_get_contents($path.'/Config/Install_site.sql');
            foreach ($this->site as $siteid) {
                $rt = $this->query_all(str_replace('{dbprefix}',  $this->dbprefix($siteid.'_'), $sql));
                if ($rt) {
                    return dr_return_data(0, $rt);
                }
            }
        }

        // 执行模块自己的安装程序
        if (is_file($path.'/Config/Install.php')) {
            require $path.'/Config/Install.php';
        }

        // 创建菜单
        \Phpcmf\Service::M('Menu')->add_app($dir);

        // 写入锁定文件
        file_put_contents($path.'/install.lock', SYS_TIME);
        unlink($path.'/install.test');

        return dr_return_data(1, dr_lang('安装成功'));
    }

    // 卸载
    public function uninstall($dir) {

        $path = APPSPATH.ucfirst($dir);

        // 执行sql语句
        if (is_file($path.'/Config/Uninstall.sql')) {
            $rt = $this->query_all(file_get_contents($path.'/Config/Uninstall.sql'));
            if ($rt) {
                return dr_return_data(0, $rt);
            }
        }

        // 执行站点sql语句
        if (is_file($path.'/Config/Uninstall_site.sql')) {
            $sql = file_get_contents($path.'/Config/Uninstall_site.sql');
            foreach ($this->site as $siteid) {
                $rt = $this->query_all(str_replace('{dbprefix}',  $this->dbprefix($siteid.'_'), $sql));
                if ($rt) {
                    return dr_return_data(0, $rt);
                }
            }
        }

        // 执行自己的卸载程序
        if (is_file($path.'/Config/Uninstall.php')) {
            require $path.'/Config/Uninstall.php';
        }

        // 删除菜单
        \Phpcmf\Service::M('Menu')->delete_app($dir);
        unlink($path.'/install.lock');

        return dr_return_data(1, dr_lang('卸载成功'));
    }

}